/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web.utils;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.tai.SocialLoginTAI;
import java.util.Collection;
import java.util.Iterator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigInfoJsonBuilder {
    public static final TraceComponent tc = Tr.register(ConfigInfoJsonBuilder.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String KEY_SOCIAL_MEDIA_ID = "id";
    public static final String KEY_SOCIAL_MEDIA_WEBSITE = "website";
    public static final String KEY_SOCIAL_MEDIA_DISPLAY_NAME = "display-name";
    public static final String KEY_ALL_SOCIAL_MEDIA = "social-media";
    private Iterator<SocialLoginConfig> configIter = null;
    static final long serialVersionUID = 5003102894164186195L;

    public ConfigInfoJsonBuilder(Collection<SocialLoginConfig> configs) {
        this.configIter = configs == null ? null : configs.iterator();
    }

    public ConfigInfoJsonBuilder(Iterator<SocialLoginConfig> configs) {
        this.configIter = configs;
    }

    public JSONObject buildJsonResponse() {
        JSONArray socialMediaList = this.buildSocialMediaList();
        if (socialMediaList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Did not find any social media", (Object[])new Object[0]);
            }
            return new JSONObject();
        }
        JSONObject response = new JSONObject();
        response.put((Object)KEY_ALL_SOCIAL_MEDIA, (Object)socialMediaList);
        return response;
    }

    JSONArray buildSocialMediaList() {
        if (this.configIter == null) {
            return null;
        }
        JSONArray socialMediaList = new JSONArray();
        while (this.configIter.hasNext()) {
            SocialLoginConfig socialLoginConfig = this.configIter.next();
            JSONObject configEntry = this.buildSocialMediumEntry(socialLoginConfig);
            if (configEntry == null) continue;
            socialMediaList.add((Object)configEntry);
        }
        return socialMediaList;
    }

    JSONObject buildSocialMediumEntry(SocialLoginConfig config) {
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No social login config provided", (Object[])new Object[0]);
            }
            return null;
        }
        JSONObject entry = new JSONObject();
        String uid = config.getUniqueId();
        String site = config.getWebsite();
        String displayName = config.getDisplayName();
        if (displayName == null) {
            displayName = uid;
        }
        entry.put((Object)KEY_SOCIAL_MEDIA_ID, (Object)this.getObscuredIdFromConfigId(uid));
        if (site != null) {
            entry.put((Object)KEY_SOCIAL_MEDIA_WEBSITE, (Object)site);
        }
        if (displayName != null) {
            entry.put((Object)KEY_SOCIAL_MEDIA_DISPLAY_NAME, (Object)displayName);
        }
        return entry;
    }

    String getObscuredIdFromConfigId(String configId) {
        return SocialLoginTAI.getObscuredIdFromConfigId(configId);
    }
}

