/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim.rest;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.security.wim.scim.rest.HandlerUtil;
import com.ibm.ws.security.wim.scim.util.GroupSCIMConverter;
import com.ibm.ws.security.wim.util.ControlsHelper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PageControl;
import com.ibm.wsspi.security.wim.model.PageResponseControl;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/scim/Groups"})
public class GroupHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(GroupHandler.class, (String)"SCIMUtil", (String)"com.ibm.ws.security.wim.scim.util.resources.SCIMUtilMessages");
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String PUT = "PUT";
    public static final String KEY_VMM_SERVICE = "VMMService";
    public static final String GROUPS_STRING = "/Groups";
    public static final String GROUPS_SLASH_STRING = "/Groups/";
    public static final int GROUPS_LENGTH = "/Groups/".length();
    private static final AtomicServiceReference<VMMService> VMMServiceRef = new AtomicServiceReference("VMMService");
    static final long serialVersionUID = 517812748443871667L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        VMMServiceRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        VMMServiceRef.deactivate(context);
    }

    @Reference(service=VMMService.class, name="VMMService", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setVMMService(ServiceReference<VMMService> ref) {
        VMMServiceRef.setReference(ref);
    }

    protected void unsetVMMService(ServiceReference<VMMService> ref) {
        VMMServiceRef.unsetReference(ref);
    }

    public static VMMService getVMMService() {
        VMMService service = (VMMService)VMMServiceRef.getServiceWithException();
        return service;
    }

    private String parseGroup(String path) {
        if (path.indexOf(GROUPS_SLASH_STRING) == -1) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path.substring(path.indexOf(GROUPS_SLASH_STRING) + GROUPS_LENGTH);
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        AuditManager auditManager = new AuditManager();
        auditManager.setRESTRequest((Object)request);
        String method = request.getMethod();
        String URL2 = request.getURL();
        String URLPrefix = URL2.substring(0, URL2.indexOf(GROUPS_STRING));
        if (GET.equalsIgnoreCase(method)) {
            String path = request.getPath();
            String id = this.parseGroup(path);
            JSONObject json = null;
            try {
                if ("Groups".equals(id)) {
                    json = this.getGroupList(URLPrefix, request.getParameterMap());
                } else if (id == null || id.isEmpty()) {
                    response.setStatus(400);
                    json = new JSONObject();
                    JSONArray errors = new JSONArray();
                    JSONObject error = new JSONObject();
                    error.put((Object)"description", (Object)Tr.formatMessage((TraceComponent)tc, (String)"MISSING_IDENTIFIER_IN_URL", (Object[])new Object[0]));
                    error.put((Object)"code", (Object)Integer.toString(400));
                    errors.add((Object)error);
                    json.put((Object)"Errors", (Object)errors);
                } else {
                    json = this.getGroup(id, URLPrefix, request.getParameterMap());
                }
            }
            catch (WIMException errors) {
                void ex;
                FFDCFilter.processException((Throwable)errors, (String)"com.ibm.ws.security.wim.scim.rest.GroupHandler", (String)"159", (Object)this, (Object[])new Object[]{request, response});
                json = HandlerUtil.handleException((WIMException)ex, request, response);
            }
            if (json != null) {
                response.getWriter().write(json.toString());
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else if (POST.equalsIgnoreCase(method)) {
            JSONObject inputObject = HandlerUtil.getJSONObject(request);
            if (inputObject == null) {
                response.getWriter().write("No input OBJECT FOUND !!!!");
                response.getWriter().flush();
                response.getWriter().close();
                return;
            }
            JSONObject output = null;
            try {
                output = this.createGroup(inputObject, URLPrefix, request.getParameterMap());
                response.setStatus(201);
            }
            catch (WIMException json) {
                void ex;
                FFDCFilter.processException((Throwable)json, (String)"com.ibm.ws.security.wim.scim.rest.GroupHandler", (String)"185", (Object)this, (Object[])new Object[]{request, response});
                output = HandlerUtil.handleException((WIMException)ex, request, response);
            }
            if (output != null) {
                response.getWriter().write(output.toString());
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else if (DELETE.equalsIgnoreCase(method)) {
            String path = request.getPath();
            String id = this.parseGroup(path);
            try {
                this.deleteGroup(id, URLPrefix);
            }
            catch (WIMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.security.wim.scim.rest.GroupHandler", (String)"201", (Object)this, (Object[])new Object[]{request, response});
                HandlerUtil.handleException(ex, request, response);
            }
        } else if (PUT.equalsIgnoreCase(method)) {
            String path = request.getPath();
            String id = this.parseGroup(path);
            JSONObject inputObject = HandlerUtil.getJSONObject(request);
            if (inputObject == null) {
                response.getWriter().write("No input OBJECT FOUND !!!!");
                response.getWriter().flush();
                response.getWriter().close();
                return;
            }
            JSONObject output = null;
            try {
                output = this.updateGroup(id, inputObject, URLPrefix, request.getParameterMap());
            }
            catch (WIMException error) {
                void ex;
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.security.wim.scim.rest.GroupHandler", (String)"221", (Object)this, (Object[])new Object[]{request, response});
                output = HandlerUtil.handleException((WIMException)ex, request, response);
            }
            if (output != null) {
                response.getWriter().write(output.toString());
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else {
            response.sendError(501, "Service Provider does not support the requested operation");
        }
    }

    private JSONObject getGroupList(String URLPrefix, Map<String, String[]> params) throws WIMException {
        GroupSCIMConverter converter = new GroupSCIMConverter(null);
        Root root = HandlerUtil.getSearchRoot(params, "Group");
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        PageControl pageControl = (PageControl)ctrlMap.get("PageControl");
        VMMService service = GroupHandler.getVMMService();
        root = service.search(root);
        List entities = root.getEntities();
        ctrlMap = ControlsHelper.getControlMap((Root)root);
        PageResponseControl pageResponseControl = (PageResponseControl)ctrlMap.get("PageResponseControl");
        if (HandlerUtil.isAttributeRequested(params, "members")) {
            for (Entity entity : entities) {
                root = this.getGroupByUniqueName(entity.getIdentifier().getUniqueName(), params, converter);
                List entitiesWithMembers = root.getEntities();
                if (entitiesWithMembers == null || entitiesWithMembers.isEmpty()) continue;
                List members = ((Group)entitiesWithMembers.get(0)).getMembers();
                for (Entity member : members) {
                    ((Group)entity).set("members", (Object)member);
                }
            }
        }
        JSONObject json = new JSONObject();
        if (pageResponseControl == null) {
            json.put((Object)"totalResults", (Object)entities.size());
        } else {
            json.put((Object)"totalResults", (Object)pageResponseControl.getTotalSize());
        }
        if (pageControl != null) {
            json.put((Object)"startIndex", (Object)(pageControl.getStartIndex() + 1));
            json.put((Object)"itemsPerPage", (Object)pageControl.getSize());
        }
        JSONArray schemas = new JSONArray();
        schemas.add((Object)"urn:scim:schemas:core:1.0");
        json.put((Object)"schemas", (Object)schemas);
        JSONArray resources = new JSONArray();
        for (Entity entity : entities) {
            JSONObject res = converter.getJSONObject((Group)entity, URLPrefix, false);
            resources.add((Object)res);
        }
        json.put((Object)"Resources", (Object)resources);
        return json;
    }

    private JSONObject getGroup(String groupId, String URLPrefix, Map<String, String[]> params) throws WIMException {
        GroupSCIMConverter converter = new GroupSCIMConverter(null);
        Root root = this.getGroupByUniqueName(groupId, params, converter);
        List entities = root.getEntities();
        if (entities.size() > 0) {
            Group group = (Group)entities.get(0);
            return converter.getJSONObject(group, URLPrefix, true);
        }
        return null;
    }

    private Root getGroupByUniqueName(String uniqueName, Map<String, String[]> params, GroupSCIMConverter converter) throws WIMException {
        Root root = new Root();
        Group group = new Group();
        IdentifierType id = new IdentifierType();
        id.setUniqueName(uniqueName);
        group.setIdentifier(id);
        root.getEntities().add(group);
        PropertyControl propCtrl = HandlerUtil.getPropertyControl(params, converter);
        if (propCtrl == null) {
            propCtrl = new PropertyControl();
            propCtrl.getProperties().add("*");
        }
        root.getControls().add(propCtrl);
        HandlerUtil.setGroupMemberControl(root, params);
        Context trustKey = new Context();
        trustKey.set("key", (Object)"trustEntityType");
        trustKey.set("value", (Object)"true");
        root.getContexts().add(trustKey);
        return GroupHandler.getVMMService().get(root);
    }

    private JSONObject createGroup(JSONObject json, String URLPrefix, Map<String, String[]> params) throws WIMException {
        GroupSCIMConverter converter = new GroupSCIMConverter(null);
        Group group = converter.getGroup(json);
        Root root = new Root();
        root.getEntities().add(group);
        VMMService service = GroupHandler.getVMMService();
        root = service.create(root);
        List entities = root.getEntities();
        if (entities.size() > 0) {
            String userId = ((Entity)entities.get(0)).getIdentifier().getUniqueName();
            return this.getGroup(userId, URLPrefix, params);
        }
        return null;
    }

    private void deleteGroup(String groupId, String uRLPrefix) throws WIMException {
        VMMService service = GroupHandler.getVMMService();
        Root root = new Root();
        Group group = new Group();
        IdentifierType id = new IdentifierType();
        id.setUniqueName(groupId);
        group.setIdentifier(id);
        root.getEntities().add(group);
        service.delete(root);
    }

    private JSONObject updateGroup(String id, JSONObject json, String URLPrefix, Map<String, String[]> params) throws WIMException {
        GroupSCIMConverter converter = new GroupSCIMConverter(null);
        Group group = converter.getGroup(json);
        if (!id.equalsIgnoreCase(group.getIdentifier().getUniqueName())) {
            throw new IllegalArgumentException("The Id of the group cannot be updated.");
        }
        JSONObject existingGroup = this.getGroup(id, URLPrefix, null);
        boolean deleteGroupMembers = false;
        if (existingGroup != null) {
            Set keys = existingGroup.keySet();
            for (String key : keys) {
                String propertyName = converter.getPropertyName(key.toLowerCase());
                if (group.getExtendedPropertyNames() != null && group.getExtendedPropertyNames().contains(key)) {
                    propertyName = key;
                }
                if (group.isSet(propertyName)) continue;
                if ("members".equalsIgnoreCase(propertyName)) {
                    group.getMembers().clear();
                    group.getMembers().addAll(converter.getGroup(existingGroup).getMembers());
                    deleteGroupMembers = true;
                    continue;
                }
                group.unset(propertyName);
            }
        }
        Root root = new Root();
        root.getEntities().add(group);
        GroupMemberControl control = new GroupMemberControl();
        if (deleteGroupMembers) {
            control.setModifyMode(3);
        } else {
            control.setModifyMode(2);
        }
        root.getControls().add(control);
        VMMService service = GroupHandler.getVMMService();
        root = service.update(root);
        List entities = root.getEntities();
        if (entities.size() > 0) {
            String userId = ((Entity)entities.get(0)).getIdentifier().getUniqueName();
            return this.getGroup(userId, URLPrefix, params);
        }
        return null;
    }
}

