/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim.rest;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.scim.parser.FilterInterpreter;
import com.ibm.ws.security.wim.scim.parser.ParseException;
import com.ibm.ws.security.wim.scim.parser.SimpleNode;
import com.ibm.ws.security.wim.scim.parser.TokenMgrError;
import com.ibm.ws.security.wim.scim.util.GroupSCIMConverter;
import com.ibm.ws.security.wim.scim.util.SCIMConverter;
import com.ibm.ws.security.wim.scim.util.UserSCIMConverter;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.security.wim.exception.DefaultParentNotFoundException;
import com.ibm.wsspi.security.wim.exception.EntityAlreadyExistsException;
import com.ibm.wsspi.security.wim.exception.EntityIdentifierNotSpecifiedException;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.EntityNotInRealmScopeException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.MaxResultsExceededException;
import com.ibm.wsspi.security.wim.exception.MissingMandatoryPropertyException;
import com.ibm.wsspi.security.wim.exception.OperationNotSupportedException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.GroupMembershipControl;
import com.ibm.wsspi.security.wim.model.PageControl;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import com.ibm.wsspi.security.wim.model.SortControl;
import com.ibm.wsspi.security.wim.model.SortKeyType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HandlerUtil {
    private static final String PARAM_SORT_BY = "sortBy";
    private static final String PARAM_SORT_ORDER = "sortOrder";
    private static final String PARAM_VALUE_DESCENDING = "descending";
    private static final String PARAM_VALUE_ASCENDING = "ascending";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_START_INDEX = "startIndex";
    private static final String SCIM_TYPE_INVALID_FILTER = "invalidFilter";
    private static final TraceComponent tc = Tr.register(HandlerUtil.class, (String)"SCIMUtil", (String)"com.ibm.ws.security.wim.scim.util.resources.SCIMUtilMessages");
    private static final String START_INDEX_DEFAULT = "START_INDEX_DEFAULT";
    private static final String DEFAULT_SORT_ORDER = "DEFAULT_SORT_ORDER";
    private static final String PAGE_CACHE_CLEAR = "PAGE_CACHE_CLEAR";
    private static final String SEARCH_FILTER_INVALID = "SEARCH_FILTER_INVALID";
    static final long serialVersionUID = -3122623312481383697L;

    static JSONObject handleException(WIMException ex, RESTRequest request, RESTResponse response) {
        int status;
        String scimType = null;
        String description = ex.getMessage();
        if (ex instanceof InvalidUniqueNameException || ex instanceof EntityNotFoundException || ex instanceof EntityNotInRealmScopeException) {
            status = 404;
        } else if (ex instanceof EntityAlreadyExistsException) {
            status = 409;
        } else if (ex instanceof MaxResultsExceededException || ex instanceof DefaultParentNotFoundException || ex instanceof OperationNotSupportedException || ex instanceof EntityIdentifierNotSpecifiedException || ex instanceof MissingMandatoryPropertyException) {
            status = 400;
        } else {
            status = 500;
            if (ex instanceof WIMException) {
                WIMException we = HandlerUtil.getCausalWIMException(ex);
                String messageKey = we.getMessageKey();
                Throwable cause = we.getCause();
                if ("MALFORMED_SEARCH_EXPRESSION".equals(messageKey) || "INVALID_SEARCH_EXPRESSION".equals(messageKey) || "CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS".equals(messageKey) || "MISSING_SEARCH_EXPRESSION".equals(messageKey) || "SEARCH_EXPRESSION_ERROR".equals(messageKey) || "PROPERTY_NOT_DEFINED_FOR_ENTITY".equals(messageKey) || "PROPERTY_NOT_DEFINED".equals(messageKey)) {
                    status = 400;
                    description = we.getMessage();
                    scimType = SCIM_TYPE_INVALID_FILTER;
                } else if (cause instanceof ParseException || cause instanceof TokenMgrError) {
                    String[] filters = (String[])request.getParameterMap().get("filter");
                    String filter = filters == null || filters.length < 1 ? "null" : filters[0];
                    String message = Tr.formatMessage((TraceComponent)tc, (String)SEARCH_FILTER_INVALID, (Object[])new Object[]{filter, we.getMessage()});
                    if (tc.isWarningEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                    }
                    status = 400;
                    description = message;
                    scimType = SCIM_TYPE_INVALID_FILTER;
                }
            }
        }
        response.setStatus(status);
        JSONObject json = new JSONObject();
        JSONArray errors = new JSONArray();
        JSONObject error = new JSONObject();
        error.put((Object)"description", (Object)description);
        error.put((Object)"code", (Object)Integer.toString(status));
        if (scimType != null) {
            error.put((Object)"scimType", scimType);
        }
        errors.add((Object)error);
        json.put((Object)"Errors", (Object)errors);
        return json;
    }

    private static WIMException getCausalWIMException(WIMException t) {
        WIMException result = t;
        for (Throwable cause = t.getCause(); cause != null && cause instanceof WIMException; cause = cause.getCause()) {
            result = (WIMException)cause;
        }
        return result;
    }

    public static void addMetaData(JSONObject json, Entity entity, String location) {
        JSONArray schemas = new JSONArray();
        schemas.add((Object)"urn:scim:schemas:core:1.0");
        json.put((Object)"schemas", (Object)schemas);
        json.put((Object)"id", (Object)entity.getIdentifier().getUniqueName());
        json.put((Object)"externalId", (Object)entity.getIdentifier().getExternalName());
        JSONObject meta = new JSONObject();
        if (entity.getCreateTimestamp() != null) {
            meta.put((Object)"created", (Object)HandlerUtil.getStr(entity.getCreateTimestamp()));
        }
        if (entity.getModifyTimestamp() != null) {
            meta.put((Object)"lastModified", (Object)HandlerUtil.getStr(entity.getModifyTimestamp()));
        }
        if (location != null) {
            meta.put((Object)"location", (Object)location);
        }
        if (meta.size() > 0) {
            json.put((Object)"meta", (Object)meta);
        }
    }

    private static String getStr(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return df.format(date);
    }

    /*
     * WARNING - void declaration
     */
    static Root getSearchRoot(Map<String, String[]> params, String xsiType) throws WIMException {
        String[] value = params.get("attributes");
        String[] attributes = value == null || "".equals(value[0]) ? new String[]{"principalName"} : value[0].split(",");
        value = params.get("filter");
        String filter = value == null || "".equals(value[0]) ? null : value[0];
        Root root = new Root();
        SearchControl searchCtrl = new SearchControl();
        StringBuilder searchExp = new StringBuilder("@xsi:type='");
        searchExp.append(xsiType);
        searchExp.append("'");
        SCIMConverter converter = null;
        converter = "PersonAccount".equalsIgnoreCase(xsiType) ? new UserSCIMConverter(null) : new GroupSCIMConverter(null);
        if (filter != null) {
            try {
                filter = HandlerUtil.parse(filter, converter);
            }
            catch (ParseException parseException) {
                void ex;
                FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.security.wim.scim.rest.HandlerUtil", (String)"253", null, (Object[])new Object[]{params, xsiType});
                throw new WIMException((Throwable)ex);
            }
            catch (TokenMgrError ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.security.wim.scim.rest.HandlerUtil", (String)"255", null, (Object[])new Object[]{params, xsiType});
                throw new WIMException((Throwable)ex);
            }
            String filterLower = filter.toLowerCase();
            boolean hasUserNameOnlyFilter = false;
            if (filterLower.indexOf("principalname") > -1 && filterLower.indexOf(" and ") == -1 && filterLower.indexOf(" or ") == -1) {
                hasUserNameOnlyFilter = true;
            }
            searchExp.append(" and ");
            if (!hasUserNameOnlyFilter) {
                searchExp.append("(");
            }
            searchExp.append(filter);
            if (!hasUserNameOnlyFilter) {
                searchExp.append(")");
            }
        } else if ("PersonAccount".equalsIgnoreCase(xsiType)) {
            searchExp.append(" and principalName = '*'");
        } else if ("Group".equalsIgnoreCase(xsiType)) {
            searchExp.append(" and cn = '*'");
        }
        searchCtrl.setExpression(searchExp.toString());
        List props = searchCtrl.getProperties();
        for (int i = 0; i < attributes.length; ++i) {
            if ("members".equalsIgnoreCase(attributes[i]) || "groups".equalsIgnoreCase(attributes[i])) continue;
            if ("phoneNumbers".equalsIgnoreCase(attributes[i]) || "photos".equalsIgnoreCase(attributes[i]) || "addresses".equalsIgnoreCase(attributes[i]) || "name".equalsIgnoreCase(attributes[i])) {
                props.addAll(converter.getMultiValuedPropertyNames(attributes[i].toLowerCase()));
                continue;
            }
            String propertyName = converter.getPropertyName(attributes[i].toLowerCase());
            if (converter instanceof UserSCIMConverter) {
                PersonAccount person = new PersonAccount();
                if (person.getExtendedPropertyNames() != null && person.getExtendedPropertyNames().contains(attributes[i])) {
                    propertyName = attributes[i];
                }
            } else {
                Group group = new Group();
                if (group.getExtendedPropertyNames() != null && group.getExtendedPropertyNames().contains(attributes[i])) {
                    propertyName = attributes[i];
                }
            }
            props.add(propertyName);
        }
        root.getControls().add(searchCtrl);
        if (params.containsKey(PARAM_SORT_BY)) {
            String sortBy = params.get(PARAM_SORT_BY)[0];
            String sortOrder = null;
            if (params.get(PARAM_SORT_ORDER) != null) {
                sortOrder = params.get(PARAM_SORT_ORDER)[0];
            }
            sortBy = converter.getPropertyName(sortBy.toLowerCase());
            SortControl sortCtrl = new SortControl();
            SortKeyType sortKey = new SortKeyType();
            sortKey.setPropertyName(sortBy);
            if (PARAM_VALUE_DESCENDING.equalsIgnoreCase(sortOrder)) {
                sortKey.setAscendingOrder(false);
            } else if (PARAM_VALUE_ASCENDING.equalsIgnoreCase(sortOrder) || sortOrder == null) {
                sortKey.setAscendingOrder(true);
            } else {
                sortKey.setAscendingOrder(true);
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)DEFAULT_SORT_ORDER, (Object[])new Object[0]);
                }
            }
            sortCtrl.getSortKeys().add(sortKey);
            root.getControls().add(sortCtrl);
        }
        String[] countParam = params.get(PARAM_COUNT);
        String[] startIndexParam = params.get(PARAM_START_INDEX);
        if (countParam != null || startIndexParam != null) {
            Integer count = 250;
            if (countParam != null && countParam.length > 0) {
                try {
                    count = Integer.parseInt(countParam[0]);
                }
                catch (NumberFormatException sortKey) {
                    FFDCFilter.processException((Throwable)sortKey, (String)"com.ibm.ws.security.wim.scim.rest.HandlerUtil", (String)"358", null, (Object[])new Object[]{params, xsiType});
                }
            }
            String startIndex = null;
            int iStartIndex = 0;
            if (startIndexParam != null && startIndexParam.length > 0) {
                startIndex = startIndexParam[0];
                try {
                    iStartIndex = Integer.parseInt(startIndex) - 1;
                    if (iStartIndex < 0) {
                        iStartIndex = 0;
                        if (tc.isWarningEnabled()) {
                            Tr.warning((TraceComponent)tc, (String)START_INDEX_DEFAULT, (Object[])new Object[0]);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.security.wim.scim.rest.HandlerUtil", (String)"378", null, (Object[])new Object[]{params, xsiType});
                }
            }
            PageControl pageCtrl = new PageControl();
            pageCtrl.setSize(count.intValue());
            pageCtrl.setStartIndex(iStartIndex);
            if (pageCtrl.getSize() <= 0) {
                if (pageCtrl.getSize() < 0) {
                    pageCtrl.setSize(0);
                }
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)PAGE_CACHE_CLEAR, (Object[])new Object[0]);
                }
            }
            root.getControls().add(pageCtrl);
        }
        return root;
    }

    public static String parse(String filter, SCIMConverter converter) throws ParseException {
        FilterInterpreter parser = new FilterInterpreter(new StringReader(filter));
        SimpleNode node = parser.parse();
        StringBuilder output = new StringBuilder();
        HandlerUtil.traverse(node, converter, output);
        return output.toString();
    }

    private static void traverse(SimpleNode node, SCIMConverter converter, StringBuilder output) throws ParseException {
        String type = node.toString();
        String actualValue = String.valueOf(node.jjtGetValue());
        String value = actualValue.toLowerCase();
        if (!"null".equals(value)) {
            if ("(".equals(value) || ")".equals(value)) {
                output.append(value);
            } else if ("Attribute".equals(type)) {
                if ("meta.lastModified".equalsIgnoreCase(value)) {
                    output.append("modifyTimestamp");
                } else if ("meta.created".equalsIgnoreCase(value)) {
                    output.append("createTimestamp");
                } else {
                    String propertyName = converter.getPropertyName(value);
                    if (propertyName.equals(value)) {
                        propertyName = actualValue;
                    }
                    output.append(propertyName);
                }
            } else if ("Value".equals(type)) {
                int length = output.length();
                String currentOp = output.substring(length - 3);
                value = value.replaceAll("\\\\\"", "\"\"");
                if ("co ".equals(currentOp)) {
                    output.delete(length - 3, length - 1);
                    output.append("= \"*");
                    output.append(value.substring(1, value.length() - 1));
                    output.append("*\"");
                } else if ("sw ".equals(currentOp)) {
                    output.delete(length - 3, length - 1);
                    output.append("= ");
                    output.append(value.substring(0, value.length() - 1));
                    output.append("*\"");
                } else {
                    output.append(' ').append(value);
                }
            } else if ("AttrOp".equals(type)) {
                String operator;
                if ("eq".equals(value)) {
                    operator = "=";
                } else if ("gt".equals(value)) {
                    operator = ">";
                } else if ("ge".equals(value)) {
                    operator = ">=";
                } else if ("lt".equals(value)) {
                    operator = "<";
                } else if ("le".equals(value)) {
                    operator = "<=";
                } else if ("co".equals(value)) {
                    operator = "co";
                } else if ("sw".equals(value)) {
                    operator = "sw";
                } else if ("pr".equals(value)) {
                    operator = "pr";
                    output.append("='*'");
                } else {
                    throw new ParseException("Unknown attribute operator named - " + value);
                }
                if (!operator.equalsIgnoreCase("pr")) {
                    output.append(' ').append(operator).append(' ');
                }
            } else if ("LgclOp".equals(type)) {
                output.append(' ').append(value).append(' ');
            }
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            HandlerUtil.traverse((SimpleNode)node.jjtGetChild(i), converter, output);
        }
    }

    @FFDCIgnore(value={IOException.class})
    public static JSONObject getJSONObject(RESTRequest request) {
        try {
            JSONObject inputObject = JSONObject.parse((Reader)request.getInput());
            return inputObject;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static PropertyControl getPropertyControl(Map<String, String[]> params, SCIMConverter converter) {
        if (params == null) {
            return null;
        }
        String[] value = params.get("attributes");
        if (value == null || "".equals(value[0])) {
            return null;
        }
        String[] attributes = value[0].split(",");
        PropertyControl control = new PropertyControl();
        List props = control.getProperties();
        for (int i = 0; i < attributes.length; ++i) {
            if ("members".equalsIgnoreCase(attributes[i]) || "groups".equalsIgnoreCase(attributes[i])) continue;
            if ("phoneNumbers".equalsIgnoreCase(attributes[i]) || "photos".equalsIgnoreCase(attributes[i]) || "addresses".equalsIgnoreCase(attributes[i]) || "name".equalsIgnoreCase(attributes[i])) {
                props.addAll(converter.getMultiValuedPropertyNames(attributes[i].toLowerCase()));
                continue;
            }
            String propertyName = converter.getPropertyName(attributes[i].toLowerCase());
            if (converter instanceof UserSCIMConverter) {
                PersonAccount person = new PersonAccount();
                if (person.getExtendedPropertyNames() != null && person.getExtendedPropertyNames().contains(attributes[i])) {
                    propertyName = attributes[i];
                }
            } else {
                Group group = new Group();
                if (group.getExtendedPropertyNames() != null && group.getExtendedPropertyNames().contains(attributes[i])) {
                    propertyName = attributes[i];
                }
            }
            props.add(propertyName);
        }
        props.add("createTimestamp");
        props.add("modifyTimestamp");
        return control;
    }

    static boolean isAttributeRequested(Map<String, String[]> params, String attribute) {
        String[] attributesArray;
        if (params != null && (attributesArray = params.get("attributes")) != null && attributesArray.length > 0) {
            for (String name : attributesArray[0].split(",")) {
                if (!name.equalsIgnoreCase(attribute)) continue;
                return true;
            }
        }
        return false;
    }

    static void setGroupMembershipControl(Root root, Map<String, String[]> params) {
        boolean getGroups = true;
        if (params != null) {
            String[] value = params.get("attributes");
            getGroups = value == null || HandlerUtil.isAttributeRequested(params, "groups");
        }
        if (getGroups) {
            GroupMembershipControl groupMembershipControl = new GroupMembershipControl();
            groupMembershipControl.setLevel(1);
            groupMembershipControl.getProperties().add("cn");
            groupMembershipControl.setCountLimit(0);
            root.getControls().add(groupMembershipControl);
        }
    }

    static void setGroupMemberControl(Root root, Map<String, String[]> params) {
        boolean getMembers = true;
        if (params != null) {
            String[] value = params.get("attributes");
            getMembers = value == null || HandlerUtil.isAttributeRequested(params, "members");
        }
        if (getMembers) {
            GroupMemberControl groupMemberControl = new GroupMemberControl();
            groupMemberControl.setLevel(1);
            groupMemberControl.getProperties().add("displayName");
            groupMemberControl.getProperties().add("principalName");
            groupMemberControl.getProperties().add("cn");
            groupMemberControl.setCountLimit(0);
            root.getControls().add(groupMemberControl);
        }
    }

    public static Map<String, Object> flatten(SCIMConverter converter, Map<String, Object> map) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            for (Map.Entry<String, Object> entry : HandlerUtil.flattenJsonEntry(converter, e)) {
                results.put("/" + entry.getKey(), entry.getValue());
            }
        }
        return results;
    }

    @Trivial
    private static List<Map.Entry<String, Object>> flattenJsonEntry(SCIMConverter converter, Map.Entry<String, Object> entry) {
        ArrayList<Map.Entry<String, Object>> results = new ArrayList<Map.Entry<String, Object>>();
        if (entry == null) {
            return results;
        }
        if (entry.getValue() instanceof Map) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                results.addAll(HandlerUtil.flattenJsonEntry(converter, new AbstractMap.SimpleEntry<String, Object>(entry.getKey() + "/" + (String)entry2.getKey(), entry2.getValue())));
            }
        }
        if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            for (int idx = 0; idx < list.size(); ++idx) {
                Object item = list.get(idx);
                String arrayKey = String.valueOf(idx);
                if (item instanceof Map) {
                    String type = (String)((Map)item).get("type");
                    if (type == null) {
                        type = converter.getDefaultType(entry.getKey());
                    }
                    if (type != null) {
                        arrayKey = type;
                    }
                }
                results.addAll(HandlerUtil.flattenJsonEntry(converter, new AbstractMap.SimpleEntry<String, Object>(entry.getKey() + "/" + arrayKey, list.get(idx))));
            }
        }
        results.add(entry);
        return results;
    }
}

