/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim.rest;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.security.wim.scim.rest.HandlerUtil;
import com.ibm.ws.security.wim.scim.util.UserSCIMConverter;
import com.ibm.ws.security.wim.util.ControlsHelper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.OperationNotSupportedException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PageControl;
import com.ibm.wsspi.security.wim.model.PageResponseControl;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/scim/Users"})
public class UserHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(UserHandler.class, (String)"SCIMUtil", (String)"com.ibm.ws.security.wim.scim.util.resources.SCIMUtilMessages");
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String PUT = "PUT";
    public static final String KEY_VMM_SERVICE = "VMMService";
    public static final String USERS_STRING = "/Users";
    public static final String USERS_SLASH_STRING = "/Users/";
    public static final int USERS_LENGTH = "/Users/".length();
    private static final AtomicServiceReference<VMMService> VMMServiceRef = new AtomicServiceReference("VMMService");
    static final long serialVersionUID = -413429386057917027L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        VMMServiceRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        VMMServiceRef.deactivate(context);
    }

    @Reference(service=VMMService.class, name="VMMService", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setVMMService(ServiceReference<VMMService> ref) {
        VMMServiceRef.setReference(ref);
    }

    protected void unsetVMMService(ServiceReference<VMMService> ref) {
        VMMServiceRef.unsetReference(ref);
    }

    public static VMMService getVMMService() {
        VMMService service = (VMMService)VMMServiceRef.getServiceWithException();
        return service;
    }

    private String parseUser(String path) {
        if (path.indexOf(USERS_SLASH_STRING) == -1) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path.substring(path.indexOf(USERS_SLASH_STRING) + USERS_LENGTH);
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        AuditManager auditManager = new AuditManager();
        auditManager.setRESTRequest((Object)request);
        String method = request.getMethod();
        String URL2 = request.getURL();
        String URLPrefix = URL2.substring(0, URL2.indexOf(USERS_STRING));
        if (GET.equalsIgnoreCase(method)) {
            JSONObject json = null;
            String path = request.getPath();
            String id = this.parseUser(path);
            try {
                if ("Users".equals(id)) {
                    json = this.getUserList(request.getParameterMap());
                } else if (id == null || id.isEmpty()) {
                    response.setStatus(400);
                    json = new JSONObject();
                    JSONArray errors = new JSONArray();
                    JSONObject error = new JSONObject();
                    error.put((Object)"description", (Object)Tr.formatMessage((TraceComponent)tc, (String)"MISSING_IDENTIFIER_IN_URL", (Object[])new Object[0]));
                    error.put((Object)"code", (Object)Integer.toString(400));
                    errors.add((Object)error);
                    json.put((Object)"Errors", (Object)errors);
                } else {
                    json = this.getUser(id, URLPrefix, request.getParameterMap());
                }
            }
            catch (WIMException errors) {
                void ex;
                FFDCFilter.processException((Throwable)errors, (String)"com.ibm.ws.security.wim.scim.rest.UserHandler", (String)"165", (Object)this, (Object[])new Object[]{request, response});
                json = HandlerUtil.handleException((WIMException)ex, request, response);
            }
            if (json != null) {
                response.getWriter().write(json.toString());
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else if (POST.equalsIgnoreCase(method)) {
            JSONObject inputObject = HandlerUtil.getJSONObject(request);
            if (inputObject == null) {
                response.getWriter().write("No input OBJECT FOUND !!!!");
                response.getWriter().flush();
                response.getWriter().close();
                return;
            }
            JSONObject output = null;
            try {
                output = this.createUser(inputObject, URLPrefix, request.getParameterMap());
                response.setStatus(201);
            }
            catch (WIMException id) {
                void ex;
                FFDCFilter.processException((Throwable)id, (String)"com.ibm.ws.security.wim.scim.rest.UserHandler", (String)"191", (Object)this, (Object[])new Object[]{request, response});
                output = HandlerUtil.handleException((WIMException)ex, request, response);
            }
            if (output != null) {
                response.getWriter().write(output.toString());
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else if (DELETE.equalsIgnoreCase(method)) {
            String path = request.getPath();
            String id = this.parseUser(path);
            try {
                this.deleteUser(id, URLPrefix);
            }
            catch (WIMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.security.wim.scim.rest.UserHandler", (String)"207", (Object)this, (Object[])new Object[]{request, response});
                HandlerUtil.handleException(ex, request, response);
            }
        } else if (PUT.equalsIgnoreCase(method)) {
            String path = request.getPath();
            String id = this.parseUser(path);
            JSONObject inputObject = HandlerUtil.getJSONObject(request);
            if (inputObject == null) {
                response.getWriter().write("No input OBJECT FOUND !!!!");
                response.getWriter().flush();
                response.getWriter().close();
                return;
            }
            JSONObject output = null;
            try {
                output = this.updateUser(id, inputObject, URLPrefix, request.getParameterMap());
            }
            catch (WIMException error) {
                void ex;
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.security.wim.scim.rest.UserHandler", (String)"227", (Object)this, (Object[])new Object[]{request, response});
                output = HandlerUtil.handleException((WIMException)ex, request, response);
            }
            if (output != null) {
                response.getWriter().write(output.toString());
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else {
            response.sendError(501, "Service Provider does not support the requested operation");
        }
    }

    @FFDCIgnore(value={EntityNotFoundException.class})
    private JSONObject getUserList(Map<String, String[]> params) throws WIMException {
        UserSCIMConverter converter = new UserSCIMConverter(null);
        Root root = HandlerUtil.getSearchRoot(params, "PersonAccount");
        Map ctrlMap = ControlsHelper.getControlMap((Root)root);
        PageControl pageControl = (PageControl)ctrlMap.get("PageControl");
        VMMService service = UserHandler.getVMMService();
        root = service.search(root);
        List entities = root.getEntities();
        ctrlMap = ControlsHelper.getControlMap((Root)root);
        PageResponseControl pageResponseControl = (PageResponseControl)ctrlMap.get("PageResponseControl");
        if (HandlerUtil.isAttributeRequested(params, "groups")) {
            for (Entity entity : entities) {
                if (entity.isSetGroups()) continue;
                try {
                    root = this.getUserByUniqueName(entity.getIdentifier().getUniqueName(), params, converter);
                }
                catch (EntityNotFoundException e) {
                    Tr.debug((TraceComponent)tc, (String)("Ignoring: " + (Object)((Object)e)), (Object[])new Object[0]);
                    continue;
                }
                List entitiesWithGroups = root.getEntities();
                if (entitiesWithGroups == null || entitiesWithGroups.isEmpty()) continue;
                List groups = ((Entity)entitiesWithGroups.get(0)).getGroups();
                for (Group group : groups) {
                    entity.set("groups", (Object)group);
                }
            }
        }
        JSONObject json = new JSONObject();
        if (pageResponseControl == null) {
            json.put((Object)"totalResults", (Object)entities.size());
        } else {
            json.put((Object)"totalResults", (Object)pageResponseControl.getTotalSize());
        }
        if (pageControl != null) {
            json.put((Object)"startIndex", (Object)(pageControl.getStartIndex() + 1));
            json.put((Object)"itemsPerPage", (Object)pageControl.getSize());
        }
        JSONArray schemas = new JSONArray();
        schemas.add((Object)"urn:scim:schemas:core:1.0");
        json.put((Object)"schemas", (Object)schemas);
        JSONArray resources = new JSONArray();
        for (Entity entity : entities) {
            JSONObject res = converter.getJSONObject((PersonAccount)entity, null);
            resources.add((Object)res);
        }
        json.put((Object)"Resources", (Object)resources);
        return json;
    }

    private JSONObject getUser(String userId, String URLPrefix, Map<String, String[]> params) throws WIMException {
        UserSCIMConverter converter = new UserSCIMConverter(null);
        Root root = this.getUserByUniqueName(userId, params, converter);
        List entities = root.getEntities();
        if (entities.size() > 0) {
            PersonAccount person = (PersonAccount)entities.get(0);
            return converter.getJSONObject(person, URLPrefix);
        }
        return null;
    }

    private Root getUserByUniqueName(String uniqueName, Map<String, String[]> params, UserSCIMConverter converter) throws WIMException {
        Root root = new Root();
        PersonAccount person = new PersonAccount();
        IdentifierType id = new IdentifierType();
        id.setUniqueName(uniqueName);
        person.setIdentifier(id);
        root.getEntities().add(person);
        PropertyControl propCtrl = HandlerUtil.getPropertyControl(params, converter);
        if (propCtrl == null) {
            propCtrl = new PropertyControl();
            propCtrl.getProperties().add("*");
        }
        root.getControls().add(propCtrl);
        HandlerUtil.setGroupMembershipControl(root, params);
        Context trustKey = new Context();
        trustKey.set("key", (Object)"trustEntityType");
        trustKey.set("value", (Object)"true");
        root.getContexts().add(trustKey);
        return UserHandler.getVMMService().get(root);
    }

    private JSONObject createUser(JSONObject json, String URLPrefix, Map<String, String[]> params) throws WIMException {
        UserSCIMConverter converter = new UserSCIMConverter(null);
        PersonAccount person = converter.getPersonAccount(json);
        person.set("principalName", null);
        person.unsetActive();
        Root root = new Root();
        root.getEntities().add(person);
        VMMService service = UserHandler.getVMMService();
        root = service.create(root);
        List entities = root.getEntities();
        if (entities.size() > 0) {
            String userId = ((Entity)entities.get(0)).getIdentifier().getUniqueName();
            return this.getUser(userId, URLPrefix, params);
        }
        return null;
    }

    private void deleteUser(String userId, String uRLPrefix) throws WIMException {
        VMMService service = UserHandler.getVMMService();
        Root root = new Root();
        PersonAccount person = new PersonAccount();
        IdentifierType id = new IdentifierType();
        id.setUniqueName(userId);
        person.setIdentifier(id);
        root.getEntities().add(person);
        service.delete(root);
    }

    private JSONObject updateUser(String id, JSONObject updateJson, String URLPrefix, Map<String, String[]> params) throws WIMException {
        UserSCIMConverter converter = new UserSCIMConverter(null);
        PersonAccount personUpdates = converter.getPersonAccount(updateJson);
        personUpdates.set("principalName", null);
        personUpdates.unsetActive();
        if (!id.equalsIgnoreCase(personUpdates.getIdentifier().getUniqueName())) {
            throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)("The ID of the user, " + id + " cannot be updated to " + personUpdates.getIdentifier().getUniqueName()), (Object[])WIMMessageHelper.generateMsgParms(null)));
        }
        for (String wimProperty : converter.getWimPropertiesToDelete(this.getUser(id, URLPrefix, null), updateJson)) {
            personUpdates.unset(wimProperty);
        }
        Root root = new Root();
        root.getEntities().add(personUpdates);
        VMMService service = UserHandler.getVMMService();
        root = service.update(root);
        List entities = root.getEntities();
        if (entities.size() > 0) {
            String userId = ((Entity)entities.get(0)).getIdentifier().getUniqueName();
            return this.getUser(userId, URLPrefix, params);
        }
        return null;
    }
}

