/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.scim.rest.HandlerUtil;
import com.ibm.ws.security.wim.scim.util.SCIMConverter;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GroupSCIMConverter
implements SCIMConverter {
    private final HashMap<String, String> attributePropertyMap = new HashMap();
    private final HashMap<String, String> defaultAttributePropertyMap = new HashMap();
    static final long serialVersionUID = 1760439654396615973L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GroupSCIMConverter(HashMap<String, String> attributeConfig) {
        if (attributeConfig != null) {
            Set<Map.Entry<String, String>> entries = attributeConfig.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.attributePropertyMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.defaultAttributePropertyMap.put("displayname", "cn");
    }

    public Group getGroup(JSONObject json) {
        Group group = new Group();
        String displayName = (String)json.get((Object)"displayName");
        if (displayName != null) {
            if (this.attributePropertyMap.containsKey("displayName")) {
                group.set(this.attributePropertyMap.get("displayName"), (Object)displayName);
            } else {
                group.setCn(displayName);
            }
        }
        IdentifierType id = new IdentifierType();
        id.setUniqueName((String)json.get((Object)"externalId"));
        group.setIdentifier(id);
        this.setMembers(group, json);
        this.setExtendedProperties(group, json);
        return group;
    }

    private void setMembers(Group group, JSONObject json) {
        JSONArray members = (JSONArray)json.get((Object)"members");
        if (members == null || members.size() == 0) {
            return;
        }
        for (Object m : members) {
            IdentifierType id;
            JSONObject member = (JSONObject)m;
            String display = (String)member.get((Object)"display");
            String uniqueName = (String)member.get((Object)"value");
            String ref = (String)member.get((Object)"$ref");
            String type = (String)member.get((Object)"type");
            if (type != null && "User".equalsIgnoreCase(type) || ref != null && ref.contains("Users")) {
                PersonAccount person = new PersonAccount();
                id = new IdentifierType();
                id.setUniqueName(uniqueName);
                person.setIdentifier(id);
                person.getDisplayName().add(display);
                group.getMembers().add(person);
                continue;
            }
            if (type != null && "Group".equalsIgnoreCase(type) || ref != null && ref.contains("Groups")) {
                Group innerGroup = new Group();
                id = new IdentifierType();
                id.setUniqueName(uniqueName);
                innerGroup.setIdentifier(id);
                innerGroup.getDisplayName().add(display);
                group.getMembers().add(innerGroup);
                continue;
            }
            Entity entity = new Entity();
            id = new IdentifierType();
            id.setUniqueName(uniqueName);
            entity.setIdentifier(id);
            group.getMembers().add(entity);
        }
    }

    public JSONObject getJSONObject(Group group, String URLPrefix, boolean addMeta) {
        IdentifierType id;
        JSONObject json = new JSONObject();
        if (addMeta) {
            HandlerUtil.addMetaData(json, (Entity)group, URLPrefix + "/Groups/" + group.getIdentifier().getUniqueName());
        }
        if (this.attributePropertyMap.containsKey("displayName")) {
            if (group.get(this.attributePropertyMap.get("displayName")) != null) {
                json.put((Object)"displayName", group.get(this.attributePropertyMap.get("displayName")));
            }
        } else if (group.isSetCn()) {
            json.put((Object)"displayName", (Object)group.getCn());
        }
        if ((id = group.getIdentifier()) != null && id.getUniqueName() != null) {
            json.put((Object)"id", (Object)id.getUniqueName());
        }
        this.setMembers(json, group, URLPrefix);
        this.setExtendedProperties(json, group);
        return json;
    }

    private void setMembers(JSONObject json, Group group, String URLPrefix) {
        List members = group.getMembers();
        if (members == null || members.size() == 0) {
            return;
        }
        JSONArray memArray = new JSONArray();
        json.put((Object)"members", (Object)memArray);
        for (Entity entity : members) {
            JSONObject member;
            String ref;
            String uniqueName;
            String display;
            String type = entity.getTypeName();
            if ("PersonAccount".equalsIgnoreCase(type) || entity.getSuperTypes().contains("PersonAccount")) {
                PersonAccount person = (PersonAccount)entity;
                display = null;
                display = person.getDisplayName() != null && person.getDisplayName().size() > 0 ? (String)person.getDisplayName().get(0) : person.getCn();
                uniqueName = null;
                if (person.getIdentifier() != null) {
                    uniqueName = person.getIdentifier().getUniqueName();
                }
                ref = null;
                if (uniqueName != null) {
                    ref = URLPrefix + "/Users/" + uniqueName;
                }
                member = new JSONObject();
                if (display != null) {
                    member.put((Object)"display", (Object)display);
                }
                if (uniqueName != null) {
                    member.put((Object)"value", (Object)uniqueName);
                }
                if (ref != null) {
                    member.put((Object)"$ref", (Object)ref);
                }
                member.put((Object)"type", (Object)"User");
                memArray.add((Object)member);
                continue;
            }
            if ("Group".equalsIgnoreCase(type) || entity.getSuperTypes().contains("Group")) {
                Group grp = (Group)entity;
                display = null;
                if (grp.getDisplayName() != null && grp.getDisplayName().size() > 0) {
                    display = (String)grp.getDisplayName().get(0);
                } else if (grp.isSetCn()) {
                    display = grp.getCn();
                }
                uniqueName = null;
                if (grp.getIdentifier() != null) {
                    uniqueName = grp.getIdentifier().getUniqueName();
                }
                ref = null;
                if (uniqueName != null) {
                    ref = URLPrefix + "/Groups/" + uniqueName;
                }
                member = new JSONObject();
                if (display != null) {
                    member.put((Object)"display", (Object)display);
                }
                if (uniqueName != null) {
                    member.put((Object)"value", (Object)uniqueName);
                }
                if (ref != null) {
                    member.put((Object)"$ref", (Object)ref);
                }
                member.put((Object)"type", (Object)"Group");
                memArray.add((Object)member);
                continue;
            }
            String uniqueName2 = null;
            if (entity.getIdentifier() != null) {
                uniqueName2 = entity.getIdentifier().getUniqueName();
            }
            JSONObject member2 = new JSONObject();
            if (uniqueName2 != null) {
                member2.put((Object)"value", (Object)uniqueName2);
            }
            memArray.add((Object)member2);
        }
    }

    @Override
    public String getPropertyName(String attributeName) {
        int i = attributeName.lastIndexOf(".");
        String name = i == -1 ? attributeName : attributeName.substring(i + 1);
        String result = this.attributePropertyMap.containsKey(name) ? this.attributePropertyMap.get(name) : (this.defaultAttributePropertyMap.containsKey(name) ? this.defaultAttributePropertyMap.get(name) : name);
        return result;
    }

    @Override
    public Collection<String> getMultiValuedPropertyNames(String lowerCase) {
        return new ArrayList<String>();
    }

    private void setExtendedProperties(Group group, JSONObject json) {
        Set extendedProperties = group.getExtendedPropertyNames();
        if (extendedProperties == null || extendedProperties.size() == 0) {
            return;
        }
        for (String property : extendedProperties) {
            Object value = json.get((Object)property);
            if (value == null) continue;
            if (value instanceof JSONArray) {
                for (Object val : ((JSONArray)value).toArray()) {
                    group.set(property, val);
                }
                continue;
            }
            group.set(property, value);
        }
    }

    private void setExtendedProperties(JSONObject json, Group group) {
        Set extendedProperties = group.getExtendedPropertyNames();
        if (extendedProperties == null || extendedProperties.size() == 0) {
            return;
        }
        for (String property : extendedProperties) {
            Object value = group.get(property);
            if (value == null) continue;
            if (value instanceof List) {
                JSONArray array = new JSONArray();
                array.addAll((Collection)((List)value));
                json.put((Object)property, (Object)array);
                continue;
            }
            json.put((Object)property, value);
        }
    }

    @Override
    public Set<String> getWimPropertiesToDelete(JSONObject leftJson, JSONObject rightJson) {
        return Collections.emptySet();
    }

    @Override
    public String getDefaultType(String attribute) {
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(GroupSCIMConverter.class, null, null);
    }
}

