/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim.util;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.scim.rest.HandlerUtil;
import com.ibm.ws.security.wim.scim.util.SCIMConverter;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserSCIMConverter
implements SCIMConverter {
    private static final Charset UTF_8;
    private final HashMap<String, String> attributePropertyMap = new HashMap();
    private final HashMap<String, String> defaultAttributePropertyMap = new HashMap();
    private static final Gson gson;
    private static final Type typeToken;
    static final long serialVersionUID = 221014326185248661L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public UserSCIMConverter(HashMap<String, String> attributeConfig) {
        if (attributeConfig != null) {
            Set<Map.Entry<String, String>> entries = attributeConfig.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.attributePropertyMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.defaultAttributePropertyMap.put("username", "principalName");
        this.defaultAttributePropertyMap.put("givenname", "cn");
        this.defaultAttributePropertyMap.put("familyname", "sn");
        this.defaultAttributePropertyMap.put("middlename", "middleName");
        this.defaultAttributePropertyMap.put("honorificprefix", "honorificPrefix");
        this.defaultAttributePropertyMap.put("honorificsuffix", "honorificSuffix");
        this.defaultAttributePropertyMap.put("displayname", "displayName");
        this.defaultAttributePropertyMap.put("nickname", "nickName");
        this.defaultAttributePropertyMap.put("profileurl", "profileUrl");
        this.defaultAttributePropertyMap.put("title", "title");
        this.defaultAttributePropertyMap.put("usertype", "employeeType");
        this.defaultAttributePropertyMap.put("preferredlanguage", "preferredLanguage");
        this.defaultAttributePropertyMap.put("emails", "mail");
        this.defaultAttributePropertyMap.put("fax", "facsimileTelephoneNumber");
        this.defaultAttributePropertyMap.put("photo", "photoURL");
        this.defaultAttributePropertyMap.put("thumbnail", "photoURLThumbnail");
    }

    public PersonAccount getPersonAccount(JSONObject json) {
        PersonAccount person = new PersonAccount();
        if (this.attributePropertyMap.containsKey("userName")) {
            person.set(this.attributePropertyMap.get("userName"), json.get((Object)"userName"));
        } else {
            person.set("principalName", json.get((Object)"userName"));
        }
        if (json.get((Object)"name") != null) {
            if (this.attributePropertyMap.containsKey("givenName")) {
                person.set(this.attributePropertyMap.get("givenName"), ((JSONObject)json.get((Object)"name")).get((Object)"givenName"));
            } else {
                person.set("cn", ((JSONObject)json.get((Object)"name")).get((Object)"givenName"));
            }
            if (this.attributePropertyMap.containsKey("familyName")) {
                person.set(this.attributePropertyMap.get("familyName"), ((JSONObject)json.get((Object)"name")).get((Object)"familyName"));
            } else {
                person.set("sn", ((JSONObject)json.get((Object)"name")).get((Object)"familyName"));
            }
            if (this.attributePropertyMap.containsKey("middleName")) {
                person.set(this.attributePropertyMap.get("middleName"), ((JSONObject)json.get((Object)"name")).get((Object)"middleName"));
            } else {
                person.set("middleName", ((JSONObject)json.get((Object)"name")).get((Object)"middleName"));
            }
            if (this.attributePropertyMap.containsKey("honorificPrefix")) {
                person.set(this.attributePropertyMap.get("honorificPrefix"), ((JSONObject)json.get((Object)"name")).get((Object)"honorificPrefix"));
            } else {
                person.set("honorificPrefix", ((JSONObject)json.get((Object)"name")).get((Object)"honorificPrefix"));
            }
            if (this.attributePropertyMap.containsKey("honorificSuffix")) {
                person.set(this.attributePropertyMap.get("honorificSuffix"), ((JSONObject)json.get((Object)"name")).get((Object)"honorificSuffix"));
            } else {
                person.set("honorificSuffix", ((JSONObject)json.get((Object)"name")).get((Object)"honorificSuffix"));
            }
        }
        if (json.get((Object)"displayName") != null) {
            if (this.attributePropertyMap.containsKey("displayName")) {
                person.set(this.attributePropertyMap.get("displayName"), json.get((Object)"displayName"));
            } else {
                person.set("displayName", json.get((Object)"displayName"));
            }
        }
        if (this.attributePropertyMap.containsKey("nickName")) {
            person.set(this.attributePropertyMap.get("nickName"), json.get((Object)"nickName"));
        } else {
            person.set("nickName", json.get((Object)"nickName"));
        }
        if (this.attributePropertyMap.containsKey("profileUrl")) {
            person.set(this.attributePropertyMap.get("profileUrl"), json.get((Object)"profileUrl"));
        } else {
            person.set("profileUrl", json.get((Object)"profileUrl"));
        }
        if (json.get((Object)"title") != null) {
            if (this.attributePropertyMap.containsKey("title")) {
                person.set(this.attributePropertyMap.get("title"), json.get((Object)"title"));
            } else {
                person.set("title", json.get((Object)"title"));
            }
        }
        if (this.attributePropertyMap.containsKey("userType")) {
            person.set(this.attributePropertyMap.get("userType"), json.get((Object)"userType"));
        } else {
            person.set("employeeType", json.get((Object)"userType"));
        }
        if (this.attributePropertyMap.containsKey("preferredLanguage")) {
            person.set(this.attributePropertyMap.get("preferredLanguage"), json.get((Object)"preferredLanguage"));
        } else {
            person.set("preferredLanguage", json.get((Object)"preferredLanguage"));
        }
        if (this.attributePropertyMap.containsKey("locale")) {
            person.set(this.attributePropertyMap.get("locale"), json.get((Object)"locale"));
        } else {
            person.set("locale", json.get((Object)"locale"));
        }
        if (this.attributePropertyMap.containsKey("timezone")) {
            person.set(this.attributePropertyMap.get("timezone"), json.get((Object)"timezone"));
        } else {
            person.set("timezone", json.get((Object)"timezone"));
        }
        if (this.attributePropertyMap.containsKey("active")) {
            person.set(this.attributePropertyMap.get("active"), json.get((Object)"active"));
        } else {
            person.set("active", json.get((Object)"active"));
        }
        if (this.attributePropertyMap.containsKey("password")) {
            person.set(this.attributePropertyMap.get("password"), (Object)((String)json.get((Object)"password")).getBytes(UTF_8));
        } else if (json.get((Object)"password") != null) {
            person.set("password", (Object)((String)json.get((Object)"password")).getBytes(UTF_8));
        }
        JSONArray phoneNumbers = (JSONArray)json.get((Object)"phoneNumbers");
        this.setPhoneNumbers(person, phoneNumbers);
        JSONArray emails = (JSONArray)json.get((Object)"emails");
        this.setEmails(person, emails);
        JSONArray ims = (JSONArray)json.get((Object)"ims");
        this.setIMs(person, ims);
        JSONArray photos = (JSONArray)json.get((Object)"photos");
        this.setPhotos(person, photos);
        JSONArray addresses = (JSONArray)json.get((Object)"addresses");
        this.setAddresses(person, addresses);
        this.setExtendedProperties(person, json);
        IdentifierType id = new IdentifierType();
        id.setUniqueName((String)json.get((Object)"externalId"));
        person.setIdentifier(id);
        return person;
    }

    private void setPhoneNumbers(PersonAccount person, JSONArray phoneNumbers) {
        if (phoneNumbers == null || phoneNumbers.size() == 0) {
            return;
        }
        int count = phoneNumbers.size();
        for (int loop = 0; loop < count; ++loop) {
            JSONObject phone = (JSONObject)phoneNumbers.get(loop);
            String type = (String)phone.get((Object)"type");
            Object value = phone.get((Object)"value");
            if ("mobile".equalsIgnoreCase(type)) {
                if (this.attributePropertyMap.containsKey("mobile")) {
                    person.set(this.attributePropertyMap.get("mobile"), value);
                    continue;
                }
                person.set("mobile", value);
                continue;
            }
            if ("fax".equalsIgnoreCase(type)) {
                if (this.attributePropertyMap.containsKey("fax")) {
                    person.set(this.attributePropertyMap.get("fax"), value);
                    continue;
                }
                person.set("facsimileTelephoneNumber", value);
                continue;
            }
            if ("pager".equalsIgnoreCase(type)) {
                if (this.attributePropertyMap.containsKey("pager")) {
                    person.set(this.attributePropertyMap.get("pager"), value);
                    continue;
                }
                person.set("pager", value);
                continue;
            }
            person.set("telephoneNumber", value);
        }
    }

    private void setEmails(PersonAccount person, JSONArray emails) {
        if (emails == null || emails.size() == 0) {
            return;
        }
        JSONObject email = (JSONObject)emails.get(0);
        if (this.attributePropertyMap.containsKey("email")) {
            person.set(this.attributePropertyMap.get("email"), (Object)((String)email.get((Object)"value")).toLowerCase());
        } else {
            person.set("mail", (Object)((String)email.get((Object)"value")).toLowerCase());
        }
    }

    private void setIMs(PersonAccount person, JSONArray ims) {
        if (ims == null || ims.size() == 0) {
            return;
        }
        int count = ims.size();
        for (int loop = 0; loop < count; ++loop) {
            JSONObject IM = (JSONObject)ims.get(loop);
            if (this.attributePropertyMap.containsKey("ims")) {
                person.set(this.attributePropertyMap.get("ims"), IM.get((Object)"value"));
                continue;
            }
            person.set("ims", IM.get((Object)"value"));
        }
    }

    private void setPhotos(PersonAccount person, JSONArray photos) {
        if (photos == null || photos.size() == 0) {
            return;
        }
        int count = photos.size();
        for (int loop = 0; loop < count; ++loop) {
            JSONObject photo = (JSONObject)photos.get(loop);
            String type = null;
            if (photo.get((Object)"type") != null) {
                type = (String)photo.get((Object)"type");
            }
            if ("thumbnail".equalsIgnoreCase(type)) {
                if (this.attributePropertyMap.containsKey("thumbnail")) {
                    person.set(this.attributePropertyMap.get("thumbnail"), photo.get((Object)"value"));
                    continue;
                }
                person.set("photoURLThumbnail", photo.get((Object)"value"));
                continue;
            }
            if (this.attributePropertyMap.containsKey("photo")) {
                person.set(this.attributePropertyMap.get("photo"), photo.get((Object)"value"));
                continue;
            }
            person.set("photoURL", photo.get((Object)"value"));
        }
    }

    private void setAddresses(PersonAccount person, JSONArray addresses) {
        if (addresses == null || addresses.size() == 0) {
            return;
        }
        int count = addresses.size();
        for (int loop = 0; loop < count; ++loop) {
            JSONObject address = (JSONObject)addresses.get(loop);
            String type = null;
            if (address.get((Object)"type") != null) {
                type = (String)address.get((Object)"type");
            }
            if ("home".equalsIgnoreCase(type)) {
                person.setHomeStreet((String)address.get((Object)"streetAddress"));
                person.setHomeCity((String)address.get((Object)"locality"));
                person.setHomeStateOrProvinceName((String)address.get((Object)"region"));
                person.setHomePostalCode((String)address.get((Object)"postalCode"));
                person.setHomeCountryName((String)address.get((Object)"country"));
                continue;
            }
            person.setBusinessStreet((String)address.get((Object)"streetAddress"));
            person.setBusinessCity((String)address.get((Object)"locality"));
            person.setBusinessStateOrProvinceName((String)address.get((Object)"region"));
            person.setBusinessPostalCode((String)address.get((Object)"postalCode"));
            person.setBusinessCountryName((String)address.get((Object)"country"));
        }
    }

    public JSONObject getJSONObject(PersonAccount person, String URLPrefix) {
        JSONObject json = new JSONObject();
        if (URLPrefix != null) {
            HandlerUtil.addMetaData(json, (Entity)person, URLPrefix + "/Users/" + person.getIdentifier().getUniqueName());
        }
        if (this.attributePropertyMap.containsKey("userName")) {
            if (person.get(this.attributePropertyMap.get("userName")) != null) {
                json.put((Object)"userName", person.get(this.attributePropertyMap.get("userName")));
            }
        } else if (person.getPrincipalName() != null) {
            json.put((Object)"userName", (Object)person.getPrincipalName());
        }
        JSONObject name = new JSONObject();
        if (this.attributePropertyMap.containsKey("givenName")) {
            if (person.get(this.attributePropertyMap.get("givenName")) != null) {
                name.put((Object)"givenName", person.get(this.attributePropertyMap.get("givenName")));
            }
        } else if (person.getCn() != null) {
            name.put((Object)"givenName", (Object)person.getCn());
        }
        if (this.attributePropertyMap.containsKey("familyName")) {
            if (person.get(this.attributePropertyMap.get("familyName")) != null) {
                name.put((Object)"familyName", person.get(this.attributePropertyMap.get("familyName")));
            }
        } else if (person.getSn() != null) {
            name.put((Object)"familyName", (Object)person.getSn());
        }
        if (this.attributePropertyMap.containsKey("middleName")) {
            if (person.get(this.attributePropertyMap.get("middleName")) != null) {
                name.put((Object)"middleName", person.get(this.attributePropertyMap.get("middleName")));
            }
        } else if (person.get("middleName") != null) {
            name.put((Object)"middleName", person.get("middleName"));
        }
        if (this.attributePropertyMap.containsKey("honorificPrefix")) {
            if (person.get(this.attributePropertyMap.get("honorificPrefix")) != null) {
                name.put((Object)"honorificPrefix", person.get(this.attributePropertyMap.get("honorificPrefix")));
            }
        } else if (person.get("honorificPrefix") != null) {
            name.put((Object)"honorificPrefix", person.get("honorificPrefix"));
        }
        if (this.attributePropertyMap.containsKey("honorificSuffix")) {
            if (person.get(this.attributePropertyMap.get("honorificSuffix")) != null) {
                name.put((Object)"honorificSuffix", person.get(this.attributePropertyMap.get("honorificSuffix")));
            }
        } else if (person.get("honorificSuffix") != null) {
            name.put((Object)"honorificSuffix", person.get("honorificSuffix"));
        }
        this.setFormattedName(name);
        if (name.keySet().size() > 0) {
            json.put((Object)"name", (Object)name);
        }
        if (this.attributePropertyMap.containsKey("displayName")) {
            if (person.get(this.attributePropertyMap.get("displayName")) != null) {
                json.put((Object)"displayName", person.get(this.attributePropertyMap.get("displayName")));
            }
        } else if (person.getDisplayName() != null && person.getDisplayName().size() > 0) {
            json.put((Object)"displayName", person.getDisplayName().get(0));
        }
        if (this.attributePropertyMap.containsKey("nickName")) {
            if (person.get(this.attributePropertyMap.get("nickName")) != null) {
                json.put((Object)"nickName", person.get(this.attributePropertyMap.get("nickName")));
            }
        } else if (person.get("nickName") != null) {
            json.put((Object)"nickName", person.get("nickName"));
        }
        if (this.attributePropertyMap.containsKey("profileUrl")) {
            if (person.get(this.attributePropertyMap.get("profileUrl")) != null) {
                json.put((Object)"profileUrl", person.get(this.attributePropertyMap.get("profileUrl")));
            }
        } else if (person.get("profileUrl") != null) {
            json.put((Object)"profileUrl", person.get("profileUrl"));
        }
        if (this.attributePropertyMap.containsKey("title")) {
            if (person.get(this.attributePropertyMap.get("title")) != null) {
                json.put((Object)"title", person.get(this.attributePropertyMap.get("title")));
            }
        } else if (person.getTitle() != null && person.getTitle().size() > 0) {
            json.put((Object)"title", person.getTitle().get(0));
        }
        if (this.attributePropertyMap.containsKey("userType")) {
            if (person.get(this.attributePropertyMap.get("userType")) != null) {
                json.put((Object)"userType", person.get(this.attributePropertyMap.get("userType")));
            }
        } else if (person.getEmployeeType() != null) {
            json.put((Object)"userType", (Object)person.getEmployeeType());
        }
        if (this.attributePropertyMap.containsKey("preferredLanguage")) {
            if (person.get(this.attributePropertyMap.get("preferredLanguage")) != null) {
                json.put((Object)"preferredLanguage", person.get(this.attributePropertyMap.get("preferredLanguage")));
            }
        } else if (person.getPreferredLanguage() != null) {
            json.put((Object)"preferredLanguage", (Object)person.getPreferredLanguage());
        }
        if (this.attributePropertyMap.containsKey("locale")) {
            if (person.get(this.attributePropertyMap.get("locale")) != null) {
                json.put((Object)"locale", person.get(this.attributePropertyMap.get("locale")));
            }
        } else if (person.get("locale") != null) {
            json.put((Object)"locale", person.get("locale"));
        }
        if (this.attributePropertyMap.containsKey("timezone")) {
            if (person.get(this.attributePropertyMap.get("timezone")) != null) {
                json.put((Object)"timezone", person.get(this.attributePropertyMap.get("timezone")));
            }
        } else if (person.get("timezone") != null) {
            json.put((Object)"timezone", person.get("timezone"));
        }
        if (this.attributePropertyMap.containsKey("active")) {
            if (person.get(this.attributePropertyMap.get("active")) != null) {
                json.put((Object)"active", person.get(this.attributePropertyMap.get("active")));
            }
        } else if (person.get("active") != null) {
            json.put((Object)"active", person.get("active"));
        }
        this.setPhoneNumbers(json, person);
        this.setEmails(json, person);
        this.setIMs(json, person);
        this.setPhotos(json, person);
        this.setAddresses(json, person);
        this.setGroups(json, person);
        this.setExtendedProperties(json, person);
        IdentifierType id = person.getIdentifier();
        if (id != null && id.getUniqueName() != null) {
            json.put((Object)"id", (Object)id.getUniqueName());
        }
        return json;
    }

    private void setGroups(JSONObject json, PersonAccount person) {
        List groups = person.getGroups();
        if (groups != null) {
            JSONArray jsonGroups = new JSONArray();
            for (Group group : groups) {
                JSONObject jsonGroup = new JSONObject();
                jsonGroup.put((Object)"display", (Object)group.getCn());
                jsonGroup.put((Object)"value", (Object)group.getIdentifier().getUniqueName());
                jsonGroups.add((Object)jsonGroup);
            }
            if (jsonGroups.size() > 0) {
                json.put((Object)"groups", (Object)jsonGroups);
            }
        }
    }

    private void setFormattedName(JSONObject name) {
        StringBuilder formattedName = new StringBuilder();
        if (name.containsKey((Object)"honorificPrefix")) {
            formattedName.append(name.get((Object)"honorificPrefix"));
        }
        if (formattedName.length() > 0 && formattedName.charAt(formattedName.length() - 1) != ' ') {
            formattedName.append(" ");
        }
        if (name.containsKey((Object)"givenName")) {
            formattedName.append(name.get((Object)"givenName"));
        }
        if (formattedName.length() > 0 && formattedName.charAt(formattedName.length() - 1) != ' ') {
            formattedName.append(" ");
        }
        if (name.containsKey((Object)"middleName")) {
            formattedName.append(name.get((Object)"middleName"));
        }
        if (formattedName.length() > 0 && formattedName.charAt(formattedName.length() - 1) != ' ') {
            formattedName.append(" ");
        }
        if (name.containsKey((Object)"familyName")) {
            formattedName.append(name.get((Object)"familyName"));
        }
        if (formattedName.length() > 0 && formattedName.charAt(formattedName.length() - 1) != ' ') {
            formattedName.append(" ");
        }
        if (name.containsKey((Object)"honorificSuffix")) {
            formattedName.append(name.get((Object)"honorificSuffix"));
        }
        if (formattedName.length() > 0) {
            name.put((Object)"formatted", (Object)formattedName.toString().trim());
        }
    }

    private void setPhoneNumbers(JSONObject json, PersonAccount person) {
        List telephoneNumbers;
        JSONArray phoneNumbers = new JSONArray();
        List mobileNumbers = null;
        mobileNumbers = this.attributePropertyMap.containsKey("mobile") ? (List)person.get(this.attributePropertyMap.get("mobile")) : person.getMobile();
        if (mobileNumbers != null && mobileNumbers.size() > 0) {
            for (Object mobileNumber : mobileNumbers) {
                JSONObject phone = new JSONObject();
                phone.put((Object)"type", (Object)"mobile");
                phone.put((Object)"value", mobileNumber);
                phoneNumbers.add((Object)phone);
            }
        }
        List faxNumbers = null;
        faxNumbers = this.attributePropertyMap.containsKey("fax") ? (List)person.get(this.attributePropertyMap.get("fax")) : person.getFacsimileTelephoneNumber();
        if (faxNumbers != null && faxNumbers.size() > 0) {
            for (Object faxNumber : faxNumbers) {
                JSONObject phone = new JSONObject();
                phone.put((Object)"type", (Object)"fax");
                phone.put((Object)"value", faxNumber);
                phoneNumbers.add((Object)phone);
            }
        }
        List pagers = null;
        pagers = this.attributePropertyMap.containsKey("pager") ? (List)person.get(this.attributePropertyMap.get("pager")) : person.getPager();
        if (pagers != null && pagers.size() > 0) {
            for (String pager : pagers) {
                JSONObject phone = new JSONObject();
                phone.put((Object)"type", (Object)"pager");
                phone.put((Object)"value", (Object)pager);
                phoneNumbers.add((Object)phone);
            }
        }
        if ((telephoneNumbers = person.getTelephoneNumber()) != null && telephoneNumbers.size() > 0) {
            for (String phoneNumber : telephoneNumbers) {
                JSONObject phone = new JSONObject();
                phone.put((Object)"type", (Object)"work");
                phone.put((Object)"value", (Object)phoneNumber);
                phoneNumbers.add((Object)phone);
            }
        }
        if (phoneNumbers.size() > 0) {
            json.put((Object)"phoneNumbers", (Object)phoneNumbers);
        }
    }

    private void setEmails(JSONObject json, PersonAccount person) {
        JSONArray emails = new JSONArray();
        if (this.attributePropertyMap.containsKey("email")) {
            if (person.get(this.attributePropertyMap.get("email")) != null) {
                JSONObject email = new JSONObject();
                email.put((Object)"value", (Object)((String)person.get(this.attributePropertyMap.get("email"))).toLowerCase());
                emails.add((Object)email);
            }
        } else if (person.getMail() != null) {
            JSONObject email = new JSONObject();
            email.put((Object)"value", (Object)person.getMail().toLowerCase());
            emails.add((Object)email);
        }
        if (emails.size() > 0) {
            json.put((Object)"emails", (Object)emails);
        }
    }

    private void setIMs(JSONObject json, PersonAccount person) {
        List imNames = null;
        imNames = this.attributePropertyMap.containsKey("ims") ? (List)person.get(this.attributePropertyMap.get("ims")) : (List)person.get("ims");
        if (imNames == null || imNames.size() == 0) {
            return;
        }
        JSONArray ims = new JSONArray();
        json.put((Object)"ims", (Object)ims);
        for (String im : imNames) {
            JSONObject IM = new JSONObject();
            IM.put((Object)"value", (Object)im);
            ims.add((Object)IM);
        }
    }

    private void setPhotos(JSONObject json, PersonAccount person) {
        JSONObject photo;
        JSONArray photos = new JSONArray();
        if (this.attributePropertyMap.containsKey("thumbnail")) {
            if (person.get(this.attributePropertyMap.get("thumbnail")) != null) {
                photo = new JSONObject();
                photo.put((Object)"type", (Object)"thumbnail");
                photo.put((Object)"value", person.get(this.attributePropertyMap.get("thumbnail")));
                photos.add((Object)photo);
            }
        } else if (person.getPhotoUrlThumbnail() != null) {
            photo = new JSONObject();
            photo.put((Object)"type", (Object)"thumbnail");
            photo.put((Object)"value", (Object)person.getPhotoUrlThumbnail());
            photos.add((Object)photo);
        }
        if (this.attributePropertyMap.containsKey("photo")) {
            if (person.get(this.attributePropertyMap.get("photo")) != null) {
                photo = new JSONObject();
                photo.put((Object)"type", (Object)"photo");
                photo.put((Object)"value", person.get(this.attributePropertyMap.get("photo")));
                photos.add((Object)photo);
            }
        } else if (person.getPhotoUrl() != null) {
            photo = new JSONObject();
            photo.put((Object)"type", (Object)"photo");
            photo.put((Object)"value", (Object)person.getPhotoUrl());
            photos.add((Object)photo);
        }
        if (photos.size() == 0) {
            return;
        }
        json.put((Object)"photos", (Object)photos);
    }

    private void setAddresses(JSONObject json, PersonAccount person) {
        JSONArray addresses = new JSONArray();
        StringBuilder formattedAddress = new StringBuilder();
        JSONObject homeAddress = new JSONObject();
        homeAddress.put((Object)"type", (Object)"home");
        if (person.isSetHomeStreet()) {
            homeAddress.put((Object)"streetAddress", (Object)person.getHomeStreet());
            formattedAddress.append(person.getHomeStreet());
        }
        if (person.isSetHomeCity()) {
            homeAddress.put((Object)"locality", (Object)person.getHomeCity());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getHomeCity());
        }
        if (person.isSetHomeStateOrProvinceName()) {
            homeAddress.put((Object)"region", (Object)person.getHomeStateOrProvinceName());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getHomeStateOrProvinceName());
        }
        if (person.isSetHomePostalCode()) {
            homeAddress.put((Object)"postalCode", (Object)person.getHomePostalCode());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getHomePostalCode());
        }
        if (person.isSetHomeCountryName()) {
            homeAddress.put((Object)"country", (Object)person.getHomeCountryName());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getHomeCountryName());
        }
        if (formattedAddress.length() > 0) {
            homeAddress.put((Object)"formatted", (Object)formattedAddress.toString());
            addresses.add((Object)homeAddress);
        }
        if (formattedAddress.length() > 0) {
            formattedAddress.delete(0, formattedAddress.length());
        }
        JSONObject businessAddress = new JSONObject();
        businessAddress.put((Object)"type", (Object)"work");
        if (person.isSetBusinessStreet()) {
            businessAddress.put((Object)"streetAddress", (Object)person.getBusinessStreet());
            formattedAddress.append(person.getBusinessStreet());
        }
        if (person.isSetBusinessCity()) {
            businessAddress.put((Object)"locality", (Object)person.getBusinessCity());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getBusinessCity());
        }
        if (person.isSetBusinessStateOrProvinceName()) {
            businessAddress.put((Object)"region", (Object)person.getBusinessStateOrProvinceName());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getBusinessStateOrProvinceName());
        }
        if (person.isSetBusinessPostalCode()) {
            businessAddress.put((Object)"postalCode", (Object)person.getBusinessPostalCode());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getBusinessPostalCode());
        }
        if (person.isSetBusinessCountryName()) {
            businessAddress.put((Object)"country", (Object)person.getBusinessCountryName());
            if (formattedAddress.length() > 0 && formattedAddress.charAt(formattedAddress.length() - 1) != ',') {
                formattedAddress.append(',');
            }
            formattedAddress.append(person.getBusinessCountryName());
        }
        if (formattedAddress.length() > 0) {
            businessAddress.put((Object)"formatted", (Object)formattedAddress.toString());
            addresses.add((Object)businessAddress);
        }
        if (addresses.size() > 0) {
            json.put((Object)"addresses", (Object)addresses);
        }
    }

    @Override
    public String getPropertyName(String attributeName) {
        int i = attributeName.lastIndexOf(".");
        String name = i == -1 ? attributeName : attributeName.substring(i + 1);
        String result = this.attributePropertyMap.containsKey(name) ? this.attributePropertyMap.get(name) : (this.defaultAttributePropertyMap.containsKey(name) ? this.defaultAttributePropertyMap.get(name) : name);
        return result;
    }

    @Override
    public Collection<String> getMultiValuedPropertyNames(String attributeName) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        if ("phoneNumbers".equalsIgnoreCase(attributeName)) {
            if (this.attributePropertyMap.containsKey("mobile")) {
                propertyNames.add(this.attributePropertyMap.get("mobile"));
            } else {
                propertyNames.add("mobile");
            }
            if (this.attributePropertyMap.containsKey("fax")) {
                propertyNames.add(this.attributePropertyMap.get("fax"));
            } else {
                propertyNames.add("facsimileTelephoneNumber");
            }
            if (this.attributePropertyMap.containsKey("pager")) {
                propertyNames.add(this.attributePropertyMap.get("pager"));
            } else {
                propertyNames.add("pager");
            }
            propertyNames.add("telephoneNumber");
        } else if ("photos".equalsIgnoreCase(attributeName)) {
            if (this.attributePropertyMap.containsKey("thumbnail")) {
                propertyNames.add(this.attributePropertyMap.get("thumbnail"));
            } else {
                propertyNames.add("photoURLThumbnail");
            }
            if (this.attributePropertyMap.containsKey("photo")) {
                propertyNames.add(this.attributePropertyMap.get("photo"));
            } else {
                propertyNames.add("photoURL");
            }
        } else if ("addresses".equalsIgnoreCase(attributeName)) {
            propertyNames.add("homeStreet");
            propertyNames.add("homeCity");
            propertyNames.add("homeStateOrProvinceName");
            propertyNames.add("homePostalCode");
            propertyNames.add("homeCountryName");
            propertyNames.add("businessStreet");
            propertyNames.add("businessCity");
            propertyNames.add("businessStateOrProvinceName");
            propertyNames.add("businessPostalCode");
            propertyNames.add("businessCountryName");
        } else if ("name".equalsIgnoreCase(attributeName)) {
            propertyNames.add("cn");
            propertyNames.add("sn");
            propertyNames.add("middleName");
            propertyNames.add("honorificPrefix");
            propertyNames.add("honorificSuffix");
        }
        return propertyNames;
    }

    private void setExtendedProperties(PersonAccount person, JSONObject json) {
        Set extendedProperties = person.getExtendedPropertyNames();
        if (extendedProperties == null || extendedProperties.size() == 0) {
            return;
        }
        for (String property : extendedProperties) {
            Object value = json.get((Object)property);
            if (value == null) continue;
            if (value instanceof JSONArray) {
                for (Object val : ((JSONArray)value).toArray()) {
                    person.set(property, val);
                }
                continue;
            }
            person.set(property, value);
        }
    }

    private void setExtendedProperties(JSONObject json, PersonAccount person) {
        Set extendedProperties = person.getExtendedPropertyNames();
        if (extendedProperties == null || extendedProperties.size() == 0) {
            return;
        }
        for (String property : extendedProperties) {
            Object value = person.get(property);
            if (value == null) continue;
            if (value instanceof List) {
                JSONArray array = new JSONArray();
                array.addAll((Collection)((List)value));
                json.put((Object)property, (Object)array);
                continue;
            }
            json.put((Object)property, value);
        }
    }

    @Override
    public String getDefaultType(String attribute) {
        if ("addresses".equalsIgnoreCase(attribute)) {
            return "work";
        }
        if ("phoneNumbers".equalsIgnoreCase(attribute)) {
            return "work";
        }
        if ("photos".equalsIgnoreCase(attribute)) {
            return "photo";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> getWimPropertiesToDelete(JSONObject leftJson, JSONObject rightJson) throws WIMException {
        String key;
        Map<String, Object> rightMap;
        Map<String, Object> leftMap;
        JSONObject leftJsonScim = new JSONObject();
        JSONObject leftJsonWim = new JSONObject();
        JSONObject rightJsonScim = new JSONObject();
        JSONObject rightJsonWim = new JSONObject();
        UserSCIMConverter.split(leftJson, leftJsonScim, leftJsonWim);
        UserSCIMConverter.split(rightJson, rightJsonScim, rightJsonWim);
        try {
            leftMap = (Map<String, Object>)gson.fromJson(leftJsonScim.serialize().toLowerCase(), typeToken);
            rightMap = (Map<String, Object>)gson.fromJson(rightJsonScim.serialize().toLowerCase(), typeToken);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.wim.scim.util.UserSCIMConverter", (String)"1035", (Object)this, (Object[])new Object[]{leftJson, rightJson});
            throw new WIMException((Throwable)e);
        }
        leftMap.remove("meta");
        rightMap.remove("meta");
        leftMap = HandlerUtil.flatten(this, leftMap);
        rightMap = HandlerUtil.flatten(this, rightMap);
        MapDifference difference = Maps.difference(leftMap, rightMap);
        HashSet<String> deletedWimProperties = new HashSet<String>();
        for (Map.Entry entry : difference.entriesOnlyOnLeft().entrySet()) {
            key = (String)entry.getKey();
            if ("/username".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("username"));
                continue;
            }
            if (key.startsWith("/name/")) {
                if ("/name/familyname".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("familyname"));
                    continue;
                }
                if ("/name/givenname".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("givenname"));
                    continue;
                }
                if ("/name/middlename".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("middlename"));
                    continue;
                }
                if ("/name/honorificprefix".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("honorificprefix"));
                    continue;
                }
                if (!"/name/honorificsuffix".equals(key)) continue;
                deletedWimProperties.add(this.getPropertyName("honorificsuffix"));
                continue;
            }
            if ("/displayname".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("displayname"));
                continue;
            }
            if ("/nickname".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("nickname"));
                continue;
            }
            if ("/profileurl".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("profileurl"));
                continue;
            }
            if ("/title".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("title"));
                continue;
            }
            if ("/usertype".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("usertype"));
                continue;
            }
            if ("/preferredlanguage".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("preferredlanguage"));
                continue;
            }
            if ("/locale".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("locale"));
                continue;
            }
            if ("/timezone".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("timezone"));
                continue;
            }
            if ("/active".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("active"));
                continue;
            }
            if ("/password".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("password"));
                continue;
            }
            if ("/emails/0".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("emails"));
                continue;
            }
            if (key.startsWith("/phonenumbers")) {
                if ("/phonenumbers/mobile/value".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("mobile"));
                    continue;
                }
                if ("/phonenumbers/fax/value".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("facsimileTelephoneNumber"));
                    continue;
                }
                if ("/phonenumbers/pager/value".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("pager"));
                    continue;
                }
                if (!"/phonenumbers/work/value".equals(key)) continue;
                deletedWimProperties.add("telephoneNumber");
                continue;
            }
            if ("/ims".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("ims"));
                continue;
            }
            if (key.startsWith("/photos/")) {
                if ("/photos/photo/value".equals(key)) {
                    deletedWimProperties.add(this.getPropertyName("photo"));
                    continue;
                }
                if (!"/photos/thumbnail/value".equals(key)) continue;
                deletedWimProperties.add(this.getPropertyName("thumbnail"));
                continue;
            }
            if (!key.startsWith("/addresses/")) continue;
            if ("/addresses/home/streetaddress".equals(key)) {
                deletedWimProperties.add("homeStreet");
                continue;
            }
            if ("/addresses/home/locality".equals(key)) {
                deletedWimProperties.add("homeCity");
                continue;
            }
            if ("/addresses/home/region".equals(key)) {
                deletedWimProperties.add("homeStateOrProvinceName");
                continue;
            }
            if ("/addresses/home/postalcode".equals(key)) {
                deletedWimProperties.add("homePostalCode");
                continue;
            }
            if ("/addresses/home/country".equals(key)) {
                deletedWimProperties.add("homeCountryName");
                continue;
            }
            if ("/addresses/work/streetaddress".equals(key)) {
                deletedWimProperties.add("businessStreet");
                continue;
            }
            if ("/addresses/work/locality".equals(key)) {
                deletedWimProperties.add("businessCity");
                continue;
            }
            if ("/addresses/work/region".equals(key)) {
                deletedWimProperties.add("businessStateOrProvinceName");
                continue;
            }
            if ("/addresses/work/postalcode".equals(key)) {
                deletedWimProperties.add("businessPostalCode");
                continue;
            }
            if (!"/addresses/work/country".equals(key)) continue;
            deletedWimProperties.add("businessCountryName");
        }
        for (Map.Entry entry : difference.entriesDiffering().entrySet()) {
            key = (String)entry.getKey();
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)entry.getValue();
            if (!(valueDiff.rightValue() instanceof List) || !((List)valueDiff.rightValue()).isEmpty()) continue;
            if ("/emails".equals(key)) {
                deletedWimProperties.add(this.getPropertyName("emails"));
                continue;
            }
            if (!"/ims".equals(key)) continue;
            deletedWimProperties.add(this.getPropertyName("ims"));
        }
        for (String key2 : leftJsonWim.keySet()) {
            Object value = rightJsonWim.get((Object)key2);
            if (value != null && (!(value instanceof List) || !((List)value).isEmpty())) continue;
            deletedWimProperties.add(key2);
        }
        return deletedWimProperties;
    }

    private static void split(JSONObject original, JSONObject scim, JSONObject wim) {
        scim.clear();
        wim.clear();
        scim.putAll((Map)original);
        for (String extPropName : new PersonAccount().getExtendedPropertyNames()) {
            Object value = original.get((Object)extPropName);
            if (value == null) continue;
            wim.put((Object)extPropName, value);
            scim.remove((Object)extPropName);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UserSCIMConverter.class, null, null);
        UTF_8 = Charset.forName("UTF-8");
        gson = new Gson();
        typeToken = new TypeToken<Map<String, Object>>(){
            static final long serialVersionUID = 7149312979342400282L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        }.getType();
    }
}

