/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.context.internal.SubjectRegistryThreadContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SubjectRegistryManager {
    private static ThreadLocal<SubjectRegistryThreadContext> threadLocal;
    static final long serialVersionUID = -3345798376097138600L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    private static SubjectRegistryThreadContext getSubjectRegistryThreadContext() {
        ThreadLocal<SubjectRegistryThreadContext> currentThreadLocal = SubjectRegistryManager.getThreadLocal();
        SubjectRegistryThreadContext subjectRegistryThreadContext = currentThreadLocal.get();
        if (subjectRegistryThreadContext == null) {
            subjectRegistryThreadContext = new SubjectRegistryThreadContext();
            currentThreadLocal.set(subjectRegistryThreadContext);
        }
        return subjectRegistryThreadContext;
    }

    public static void setSubjectIsSAF(boolean isSAF) {
        if (!SubjectRegistryManager.isZOS()) {
            return;
        }
        SubjectRegistryThreadContext subjectRegistryThreadContext = SubjectRegistryManager.getSubjectRegistryThreadContext();
        subjectRegistryThreadContext.setIsSAF(isSAF);
    }

    public static void startSubjectRegistryDetectionOnZOS() {
        if (!SubjectRegistryManager.isZOS()) {
            return;
        }
        SubjectRegistryThreadContext subjectRegistryThreadContext = SubjectRegistryManager.getSubjectRegistryThreadContext();
        subjectRegistryThreadContext.detect();
    }

    public static void clearSubjectRegistryDetectionOnZOS() {
        if (!SubjectRegistryManager.isZOS()) {
            return;
        }
        SubjectRegistryThreadContext subjectRegistryThreadContext = SubjectRegistryManager.getSubjectRegistryThreadContext();
        subjectRegistryThreadContext.donotdetect();
    }

    public static boolean isCreateSAFCredential() {
        if (!SubjectRegistryManager.isZOS()) {
            return false;
        }
        SubjectRegistryThreadContext subjectRegistryThreadContext = SubjectRegistryManager.getSubjectRegistryThreadContext();
        return subjectRegistryThreadContext.isCreateSAFCredential();
    }

    @Trivial
    private static ThreadLocal<SubjectRegistryThreadContext> getThreadLocal() {
        return threadLocal;
    }

    private static final boolean isZOS() {
        String osName = System.getProperty("os.name");
        return osName.contains("OS/390") || osName.contains("z/OS") || osName.contains("zOS");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.context.SubjectRegistryManager", SubjectRegistryManager.class, null, null);
        threadLocal = new SecurityThreadLocal();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class SecurityThreadLocal
    extends ThreadLocal<SubjectRegistryThreadContext> {
        static final long serialVersionUID = 6364335427633204467L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SecurityThreadLocal() {
        }

        @Override
        protected SubjectRegistryThreadContext initialValue() {
            return new SubjectRegistryThreadContext();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.context.SubjectRegistryManager$SecurityThreadLocal", SecurityThreadLocal.class, null, null);
        }
    }
}

