/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.liberty.generateplugin;

import com.ibm.ws.common.internal.encoder.Base64Coder;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.crypto.Cipher;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class GeneratePlugin {
    private static final String GENERATE_PLUGIN_CONFIG_NAME = "WebSphere:name=com.ibm.ws.jmx.mbeans.generatePluginConfig";
    private static final String JMX_FILE = "com.ibm.ws.jmx.local.address";
    private static final String REST_FILE = "com.ibm.ws.jmx.rest.address";
    private static String serverNameLoc = null;
    private static String jmxUser = null;
    private static String jmxPasswd = null;
    private static PrivateKey privateKey = null;
    private static String privateKeyLoc = null;
    private static String decryptedPasswd = null;
    private static boolean jmxLocal = true;
    static final String _provider = "IBMJCE";
    static final String _cryptography = "RSA";
    static final String _keystoreType = "JKS";
    static final String _encryptedFlag = "-encryptedPassword";
    static JMXConnector connector = null;

    public static void main(String[] args) {
        System.out.println("Entry:GeneratePlugin");
        GeneratePlugin.processArgs(args);
        String separator = System.getProperty("file.separator");
        String location = serverNameLoc + separator + "workarea" + separator + JMX_FILE;
        String restLocation = serverNameLoc + separator + "workarea" + separator + REST_FILE;
        System.out.println("Fully qualify jmx file location:" + location);
        System.out.println("Fully qualify rest file location:" + restLocation);
        File jmxLocalFile = new File(location);
        jmxLocal = jmxLocalFile.exists();
        System.out.println(" jmx local = " + jmxLocal);
        String jmxConnectionString = null;
        MBeanServerConnection mbeanServerConn = null;
        ObjectName objectName = null;
        try {
            if (jmxPasswd != null && privateKeyLoc != null) {
                System.out.println("Calling decryptPasswords");
                decryptedPasswd = GeneratePlugin.decryptPassword(jmxPasswd, privateKeyLoc);
            }
        }
        catch (Exception e) {
            System.err.println("decryptedPasswordException: " + e.getMessage());
            System.err.println(e.getMessage());
            System.err.println(e);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("Calling getJMXPort");
            jmxConnectionString = jmxLocal ? GeneratePlugin.getJMXPort(location) : GeneratePlugin.getJMXPort(restLocation);
        }
        catch (Exception e) {
            System.err.println("getJMXPortException: " + e.getMessage());
            System.err.println(e.getMessage());
            System.err.println(e);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("Calling openJMXMBeanServerConnection ");
            mbeanServerConn = GeneratePlugin.openJMXMBeanServerConnection(jmxConnectionString, jmxUser, decryptedPasswd);
        }
        catch (Exception e) {
            System.err.println("Exception in openJMXBeanServerConnection: " + e.getMessage());
            e.printStackTrace();
            System.err.println(e);
            System.exit(2);
        }
        try {
            System.out.println("Calling getGeneratePluginConfigObjectName ");
            objectName = GeneratePlugin.getGeneratePluginConfigObjectName(mbeanServerConn);
        }
        catch (Exception e) {
            System.err.println("Exception in generatePluginConfigObjectName: " + e.getMessage());
            System.err.println(e);
            e.printStackTrace();
            System.exit(3);
        }
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        try {
            System.out.println("Executing mbeanServerConn.invoke with generateDefaultPluginConfig to create plugin-cfg.xml");
            mbeanServerConn.invoke(objectName, "generateDefaultPluginConfig", params, signature);
        }
        catch (Exception e) {
            System.err.println("Exception in generatePluginConfig: " + e.getMessage());
            System.err.println(e);
            e.printStackTrace();
            System.exit(4);
        }
        try {
            connector.close();
        }
        catch (Exception e1) {
            System.err.println("Exception closing connection: " + e1.getMessage());
            System.err.println(e1);
            e1.printStackTrace();
            System.exit(5);
        }
        System.out.println("Exit:GeneratePlugin");
    }

    private static void processArgs(String[] args) {
        String methodName = "processArgs";
        System.out.println(" Arguments passed = " + Arrays.toString(args));
        int i = 0;
        boolean serverLocFound = false;
        System.out.println("Entry: processArgs");
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-serverLocation")) {
                if (i < args.length) {
                    serverNameLoc = args[i++];
                    if (i > args.length) continue;
                    if (!serverNameLoc.startsWith("-")) {
                        System.out.println("-serverLocation = " + serverNameLoc);
                        serverLocFound = true;
                        continue;
                    }
                    System.err.println("-serverLocation requires the location of the server");
                    continue;
                }
                System.err.println("-serverLocation  requires the location of the server");
                continue;
            }
            if (arg.equals("-jmxUser")) {
                if (i < args.length) {
                    jmxUser = args[i++];
                    if (i > args.length) continue;
                    if (!jmxUser.startsWith("-")) {
                        System.out.println("-jmxUser = " + jmxUser);
                        continue;
                    }
                    System.err.println("-jmxUser requires a jmx User id");
                    continue;
                }
                System.err.println("-jmxUser requires a jmx User id");
                continue;
            }
            if (arg.equals("-jmxPassword")) {
                if (i < args.length) {
                    jmxPasswd = args[i++];
                    if (i > args.length) continue;
                    if (!jmxPasswd.startsWith("-")) {
                        System.out.println("-jmxPassword = xxxxxx");
                        continue;
                    }
                    System.err.println("-jmxPassword requires a jmx password ");
                    continue;
                }
                System.err.println("-jmxPassword requires a jmx password ");
                continue;
            }
            if (!arg.equals("-privateKeyLoc")) continue;
            if (i < args.length) {
                privateKeyLoc = args[i++];
                if (i > args.length) continue;
                if (!privateKeyLoc.startsWith("-")) {
                    System.out.println("-privateKeyLoc =" + privateKeyLoc);
                    continue;
                }
                System.err.println("-privateKeyLoc requires the location of the private key");
                continue;
            }
            System.err.println("-privateKeyLoc requires the location of the private key");
        }
        if (!serverLocFound) {
            System.err.println("Number of Args is " + args.length);
            System.err.println("Usage: generatePlugin -serverLocation {<serverLocation> -jmxUser <jmxuser> -jmxPassword <jmxPasswd> -privateKeyLoc <privateKeyLoc>}");
            System.exit(1);
        }
        System.out.println("Exit: processArgs");
    }

    private static String getJMXPort(String location) throws ConnectException {
        String jmxPort;
        block6: {
            String methodName = "getJMXPort";
            String pathToJMXFile = location;
            jmxPort = null;
            String strLine = null;
            System.out.println("Entry:getJMXPort");
            File jmxPortNewFile = new File(location);
            if (!jmxPortNewFile.exists()) {
                throw new SecurityException("LibertyJMXFileNotFound:" + location);
            }
            FileInputStream fstream = null;
            try {
                fstream = new FileInputStream(pathToJMXFile);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    jmxPort = strLine;
                }
                br.close();
                in.close();
                fstream.close();
            }
            catch (Exception e) {
                System.err.println("getJMXPort:" + e.getMessage());
                e.printStackTrace();
                System.err.println(e);
                if (fstream == null) break block6;
                try {
                    fstream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.out.println("Exit:getJMXPort");
        return jmxPort;
    }

    private static MBeanServerConnection openJMXMBeanServerConnection(String jmxConnectionString, String jmxUsr, String jmxPwd) throws MalformedURLException, IOException {
        String methodName = "openJMXMBeanServerConnection";
        System.out.println("Entry:openJMXMBeanServerConnection");
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.");
        if (jmxUser != null && jmxPwd != null) {
            environment.put("jmx.remote.credentials", new String[]{jmxUsr, jmxPwd});
        }
        JMXServiceURL url = null;
        MBeanServerConnection mbsc = null;
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLSocketFactory ssf = GeneratePlugin.getSSLSocketFactory();
            System.out.println("Get Ciphers " + Arrays.toString(ssf.getDefaultCipherSuites()));
            environment.put("com.ibm.ws.jmx.connector.client.rest.notificationDeliveryInterval", 5000);
            HttpsURLConnection.setDefaultSSLSocketFactory(ssf);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            url = new JMXServiceURL(jmxConnectionString);
            System.out.println("Value of url:" + url);
        }
        catch (Exception e) {
            System.err.println("Exception in JMXServceURL");
            e.printStackTrace();
            System.err.println(e);
        }
        try {
            connector = JMXConnectorFactory.connect(url, environment);
        }
        catch (SecurityException se) {
            System.err.println("LibertySecurityException=" + se.getMessage());
            se.printStackTrace();
            throw se;
        }
        try {
            mbsc = connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            System.err.println("Exception in connector.getMbenServerConnection");
            e.printStackTrace();
            System.err.println(e);
        }
        System.out.println("Exit:openJMXMBeanServerConnection");
        return mbsc;
    }

    private static ObjectName getGeneratePluginConfigObjectName(MBeanServerConnection mbeanServerConn) throws Exception {
        String methodName = "getGeneratePluginConfigObjectName";
        System.out.println("Entry:getGeneratePluginConfigObjectName");
        ObjectName objectName = new ObjectName(GENERATE_PLUGIN_CONFIG_NAME);
        QueryExp queryExp = null;
        Set<ObjectName> objectNames = mbeanServerConn.queryNames(objectName, queryExp);
        int numObjectNames = objectNames.size();
        if (numObjectNames != 1) {
            throw new Exception("numObjectnames:Expected only 1 object name for generate plugin mbean.");
        }
        System.out.println("Exit:getGeneratePluginConfigObjectName");
        return objectName;
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        String methodName = "getSSLSocketFactory";
        System.out.println("Entry:getSSLSocketFactory");
        try {
            TrustManager[] trustManagers = null;
            if (trustManagers == null) {
                trustManagers = new TrustManager[]{GeneratePlugin.createTrustAllTrustManager()};
            }
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagers, null);
            SSLSocketFactory socketFactory = ctx.getSocketFactory();
            System.out.println("Exit:getSSLSocketFactory");
            return socketFactory;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to establish SSLSocketFactory", e);
        }
    }

    private static X509TrustManager createTrustAllTrustManager() {
        String methodName = "createTrustAllManager";
        System.out.println("Entry:createTrustAllManager");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        System.out.println("Exit:createTrustAllManager");
        return tm;
    }

    private static String decryptPassword(String encryptedPasswwd, String privateKeyFile) throws Exception {
        String methodName = "decryptPassword";
        System.out.println("Entry:decryptPassword");
        privateKey = GeneratePlugin.getPrivateKey(privateKeyFile, _cryptography);
        byte[] decoded = Base64Coder.base64Decode((byte[])encryptedPasswwd.getBytes());
        Cipher decryptCipher = Cipher.getInstance(_cryptography);
        decryptCipher.init(2, privateKey);
        byte[] decrypted = decryptCipher.doFinal(decoded);
        String decryptedPwd = new String(decrypted);
        System.out.println("Exit:decryptPassword");
        return decryptedPwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getPrivateKey(String path, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String methodName = "getPrivateKey";
        PrivateKey privateKey = null;
        System.out.println("Entry:getPrivateKey");
        try (FileInputStream fis = null;){
            File filePrivateKey = new File(path);
            byte[] encodedPrivateKey = new byte[(int)filePrivateKey.length()];
            fis = new FileInputStream(filePrivateKey);
            fis.read(encodedPrivateKey);
            fis.close();
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
            privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        System.out.println("Exit:getPrivateKey");
        return privateKey;
    }
}

