/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serverstatus.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serverstatus.internal.FileUtils;
import com.ibm.ws.serverstatus.internal.PropertyUtils;
import com.ibm.ws.serverstatus.internal.ServerStatusTimerTask;
import com.ibm.ws.serverstatus.internal.TrustManager;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Poster {
    private static TraceComponent tc = Tr.register(Poster.class, (String)"serverStatus", (String)"com.ibm.ws.serverstatus.internal.resources.SStatus");
    static final String CLASSNAME = "com.ibm.ws.serverstatus.internal.Poster";
    private static final int MAX_RETRIES = 4;
    private static final int INITIAL_RETRY_INTERVAL = 8000;
    static final String delimiter = "::";
    static final long serialVersionUID = 8201540186323691143L;

    public void postStatus(String status, Properties properties, String serverWorkarea) {
        this.postStatus(status, properties, serverWorkarea, 8000, 1);
    }

    public void postStatusNoRetries(String status, Properties properties, String serverWorkarea) {
        this.postStatus(status, properties, serverWorkarea, -1, 1);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void postStatus(String status, Properties properties, String serverWorkarea, int retryInterval, int postAttempt) {
        boolean success;
        block14: {
            SSLContext context;
            String METHOD = "postStatus";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("postStatus {status=" + status + " postAttempt=" + postAttempt + " retryInterval=" + retryInterval + "}"), (Object[])new Object[0]);
            }
            TrustManager trustManager = new TrustManager(FileUtils.buildPathString(serverWorkarea, PropertyUtils.getKeystore(properties)), PropertyUtils.getPassword(properties));
            String statusTuple = PropertyUtils.getResource(properties) + delimiter + status;
            success = false;
            if (statusTuple != null && (context = this.getSSLContext(trustManager)) != null) {
                SSLSocketFactory factory = context.getSocketFactory();
                URI uri = null;
                try {
                    uri = new URI(PropertyUtils.getUrl(properties));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Post attempt " + postAttempt + " for address: " + uri), (Object[])new Object[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Data to send: " + statusTuple), (Object[])new Object[0]);
                    }
                    SSLSocket sslSocket = (SSLSocket)factory.createSocket(uri.getHost(), uri.getPort());
                    sslSocket.startHandshake();
                    OutputStream os = sslSocket.getOutputStream();
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    for (int index = 0; index < statusTuple.length(); ++index) {
                        bos.write(statusTuple.getBytes(), index, 1);
                    }
                    bos.flush();
                    success = true;
                }
                catch (URISyntaxException os) {
                    void use;
                    FFDCFilter.processException((Throwable)os, (String)CLASSNAME, (String)"118", (Object)this, (Object[])new Object[]{status, properties, serverWorkarea, retryInterval, postAttempt});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error: " + use.getMessage()), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)use, (String)"com.ibm.ws.serverstatus.internal.Poster.postStatus", (String)"110", (Object)this);
                }
                catch (IllegalArgumentException use) {
                    void iae;
                    FFDCFilter.processException((Throwable)use, (String)CLASSNAME, (String)"127", (Object)this, (Object[])new Object[]{status, properties, serverWorkarea, retryInterval, postAttempt});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error: " + iae.getMessage()), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.serverstatus.internal.Poster.postStatus", (String)"110", (Object)this);
                }
                catch (Exception iae) {
                    void e;
                    FFDCFilter.processException((Throwable)iae, (String)CLASSNAME, (String)"136", (Object)this, (Object[])new Object[]{status, properties, serverWorkarea, retryInterval, postAttempt});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Post failed: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.serverstatus.internal.Poster.postStatus", (String)"115", (Object)this);
                    if (retryInterval < 0 || postAttempt > 4) break block14;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Queue another attempt for url: " + uri), (Object[])new Object[0]);
                    }
                    URI[] retryURI = new URI[]{uri};
                    new ServerStatusTimerTask(status, properties, serverWorkarea, retryInterval, postAttempt);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postStatus success=" + success));
        }
    }

    /*
     * WARNING - void declaration
     */
    private SSLContext getSSLContext(TrustManager trustManager) {
        String METHOD = "getSSLContext";
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("SSL");
            javax.net.ssl.TrustManager[] tm = new javax.net.ssl.TrustManager[]{trustManager};
            KeyManager[] km = trustManager.getKeyManagers();
            context.init(km, tm, null);
        }
        catch (Exception tm) {
            void e;
            FFDCFilter.processException((Throwable)tm, (String)CLASSNAME, (String)"181", (Object)this, (Object[])new Object[]{trustManager});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.serverstatus.internal.Poster.getSSLContext", (String)"175", (Object)this);
        }
        return context;
    }
}

