/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serverstatus.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PropertyUtils {
    static final String CLASSNAME = "com.ibm.ws.serverstatus.internal.PropertyUtils";
    static final String KEYSTORE = "keystore";
    static final String RESOURCE = "resource";
    static final String URLKEY = "url";
    static final String PASSWORD = "password";
    static final long serialVersionUID = -1957814403081914609L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public static Properties loadProperties(String propertiesName) throws Exception {
        if (propertiesName != null && propertiesName.trim().length() > 0) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertiesName);
                Properties fileProperties = new Properties();
                fileProperties.load(fis);
                fis.close();
                PropertyUtils.validateProperties(fileProperties);
                return fileProperties;
            }
            catch (Exception fileProperties) {
                void e;
                FFDCFilter.processException((Throwable)fileProperties, (String)CLASSNAME, (String)"55", null, (Object[])new Object[]{propertiesName});
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"59", null, (Object[])new Object[]{propertiesName});
                    }
                }
                throw e;
            }
        }
        return null;
    }

    public static void validateProperties(Properties properties) throws Exception {
        if (properties == null) {
            throw new Exception("Properties are null");
        }
        PropertyUtils.isValidString(properties.get(RESOURCE));
        PropertyUtils.isValidUrlString(properties.get(URLKEY));
        PropertyUtils.isValidString(properties.get(KEYSTORE));
        PropertyUtils.isValidString(properties.get(PASSWORD));
    }

    public static String getResource(Properties properties) {
        try {
            String resource = ((String)properties.get(RESOURCE)).trim();
            PropertyUtils.isValidString(resource);
            return resource;
        }
        catch (Exception resource) {
            FFDCFilter.processException((Throwable)resource, (String)CLASSNAME, (String)"102", null, (Object[])new Object[]{properties});
            return "";
        }
    }

    public static String getUrl(Properties properties) {
        try {
            PropertyUtils.isValidUrlString(properties.get(URLKEY));
            return properties.getProperty(URLKEY);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"118", null, (Object[])new Object[]{properties});
            return "";
        }
    }

    public static String getKeystore(Properties properties) {
        try {
            PropertyUtils.isValidString(properties.get(KEYSTORE));
            return properties.getProperty(KEYSTORE);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"134", null, (Object[])new Object[]{properties});
            return "";
        }
    }

    public static ProtectedString getPassword(Properties properties) {
        try {
            PropertyUtils.isValidString(properties.get(PASSWORD));
            String encryptedPassword = properties.getProperty(PASSWORD);
            return new ProtectedString(PasswordUtil.decode((String)encryptedPassword).toCharArray());
        }
        catch (Exception encryptedPassword) {
            FFDCFilter.processException((Throwable)encryptedPassword, (String)CLASSNAME, (String)"151", null, (Object[])new Object[]{properties});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void isValidUrlString(Object value) throws Exception {
        try {
            PropertyUtils.isValidString(value);
            new URL((String)value);
            new URI((String)value);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"168", null, (Object[])new Object[]{value});
            Exception e1 = new Exception("Value is not a valid URL: " + value);
            e1.setStackTrace(e.getStackTrace());
            throw e1;
        }
    }

    private static void isValidString(Object value) throws Exception {
        if (value == null || !(value instanceof String) || ((String)value).trim().length() < 1) {
            throw new Exception("Value is not a valid property String: " + value);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PropertyUtils.class, (String)"serverStatus", (String)"com.ibm.ws.serverstatus.internal.resources.SStatus");
    }
}

