/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serverstatus.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serverstatus.ServerStatus;
import com.ibm.ws.serverstatus.internal.FileUtils;
import com.ibm.ws.serverstatus.internal.Poster;
import com.ibm.ws.serverstatus.internal.PropertyFilenameFilter;
import com.ibm.ws.serverstatus.internal.PropertyUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerStatusImpl
implements ServerStatus {
    private static final TraceComponent tc = Tr.register(ServerStatusImpl.class, (String)"serverStatus", (String)"com.ibm.ws.serverstatus.internal.resources.SStatus");
    static final String CLASSNAME = "com.ibm.ws.serverstatus.internal.ServerStatusImpl";
    static String serverOutputDir = System.getProperty("server.output.dir");
    static String serverWorkarea = null;
    HashMap<String, Properties> configProperties = null;
    boolean propertiesLoaded = false;
    static final long serialVersionUID = -1728268537187544366L;

    @ManualTrace
    protected void activate(ComponentContext cc) {
        String METHOD = "activate";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activate", (Object[])new Object[0]);
        }
        this.postStatus("STARTED", true);
        Tr.info((TraceComponent)tc, (String)"ss.init.startcomplete.CWWKJ0001I", (Object[])new Object[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate() {
        this.postStatus("STOPPED", false);
    }

    private void postStatus(String status, boolean retry) {
        this.loadPropertyFiles();
        if (this.propertiesLoaded) {
            Set<String> resourceIDs = this.configProperties.keySet();
            for (String resource : resourceIDs) {
                if (resource == null) continue;
                Properties properties = this.configProperties.get(resource);
                Poster poster = new Poster();
                if (retry) {
                    poster.postStatus(status, properties, serverWorkarea);
                    continue;
                }
                poster.postStatusNoRetries(status, properties, serverWorkarea);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void loadPropertyFiles() {
        String METHOD = "loadPropertyFiles";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadPropertyFiles", (Object[])new Object[0]);
        }
        ServerStatusImpl.setServerWorkarea();
        if (serverWorkarea != null) {
            File dir = new File(serverWorkarea);
            String[] files = dir.list(new PropertyFilenameFilter());
            this.configProperties = new HashMap();
            if (files != null && files.length > 0) {
                for (String filename : files) {
                    String fullFilename = FileUtils.buildPathString(serverWorkarea, filename);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Processing property file: " + fullFilename), (Object[])new Object[0]);
                    }
                    try {
                        Properties properties = PropertyUtils.loadProperties(fullFilename);
                        if (properties == null) continue;
                        this.configProperties.put(PropertyUtils.getResource(properties), properties);
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"123", (Object)this, (Object[])new Object[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Property file load failure: " + e.getMessage()), (Object[])new Object[0]);
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.serverstatus.internal.ServerStatusImpl.loadPropertyFiles", (String)"138", (Object)this);
                    }
                }
                this.propertiesLoaded = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadPropertyFiles");
        }
    }

    private static void setServerWorkarea() {
        if (serverWorkarea != null) {
            return;
        }
        if (serverOutputDir == null || serverOutputDir.trim().length() < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No server output directory set, cannot set work area location", (Object[])new Object[0]);
            }
            serverWorkarea = null;
        } else {
            serverWorkarea = FileUtils.buildPathString(serverOutputDir, "workarea");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Work area location: " + serverWorkarea), (Object[])new Object[0]);
            }
        }
    }
}

