/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serverstatus.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serverstatus.internal.Poster;
import com.ibm.ws.serverstatus.internal.PropertyUtils;
import java.util.Calendar;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerStatusTimerTask
extends TimerTask {
    private static TraceComponent tc = Tr.register(ServerStatusTimerTask.class, (String)"serverStatus", (String)"com.ibm.ws.serverstatus.internal.resources.SStatus");
    private static final int MAX_SLEEP_INTERVAL = 8000;
    private static final double SLEEP_INTERVAL_EXPONENT = 1.0;
    private Timer timer = null;
    String status = null;
    Properties properties = null;
    String serverWorkarea = null;
    int sleepInterval = -1;
    int retryCount = 0;
    static final long serialVersionUID = -4360111976804041215L;

    public ServerStatusTimerTask(String status, Properties properties, String serverWorkarea, int sleepInterval, int retryCount) {
        this.status = status;
        this.properties = properties;
        this.serverWorkarea = serverWorkarea;
        this.sleepInterval = sleepInterval;
        this.retryCount = retryCount;
        this.timer = new Timer();
        this.startTimer();
    }

    @Override
    @ManualTrace
    public void run() {
        String METHOD = "run";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("run {resource=" + PropertyUtils.getResource(this.properties) + " status=" + this.status + "}"), (Object[])new Object[0]);
        }
        this.timer.purge();
        this.cancel();
        Poster poster = new Poster();
        poster.postStatus(this.status, this.properties, this.serverWorkarea, this.computeNextSleepInterval(), ++this.retryCount);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    @ManualTrace
    private void startTimer() {
        String METHOD = "startTimer";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startTimer {resource=" + PropertyUtils.getResource(this.properties) + " status=" + this.status + "}"), (Object[])new Object[0]);
        }
        if (this.sleepInterval > 0) {
            if (tc.isDebugEnabled()) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(cal.getTimeInMillis() + (long)this.sleepInterval);
                Tr.debug((TraceComponent)tc, (String)("Alarm time: " + cal.getTime()), (Object[])new Object[0]);
            }
            this.timer.schedule((TimerTask)this, this.sleepInterval);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No alarm scheduled, sleep interval is not valid: " + this.sleepInterval), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startTimer");
        }
    }

    private int computeNextSleepInterval() {
        Double newSleepIntervalDbl;
        int newSleepInterval = this.sleepInterval;
        if (this.sleepInterval < 8000 && (newSleepInterval = (newSleepIntervalDbl = new Double((double)this.sleepInterval * 1.0)).intValue()) == this.sleepInterval) {
            ++newSleepInterval;
        }
        if (newSleepInterval > 8000) {
            newSleepInterval = 8000;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Last interval: " + this.sleepInterval + " Next interval: " + newSleepInterval), (Object[])new Object[0]);
        }
        return newSleepInterval;
    }
}

