/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serverstatus.internal;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509TrustManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TrustManager
implements X509TrustManager {
    private static TraceComponent tc = Tr.register(TrustManager.class, (String)"serverStatus", (String)"com.ibm.ws.serverstatus.internal.resources.SStatus");
    private static final String CLASSNAME = "com.ibm.ws.serverstatus.internal.TrustManager";
    private KeyStore keystore = null;
    private char[] keystorePassword = null;
    static final long serialVersionUID = 947739659289123716L;

    public TrustManager(String filename, ProtectedString password) {
        this.loadKeystore(filename, password);
    }

    /*
     * WARNING - void declaration
     */
    public KeyManager[] getKeyManagers() {
        String METHOD = "getKeyManagers";
        if (this.keystore != null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(this.keystore, this.keystorePassword);
                KeyManager[] kms = kmf.getKeyManagers();
                return kms;
            }
            catch (Exception kms) {
                void e;
                FFDCFilter.processException((Throwable)kms, (String)CLASSNAME, (String)"69", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to get key manager, will use default: " + e.getMessage()), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.serverstatus.internal.TrustManager.getKeyManagers", (String)"69", (Object)this);
            }
        }
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certChain, String alias) throws CertificateException {
        this.checkKeystore(certChain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certChain, String alias) throws CertificateException {
        this.checkKeystore(certChain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void loadKeystore(String filename, ProtectedString password) {
        block12: {
            String METHOD = "loadKeystore";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("loadKeystore {filename=" + filename + "}"), (Object[])new Object[0]);
            }
            FileInputStream fis = null;
            File file = new File(filename);
            try {
                if (file.length() <= 0L) {
                    Exception e = new Exception("Keystore file specified could not be found: " + filename);
                    throw e;
                }
                fis = new FileInputStream(filename);
                if (password.toString() != null) {
                    this.keystorePassword = password.getChars();
                }
                this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.keystore.load(fis, this.keystorePassword);
                fis.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Keystore loaded with total number of entries: " + this.keystore.size()), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)CLASSNAME, (String)"169", (Object)this, (Object[])new Object[]{filename, password});
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error reading keystore file " + file.getCanonicalFile() + ": " + e.getMessage()), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.serverstatus.internal.TrustManager.loadKeystore", (String)"163", (Object)this);
                }
                catch (IOException iOException) {
                    void ioe;
                    FFDCFilter.processException((Throwable)iOException, (String)CLASSNAME, (String)"180", (Object)this, (Object[])new Object[]{filename, password});
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.serverstatus.internal.TrustManager.loadKeystore", (String)"171", (Object)this);
                }
                if (fis == null) break block12;
                try {
                    fis.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"189", (Object)this, (Object[])new Object[]{filename, password});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadKeystore");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkKeystore(X509Certificate[] certChain) throws CertificateException {
        String METHOD = "checkKeystore";
        if (this.keystore == null) {
            throw new CertificateException("No keystore defined for the Trust Manager");
        }
        try {
            for (X509Certificate cert : certChain) {
                String testAlias = this.keystore.getCertificateAlias(cert);
                if (testAlias == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Certificate chain found in keystore", (Object[])new Object[0]);
                }
                return;
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"227", (Object)this, (Object[])new Object[]{certChain});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.serverstatus.internal.TrustManager.checkKeystore", (String)"171", (Object)this);
            throw new CertificateException(e.getMessage());
        }
        throw new CertificateException("Certificate chain not found in keystore");
    }
}

