/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.servlet.session.IBMApplicationSession;
import com.ibm.ws.session.HttpSessionFacade;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionContextRegistry;
import com.ibm.ws.session.SessionCrossoverStackTrace;
import com.ibm.ws.session.http.HttpSessionImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.util.ArrayEnumeration;
import com.ibm.wsspi.servlet.session.IBMSessionExt;
import com.ibm.wsspi.session.ISession;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class SessionData
extends HttpSessionImpl
implements IBMSessionExt {
    private static final long serialVersionUID = -76305717244905946L;
    protected HttpSessionFacade _httpSessionFacade = this.returnFacade();
    protected static final String SECURITY_PROP_NAME = "com_ibm_ejs_security_httpsession_info";
    protected boolean _hasSecurityInfo = true;
    protected LinkedList lockList;
    protected HashMap locks = null;
    protected String pathInfoForAppSession = null;
    String sipCookieInfo = null;
    private SessionContext _sessCtx;
    protected String appName;
    private boolean affinityEstablished = false;
    protected IBMApplicationSession mIBMApplicationSession = null;
    protected static final WebSphereRuntimePermission invalidateAllPerm = new WebSphereRuntimePermission("accessInvalidateAll");
    private static final String methodClassName = "SessionData";
    private static final int PUT_SESSION_VALUE = 0;
    private static final int GET_SESSION_VALUE = 1;
    private static final int REMOVE_SESSION_VALUE = 2;
    private static final int SET_IBM_APPLICATION_SESSION = 3;
    private static final String[] methodNames = new String[]{"putSessionValue", "getSessionValue", "removeSessionValue", "setIBMApplicationSession"};

    public SessionData(ISession session, SessionContext sessCtx, ServletContext servCtx) {
        super(session);
        this._sessCtx = sessCtx;
        this.appName = this._sessCtx.getAppName();
        this.setServletContext(servCtx);
    }

    protected HttpSessionFacade returnFacade() {
        return new HttpSessionFacade(this);
    }

    @Override
    public void invalidateAll(boolean remote) throws SecurityException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String logString = "(" + remote + ") for app " + this.appName + " id " + this.getId();
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "invalidateAll", logString);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission((Permission)invalidateAllPerm);
        }
        SessionContextRegistry.getInstance().invalidateAll(this.getId(), this._sessCtx.getAppName(), this, remote, false);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "invalidateAll");
        }
    }

    @Override
    public void invalidateAll() throws SecurityException {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "invalidateAll", "will default to invalidateAll(false)");
        }
        this.invalidateAll(false);
    }

    @Override
    public String getUserName() {
        return this.getISession().getUserName();
    }

    public void setUser(String value) {
        this.getISession().setUserName(value);
    }

    @Override
    public void sync() {
        this.getISession().flush();
    }

    @Override
    public Object getAttribute(String pName) {
        this.crossoverCheck("getAttribute");
        return this.getSessionValue(pName, false);
    }

    @Override
    public Object getValue(String pName) {
        return this.getSessionValue(pName, false);
    }

    @Override
    public Enumeration getAttributeNames() {
        Enumeration attrNameEnum;
        if (!this._hasSecurityInfo) {
            attrNameEnum = super.getAttributeNames();
        } else {
            Object[] attrNames = this.getValueNames();
            attrNameEnum = new ArrayEnumeration(attrNames);
        }
        return attrNameEnum;
    }

    @Override
    public String[] getValueNames() {
        Enumeration enumeration = super.getAttributeNames();
        Vector<String> valueNames = new Vector<String>();
        String name = null;
        boolean securityPropFound = false;
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            if (!name.equals(SECURITY_PROP_NAME)) {
                valueNames.add(name);
                continue;
            }
            securityPropFound = true;
        }
        this._hasSecurityInfo = securityPropFound;
        String[] names = new String[valueNames.size()];
        return valueNames.toArray(names);
    }

    @Override
    public void setAttribute(String pName, Object pValue) {
        this.crossoverCheck("setAttribute");
        if (pName != null && pValue == null) {
            this.removeAttribute(pName);
        } else {
            this.putSessionValue(pName, pValue, false);
        }
    }

    @Override
    public void putValue(String pName, Object pValue) {
        this.putSessionValue(pName, pValue, false);
    }

    @Override
    public void removeAttribute(String pName) {
        this.crossoverCheck("removeAttribute");
        this.removeSessionValue(pName);
    }

    @Override
    public void removeValue(String pName) {
        this.removeSessionValue(pName);
    }

    @Override
    public void invalidate() {
        this.crossoverCheck("invalidate");
        super.invalidate();
    }

    protected void putSessionValue(String pName, Object value, boolean securityInfo) {
        if (pName == null) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[0], "SessionData.putValErr1");
            return;
        }
        if (value == null) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[0], "SessionData.putValErr2", pName);
            return;
        }
        if (pName.equals(SECURITY_PROP_NAME) && !securityInfo) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "attempt to set security info failed");
            }
            return;
        }
        super.setAttribute(pName, value);
    }

    protected Object getSessionValue(String pName, boolean securityInfo) {
        if (pName.equals(SECURITY_PROP_NAME) && !securityInfo) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "attempt to retrieve security info failed");
            }
            return null;
        }
        return super.getAttribute(pName);
    }

    private void removeSessionValue(String pName) {
        if (pName.equals(SECURITY_PROP_NAME)) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[2], "attempt to remove security info failed");
            }
            return;
        }
        super.removeAttribute(pName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getLockList() {
        if (this.lockList == null) {
            SessionData sessionData = this;
            synchronized (sessionData) {
                this.lockList = new LinkedList();
            }
        }
        return this.lockList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionLock(Object tid, Object lock) {
        SessionData sessionData = this;
        synchronized (sessionData) {
            if (this.locks == null) {
                this.locks = new HashMap(5);
            }
            this.locks.put(tid, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionLock(Object tid) {
        if (this.locks == null) {
            return null;
        }
        SessionData sessionData = this;
        synchronized (sessionData) {
            return this.locks.remove(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessionLocks() {
        if (this.locks != null) {
            SessionData sessionData = this;
            synchronized (sessionData) {
                this.locks.clear();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.getISession().writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.getISession().readExternal(in);
    }

    public void setIBMApplicationSession(IBMApplicationSession appSession) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[3], "for app " + this.appName + " IBMApplicationSession " + appSession);
        }
        this.mIBMApplicationSession = appSession;
    }

    @Override
    public IBMApplicationSession getIBMApplicationSession() {
        return this.getIBMApplicationSession(true);
    }

    @Override
    public IBMApplicationSession getIBMApplicationSession(boolean create) {
        return null;
    }

    public IBMApplicationSession getIBMApplicationSession(boolean create, String logicalServerName) {
        return null;
    }

    public SessionContext getSessCtx() {
        return this._sessCtx;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfoForAppSession = pathInfo;
    }

    public void setSIPCookieInfo(HttpServletRequest _request) {
        String sipLogicalServerName = null;
        byte[] byteSipLogicalServerName = null;
        if (byteSipLogicalServerName != null) {
            sipLogicalServerName = new String(byteSipLogicalServerName);
        }
        if (sipLogicalServerName != null && sipLogicalServerName.length() > 0) {
            this.sipCookieInfo = sipLogicalServerName;
        }
    }

    private void crossoverCheck(String method) {
        if (this._sessCtx._smc.isDebugSessionCrossover() && this._sessCtx.crossoverCheck(this)) {
            Object[] parms = new Object[]{this.appName, this.getId(), method, this._sessCtx.getCurrentSessionId()};
            LoggingUtil.logParamsAndException(LoggingUtil.SESSION_LOGGER_CORE, Level.SEVERE, methodClassName, "crossoverCheck", "SessionContext.CrossoverOnReference", parms, new SessionCrossoverStackTrace());
        }
    }

    public void setAffinityEstablished(boolean val) {
        this.affinityEstablished = val;
    }

    public boolean isAffinityEstablished() {
        return this.affinityEstablished;
    }

    @Override
    public boolean isOverflow() {
        return this.getISession().isOverflow();
    }
}

