/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.connector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorMessageNotSupportedException;
import com.ibm.ws.sip.connector.SipUADispatcher;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.service.sip.ConnectorUABridge;
import com.ibm.wsspi.rtcomm.service.sip.SipSigLeg;
import com.ibm.wsspi.rtcomm.service.sip.UABridge;
import com.ibm.wsspi.rtcomm.service.sip.UABridgeDirection;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={UABridge.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class ConnectorSipUaBridge
extends ConnectorUABridge {
    private static final TraceComponent tc = Tr.register(ConnectorSipUaBridge.class, (String)"rtcommGateway", (String)"com.ibm.ws.sip.connector.resource.Messages");
    private SipUADispatcher dispatcher;
    private static ConnectorSipUaBridge instance;
    static final long serialVersionUID = -6625174386407613247L;

    public static void setInstance(ConnectorSipUaBridge instance) {
        ConnectorSipUaBridge.instance = instance;
    }

    public static ConnectorSipUaBridge getInstance() {
        return instance;
    }

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"ACTIVATE", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), "properties=" + properties});
        }
        ConnectorSipUaBridge.setInstance(this);
    }

    public void setDispatcher(SipUADispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void register(RtcommEndpointDocument document, UABridgeDirection direction) {
        int expires;
        String aor = document.getEndpointID();
        String contact = document.getContact();
        int n = expires = document.getTimeout() == 0 ? -1 : document.getTimeout();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"register", (Object[])new Object[]{aor, contact, direction, expires});
        }
        if (direction != UABridgeDirection.TO_RTCOMM) {
            try {
                this.dispatcher.dispatchRegister(aor, contact, expires);
            }
            catch (ConnectorMessageNotSupportedException connectorMessageNotSupportedException) {
                void e;
                FFDCFilter.processException((Throwable)connectorMessageNotSupportedException, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"106", (Object)((Object)this), (Object[])new Object[]{document, direction});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.dispatching.sip.register", (Object[])new Object[]{aor, contact, e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"1", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"register");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void unregister(RtcommEndpointDocument document, UABridgeDirection direction) {
        String aor = document.getEndpointID();
        String contact = document.getContact();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregister", (Object[])new Object[]{aor, direction});
        }
        if (direction != UABridgeDirection.TO_RTCOMM) {
            try {
                this.dispatcher.dispatchUnregister(aor, contact);
            }
            catch (ConnectorMessageNotSupportedException connectorMessageNotSupportedException) {
                void e;
                FFDCFilter.processException((Throwable)connectorMessageNotSupportedException, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"135", (Object)((Object)this), (Object[])new Object[]{document, direction});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.dispatching.sip.register", (Object[])new Object[]{aor, e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"2", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"register");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void initiateOutboundLeg(SipSigLeg leg, UABridgeDirection direction) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initiateOutboundLeg", (Object[])new Object[]{leg, direction});
        }
        if (direction == UABridgeDirection.TO_RTCOMM) {
            this.startRtcommLeg(leg);
        } else {
            try {
                SigMessage message = leg.getInitialMessage();
                this.dispatcher.dispatchCallStart(leg, message.getProtocols(), message.getPayload(), false);
            }
            catch (ConnectorMessageNotSupportedException message) {
                void e;
                FFDCFilter.processException((Throwable)message, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"162", (Object)((Object)this), (Object[])new Object[]{leg, direction});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.initiating.sip.outbound.leg", (Object[])new Object[]{leg.getSigLegID(), e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"3", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initiateOutboundLeg");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void stopOutboundLeg(SipSigLeg leg, UABridgeDirection direction, SigMessage message, String reason) {
        if (tc.isEntryEnabled()) {
            Object[] objects = new Object[]{leg, direction, message, leg.getState()};
            Tr.entry((TraceComponent)tc, (String)"stopOutboundLeg", (Object[])objects);
        }
        SigLeg inboundLeg = (SigLeg)leg.getAttribute("legBinding");
        if (direction == UABridgeDirection.TO_RTCOMM) {
            inboundLeg.stop(reason);
        } else {
            try {
                if (inboundLeg.getState() != SigLeg.SigLegState.STOPPED && inboundLeg.getState() != SigLeg.SigLegState.FAILED) {
                    this.dispatcher.dispatchCallTerminate(leg, message);
                }
            }
            catch (ConnectorMessageNotSupportedException connectorMessageNotSupportedException) {
                void e;
                FFDCFilter.processException((Throwable)connectorMessageNotSupportedException, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"194", (Object)((Object)this), (Object[])new Object[]{leg, direction, message, reason});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.stopping.sip.outbound.leg", (Object[])new Object[]{leg.getSigLegID(), e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"3", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopOutboundLeg");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void sendIceCandidate(SipSigLeg leg, UABridgeDirection direction, SigPayload sigPayload) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendIceCandidate", (Object[])new Object[]{leg});
        }
        if (direction == UABridgeDirection.TO_RTCOMM) {
            SigLeg inboundLeg = (SigLeg)leg.getAttribute("legBinding");
            SigMessage outboundMessage = inboundLeg.createMessage(SigMessage.SigMethod.MESSAGE);
            outboundMessage.setPayload(sigPayload);
            outboundMessage.send();
        } else {
            try {
                this.dispatcher.dispatchIceCandidate(leg, sigPayload);
            }
            catch (ConnectorMessageNotSupportedException inboundLeg) {
                void e;
                FFDCFilter.processException((Throwable)inboundLeg, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"221", (Object)((Object)this), (Object[])new Object[]{leg, direction, sigPayload});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.stopping.sip.outbound.leg", (Object[])new Object[]{leg.getSigLegID(), e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"3", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendIceCandidate");
        }
    }

    @ManualTrace
    public void sendMessage(SipSigLeg leg, UABridgeDirection direction, SigPayload sigPayload) {
        SigPeerContent peerContent;
        if (tc.isEntryEnabled()) {
            Object[] objects = new Object[]{leg, direction, sigPayload};
            Tr.entry((TraceComponent)tc, (String)"sendMessage", (Object[])objects);
        }
        SigContent sigContent = null;
        if (sigPayload != null) {
            sigContent = sigPayload.get("webrtc");
        }
        if ((peerContent = (SigPeerContent)sigContent) != null && sigContent instanceof SigPeerContent) {
            if (peerContent.getType() == SigPeerContent.SigPeerContentType.offer) {
                this.sendRtcommMessageOrSipInvite(leg, direction, sigPayload);
            } else if (peerContent.getType() == SigPeerContent.SigPeerContentType.answer) {
                this.sendRtcommMessageOrSipSuccessfulResponse(leg, direction, sigPayload);
            } else if (peerContent.getType() == SigPeerContent.SigPeerContentType.icecandidate) {
                this.sendRtcommMessageOrSipInfo(leg, direction, sigPayload);
            }
        } else {
            this.sendRtcommMessageOrSipInfo(leg, direction, sigPayload);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendMessage");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void sendRtcommMessageOrSipInvite(SipSigLeg leg, UABridgeDirection direction, SigPayload sigPayload) {
        if (tc.isEntryEnabled()) {
            Object[] objects = new Object[]{leg, direction, sigPayload};
            Tr.entry((TraceComponent)tc, (String)"sendRtcommMessageOrSipInvite", (Object[])objects);
        }
        if (direction == UABridgeDirection.TO_RTCOMM) {
            this.sendRtcommMessage(leg, sigPayload);
        } else {
            try {
                this.dispatcher.dispatchCallStart(leg, null, sigPayload, true);
            }
            catch (ConnectorMessageNotSupportedException objects) {
                void e;
                FFDCFilter.processException((Throwable)objects, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"289", (Object)((Object)this), (Object[])new Object[]{leg, direction, sigPayload});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.initiating.sip.outbound.leg", (Object[])new Object[]{leg.getSigLegID(), e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"3", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRtcommMessageOrSipInvite");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void sendRtcommMessageOrSipSuccessfulResponse(SipSigLeg leg, UABridgeDirection direction, SigPayload sigPayload) {
        if (tc.isEntryEnabled()) {
            Object[] objects = new Object[]{leg, direction, sigPayload};
            Tr.entry((TraceComponent)tc, (String)"sendRtcommMessageOrSipSuccessfulResponse", (Object[])objects);
        }
        if (direction == UABridgeDirection.TO_RTCOMM) {
            this.sendRtcommMessage(leg, sigPayload);
        } else {
            try {
                this.dispatcher.dispatchSuccessfulResponse(leg, null, sigPayload, true);
            }
            catch (ConnectorMessageNotSupportedException objects) {
                void e;
                FFDCFilter.processException((Throwable)objects, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"323", (Object)((Object)this), (Object[])new Object[]{leg, direction, sigPayload});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.initiating.sip.outbound.leg", (Object[])new Object[]{leg.getSigLegID(), e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"3", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRtcommMessageOrSipSuccessfulResponse");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void sendRtcommMessageOrSipInfo(SipSigLeg leg, UABridgeDirection direction, SigPayload sigPayload) {
        if (tc.isEntryEnabled()) {
            Object[] objects = new Object[]{leg, direction, sigPayload};
            Tr.entry((TraceComponent)tc, (String)"sendRtcommMessageOrSipInfo", (Object[])objects);
        }
        if (direction == UABridgeDirection.TO_RTCOMM) {
            this.sendRtcommMessage(leg, sigPayload);
        } else {
            try {
                this.dispatcher.dispatchMessage(leg, sigPayload);
            }
            catch (ConnectorMessageNotSupportedException objects) {
                void e;
                FFDCFilter.processException((Throwable)objects, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"356", (Object)((Object)this), (Object[])new Object[]{leg, direction, sigPayload});
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"error.stopping.sip.outbound.leg", (Object[])new Object[]{leg.getSigLegID(), e.getLocalizedMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.connector.ConnectorSipUaBridge", (String)"3", (Object)((Object)this));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRtcommMessageOrSipInfo");
        }
    }

    private void sendRtcommMessage(SipSigLeg leg, SigPayload sigPayload) {
        SigLeg inboundLeg = (SigLeg)leg.getAttribute("legBinding");
        SigMessage outboundMessage = inboundLeg.createMessage(SigMessage.SigMethod.MESSAGE);
        outboundMessage.setPayload(sigPayload);
        outboundMessage.send();
    }
}

