/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorMessageNotSupportedException;
import com.ibm.ws.sip.connector.ConnectorSipUaBridge;
import com.ibm.ws.sip.connector.SipUADispatcher;
import com.ibm.ws.sip.ua.async.CallAcceptedSipAsynchForwarder;
import com.ibm.ws.sip.ua.async.CallIceCandidatedSipAsynchForwarder;
import com.ibm.ws.sip.ua.async.CallMessageSipAsynchForwarder;
import com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder;
import com.ibm.ws.sip.ua.async.CallTerminateSipAsynchForwarder;
import com.ibm.ws.sip.ua.async.SipAsyncRegisterer;
import com.ibm.wsspi.rtcomm.service.sip.SipSigLeg;
import com.ibm.wsspi.rtcomm.service.sip.UABridge;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import java.util.List;
import java.util.Map;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.SipURI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={SipUADispatcher.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class SipRTCommConnectorDispatcher
implements SipUADispatcher {
    private static final TraceComponent tc = Tr.register(SipRTCommConnectorDispatcher.class, null, null);
    private static SipSessionsUtil utils;
    private static SipFactory factory;
    private static List<SipURI> outboundinterfaces;
    static final long serialVersionUID = 5391357346211288642L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"ACTIVATE", (Object[])new Object[]{this.getClass().getSimpleName(), "properties=" + properties});
        }
    }

    public static void setSipFactory(SipFactory factory) {
        SipRTCommConnectorDispatcher.factory = factory;
    }

    public static void setUtils(SipSessionsUtil utils) {
        SipRTCommConnectorDispatcher.utils = utils;
    }

    public static List<SipURI> getOutboundinterfaces() {
        return outboundinterfaces;
    }

    public static void setOutboundinterfaces(List<SipURI> outboundinterfaces) {
        SipRTCommConnectorDispatcher.outboundinterfaces = outboundinterfaces;
    }

    public static SipSessionsUtil getUtils() {
        return utils;
    }

    public static SipFactory getSipFactory() {
        return factory;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected void setUABridge(UABridge sipUaBridge) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setUaBridge = " + sipUaBridge), (Object[])new Object[0]);
        }
        ((ConnectorSipUaBridge)sipUaBridge).setDispatcher((SipUADispatcher)this);
    }

    public void dispatchRegister(String aor, String contact, int expires) throws ConnectorMessageNotSupportedException {
        SipAsyncRegisterer registerer = SipAsyncRegisterer.createOrUpdateNewRegistry(aor, contact, expires);
        registerer.dispatch(null);
    }

    public void dispatchCallStart(SipSigLeg leg, String[] protocols, SigPayload sigPayload, boolean isReInvite) throws ConnectorMessageNotSupportedException {
        String appSessionId = null;
        appSessionId = leg.getSasID() == null ? this.createSASForOutboundSIP(leg) : leg.getSasID();
        SigMessage rtcommMessage = leg.getInitialMessage();
        CallStartSipAsynchForwarder forwarder = new CallStartSipAsynchForwarder(appSessionId, rtcommMessage, protocols, sigPayload, leg.getLocalEndpointID(), leg.getRemoteEndpointID(), isReInvite);
        forwarder.dispatch(null);
    }

    public void dispatchSuccessfulResponse(SipSigLeg leg, String[] protocols, SigPayload sigPayload, boolean isReInvite) throws ConnectorMessageNotSupportedException {
        String appSessionId = leg.getSasID();
        SigMessage rtcommMessage = leg.getInitialMessage();
        CallAcceptedSipAsynchForwarder forwarder = new CallAcceptedSipAsynchForwarder(appSessionId, (SigLeg)leg, rtcommMessage, protocols, sigPayload, leg.getLocalEndpointID(), leg.getRemoteEndpointID(), isReInvite);
        forwarder.dispatch(null);
    }

    private String createSASForOutboundSIP(SipSigLeg leg) {
        SipApplicationSession sas = factory.createApplicationSession();
        sas.setAttribute("OUTOUBND_SIG_LEG_ATTR", (Object)leg);
        leg.setSasID(sas.getId());
        return sas.getId();
    }

    public static SipSigLeg getOutboundSipSigLegFromSAS(SipApplicationSession sas) {
        return (SipSigLeg)sas.getAttribute("OUTOUBND_SIG_LEG_ATTR");
    }

    public void dispatchUnregister(String aor, String contact) throws ConnectorMessageNotSupportedException {
        SipAsyncRegisterer registerer = SipAsyncRegisterer.removeRegistry(aor, contact);
        registerer.dispatch(null);
    }

    public void dispatchUnregister(String aor) throws ConnectorMessageNotSupportedException {
    }

    public void dispatchCallTerminate(SipSigLeg leg, SigMessage message) throws ConnectorMessageNotSupportedException {
        String appSessionId = leg.getSasID();
        if (appSessionId == null) {
            throw new RuntimeException("SipSigLeg cannot have a null SAS ID");
        }
        CallTerminateSipAsynchForwarder forwarder = new CallTerminateSipAsynchForwarder(appSessionId, leg.getInitialMessage(), appSessionId, leg.getRemoteEndpointID(), leg.getLocalEndpointID(), message);
        forwarder.dispatch(null);
    }

    public void dispatchIceCandidate(SipSigLeg leg, SigPayload sigPayload) {
        String appSessionId = leg.getSasID();
        if (appSessionId == null) {
            throw new RuntimeException("SipSigLeg cannot have a null SAS ID");
        }
        CallIceCandidatedSipAsynchForwarder forwarder = new CallIceCandidatedSipAsynchForwarder(appSessionId, (SigLeg)leg, leg.getInitialMessage(), sigPayload, leg.getRemoteEndpointID(), leg.getRemoteEndpointID());
        forwarder.dispatch(null);
    }

    public void dispatchMessage(SipSigLeg leg, SigPayload sigPayload) {
        String appSessionId = leg.getSasID();
        if (appSessionId == null) {
            throw new RuntimeException("SipSigLeg cannot have a null SAS ID");
        }
        CallMessageSipAsynchForwarder forwarder = new CallMessageSipAsynchForwarder(appSessionId, (SigLeg)leg, leg.getInitialMessage(), sigPayload, leg.getRemoteEndpointID(), leg.getRemoteEndpointID());
        forwarder.dispatch(null);
    }
}

