/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorMessageNotSupportedException;
import com.ibm.ws.sip.connector.ConnectorSipUaBridge;
import com.ibm.ws.sip.ua.InboundSipSigLegListener;
import com.ibm.ws.sip.ua.SipRTCommConnectorDispatcher;
import com.ibm.ws.sip.ua.parser.BodyParser;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import com.ibm.wsspi.rtcomm.service.sip.SipSigLeg;
import com.ibm.wsspi.rtcomm.service.sip.UABridgeDirection;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.annotation.SipServlet;

@SipServlet(name="SipUAServlet")
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SipUaServlet
extends javax.servlet.sip.SipServlet {
    private static final long serialVersionUID = 6128559297332269275L;
    private static final TraceComponent tc = Tr.register(SipUaServlet.class, null, null);
    @Resource
    private transient SipFactory factory;

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
    }

    /*
     * WARNING - void declaration
     */
    protected void doInvite(SipServletRequest req) throws ServletException, IOException {
        try {
            SipSigLeg leg = this.getSipLeg((SipServletMessage)req);
            SigMessage msg = this.createInitialRTCommMsg(leg, req);
            if (leg == null) {
                this.createAndDispatchNewSipLeg(msg, req);
            } else {
                leg.addAttribute("SUBSEQUENT_SIP_MESSAGE", (Object)req);
                ConnectorSipUaBridge.getInstance().sendMessage(leg, UABridgeDirection.TO_RTCOMM, msg.getPayload());
            }
        }
        catch (ConnectorMessageNotSupportedException leg) {
            FFDCFilter.processException((Throwable)leg, (String)"com.ibm.ws.sip.ua.SipUaServlet", (String)"71", (Object)((Object)this), (Object[])new Object[]{req});
            SipServletResponse res = req.createResponse(503, req.getMethod() + " request is not supported on RTComm SIP connector");
            res.send();
        }
        catch (Exception e) {
            void e1;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.SipUaServlet", (String)"74", (Object)((Object)this), (Object[])new Object[]{req});
            SipServletResponse res = req.createResponse(503, e1.getMessage());
            res.send();
        }
    }

    protected void doProvisionalResponse(SipServletResponse resp) throws ServletException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"In doProvisionalResponse: ", (Object[])new Object[]{resp.toString()});
        }
        try {
            SipSigLeg leg = SipRTCommConnectorDispatcher.getOutboundSipSigLegFromSAS(resp.getSession().getApplicationSession());
            BodyParser parser = new BodyParser((SipServletMessage)resp, SigPeerContent.SigPeerContentType.pranswer);
            parser.parse();
            SigPayload sigPayload = parser.getPayload();
            String[] protocols = parser.getProtocols();
            leg.provisionLeg(protocols, sigPayload);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sip.ua.SipUaServlet", (String)"93", (Object)((Object)this), (Object[])new Object[]{resp});
        }
    }

    protected void doUpdate(SipServletRequest req) throws ServletException, IOException {
    }

    /*
     * WARNING - void declaration
     */
    protected void doInfo(SipServletRequest req) throws ServletException, IOException {
        SipSigLeg leg = this.getSipLeg((SipServletMessage)req);
        String infoPackageHeaderValue = req.getHeader("Info-Package");
        boolean isIceCandidate = infoPackageHeaderValue != null && infoPackageHeaderValue.equals("trickle-ice");
        BodyParser parser = isIceCandidate ? new BodyParser((SipServletMessage)req, SigPeerContent.SigPeerContentType.icecandidate) : new BodyParser((SipServletMessage)req, null);
        try {
            parser.parse();
            SigPayload sigPayload = parser.getPayload();
            if (isIceCandidate) {
                ConnectorSipUaBridge.getInstance().sendIceCandidate(leg, UABridgeDirection.TO_RTCOMM, sigPayload);
            } else {
                ConnectorSipUaBridge.getInstance().sendMessage(leg, UABridgeDirection.TO_RTCOMM, sigPayload);
            }
            req.createResponse(200).send();
        }
        catch (Exception sigPayload) {
            void e1;
            FFDCFilter.processException((Throwable)sigPayload, (String)"com.ibm.ws.sip.ua.SipUaServlet", (String)"131", (Object)((Object)this), (Object[])new Object[]{req});
            SipServletResponse res = req.createResponse(503, e1.getMessage());
            res.send();
        }
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        if (resp.getMethod().equals("INVITE")) {
            try {
                SipSigLeg leg = SipRTCommConnectorDispatcher.getOutboundSipSigLegFromSAS(resp.getSession().getApplicationSession());
                BodyParser parser = new BodyParser((SipServletMessage)resp, SigPeerContent.SigPeerContentType.answer);
                parser.parse();
                SigPayload sigPayload = parser.getPayload();
                String[] protocols = parser.getProtocols();
                if (resp.getRequest().isInitial()) {
                    leg.acceptLeg(protocols, sigPayload);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"In doSuccessResponse: ", (Object[])new Object[]{"re-INVITE, send RTcomm MESSAGE"});
                    }
                    ConnectorSipUaBridge.getInstance().sendMessage(leg, UABridgeDirection.TO_RTCOMM, sigPayload);
                }
                resp.createAck().send();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sip.ua.SipUaServlet", (String)"159", (Object)((Object)this), (Object[])new Object[]{resp});
            }
        }
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
        SipSigLeg leg = this.getSipLeg((SipServletMessage)resp);
        String reason = resp.getReasonPhrase() != null ? resp.getReasonPhrase() : String.valueOf(resp.getStatus());
        leg.rejectLeg(reason);
    }

    protected void doAck(SipServletRequest req) throws ServletException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"In doAck: ", (Object[])new Object[]{req.toString()});
        }
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        SipSigLeg leg = this.getSipLeg((SipServletMessage)req);
        ConnectorSipUaBridge.getInstance().stopOutboundLeg(leg, UABridgeDirection.TO_RTCOMM, null, "Session terminated by the callee");
        String reasonValue = req.getHeader("Reason");
        SipServletResponse response = req.createResponse(200);
        if (reasonValue != null) {
            response.setHeader("Reason", reasonValue);
        }
        response.send();
    }

    private SigMessage createInitialRTCommMsg(SipSigLeg leg, SipServletRequest req) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createInitialRTCommMsg: request = ", (Object[])new Object[]{req.toString()});
        }
        SigProvider sigProvider = ConnectorSipUaBridge.getInstance().getSigProvider();
        String destUser = req.getRequestURI().toString().split(";")[0];
        String appContext = req.getHeader("APP_CONTEXT");
        if (appContext == null) {
            appContext = "";
        }
        String documentContact = leg == null ? this.getDocumentContactFromRegistry(req, destUser, appContext) : leg.getRemoteEndpointID();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createInitialRTCommMsg: documentContact = ", (Object[])new Object[]{documentContact});
        }
        String fromEndpoint = req.getFrom().getURI().toString();
        if (req.getFrom().getDisplayName() != null) {
            fromEndpoint = req.getFrom().getDisplayName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createInitialRTCommMsg: fromEndpoint = ", (Object[])new Object[]{fromEndpoint});
        }
        String toTag = req.getTo().getParameter("tag");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"createInitialRTCommMsg: toTag = ", (Object[])new Object[]{toTag});
        }
        SigMessage sigMessage = null;
        if (toTag == null) {
            sigMessage = sigProvider.createMessage(SigMessage.SigMethod.START, SipGateway.getConnectorTopic(), destUser, fromEndpoint);
            sigMessage.setHeader("toEndpointID", sigMessage.getToEndpointID());
        } else {
            sigMessage = sigProvider.createMessage(SigMessage.SigMethod.MESSAGE, SipGateway.getConnectorTopic(), destUser, fromEndpoint);
        }
        sigMessage.setAddressTopic(documentContact);
        BodyParser parser = new BodyParser((SipServletMessage)req, SigPeerContent.SigPeerContentType.offer);
        parser.parse();
        SigPayload sigPayload = parser.getPayload();
        if (sigPayload != null) {
            sigMessage.setPayload(sigPayload);
        }
        if (toTag == null) {
            String[] protocols = parser.getProtocols();
            sigMessage.setProtocols(protocols);
        }
        return sigMessage;
    }

    private String getDocumentContactFromRegistry(SipServletRequest req, String destUser, String appContext) throws Exception {
        String documentContact = req.getRequestURI().getParameter("topic");
        if (documentContact == null) {
            this.log("No topic parameter in request URI - looking for user in the internal registry: " + destUser);
            documentContact = ConnectorSipUaBridge.getInstance().getDocumentFromRegistry(destUser, appContext);
            if (documentContact == null) {
                this.log("Document was not found for user: " + destUser);
                destUser = ((SipURI)req.getRequestURI()).getUser();
                documentContact = ConnectorSipUaBridge.getInstance().getDocumentFromRegistry(destUser, appContext);
                if (documentContact == null) {
                    this.log("Document was not found for user: " + destUser);
                    throw new Exception("User: " + destUser + " isn't registered");
                }
            }
        }
        return documentContact;
    }

    private void createAndDispatchNewSipLeg(SigMessage rtcommMsg, SipServletRequest req) throws ConnectorMessageNotSupportedException {
        SipSigLeg leg = new SipSigLeg(rtcommMsg, false);
        leg.setLocalEndpointID(rtcommMsg.getFromEndpointID());
        leg.setRemoteEndpointID(rtcommMsg.getToEndpointID());
        leg.setListener((SigLegListener)new InboundSipSigLegListener());
        leg.setSasID(req.getApplicationSession().getId());
        req.getApplicationSession().setAttribute("OUTOUBND_SIG_LEG_ATTR", (Object)leg);
        leg.addAttribute("ORIG_SIP_MESSAGE", (Object)req);
        ConnectorSipUaBridge.getInstance().initiateOutboundLeg(leg, UABridgeDirection.TO_RTCOMM);
    }

    private SipSigLeg getSipLeg(SipServletMessage msg) {
        return SipRTCommConnectorDispatcher.getOutboundSipSigLegFromSAS(msg.getApplicationSession());
    }
}

