/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorMessageNotSupportedException;
import com.ibm.ws.sip.ua.SipRTCommConnectorDispatcher;
import com.ibm.ws.sip.ua.async.SipAsynchForwarder;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CallStartSipAsynchForwarder
extends SipAsynchForwarder {
    private static final TraceComponent tc = Tr.register(CallStartSipAsynchForwarder.class, null, null);
    private final boolean m_isReInvite;
    private static final long serialVersionUID = 7105374992046660607L;

    public CallStartSipAsynchForwarder(String appSessionId, SigMessage origSigMessage, String[] protocols, SigPayload sigPayload, String destination, String source, boolean isReInvite) {
        super(appSessionId, origSigMessage, protocols, sigPayload, destination, source);
        this.m_isReInvite = isReInvite;
    }

    /*
     * WARNING - void declaration
     */
    private void generateInvite() throws ConnectorMessageNotSupportedException {
        try {
            SipApplicationSession sas = SipRTCommConnectorDispatcher.getUtils().getApplicationSessionById(this.sasid);
            SipServletRequest req = null;
            req = this.m_isReInvite ? this.createReInvite(sas) : this.createInitialInvite(sas);
            if (req != null) {
                SipURI uri = this.getPRDestination();
                if (uri != null) {
                    req.pushRoute(uri);
                }
                this.addContent((SipServletMessage)req);
                req.getSession().setHandler("SipUAServlet");
                req.send();
            }
        }
        catch (IllegalArgumentException sas) {
            void e;
            FFDCFilter.processException((Throwable)sas, (String)"com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder", (String)"93", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (ServletParseException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder", (String)"95", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder", (String)"97", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder", (String)"99", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder", (String)"101", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.CallStartSipAsynchForwarder", (String)"103", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)((Object)e));
        }
    }

    private SipServletRequest createInitialInvite(SipApplicationSession sas) throws IllegalArgumentException, ServletParseException {
        SipURI sourceInSipUri = SipRTCommConnectorDispatcher.getSipFactory().createSipURI(this.source, "localhost");
        String sourceWithDisplayName = "\"" + sourceInSipUri.getUser() + "\"<" + sourceInSipUri.toString() + ">";
        SipServletRequest req = SipRTCommConnectorDispatcher.getSipFactory().createRequest(sas, "INVITE", sourceWithDisplayName, this.destination);
        req.addHeader("APP_CONTEXT", this.origSigMessage.getAppContext());
        sas.setAttribute("initialSession", (Object)req.getSession());
        return req;
    }

    private SipServletRequest createReInvite(SipApplicationSession sas) throws ServletParseException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("create re-INVITE, sasid = " + this.sasid + " destination = " + this.destination), (Object[])new Object[0]);
        }
        SipServletRequest req = null;
        SipSession sipSession = (SipSession)sas.getAttribute("initialSession");
        if (sipSession != null) {
            req = sipSession.createRequest("INVITE");
            SipURI destInSipUri = this.destination.startsWith("sip") ? (SipURI)SipRTCommConnectorDispatcher.getSipFactory().createURI(this.destination) : SipRTCommConnectorDispatcher.getSipFactory().createSipURI(this.destination, "localhost");
            req.setRequestURI((URI)destInSipUri);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"can not send re-INVITE beofre sending the initial INVITE", (Object[])new Object[0]);
        }
        return req;
    }

    @Override
    public void doSignaling() throws ConnectorMessageNotSupportedException {
        this.generateInvite();
    }
}

