/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorMessageNotSupportedException;
import com.ibm.ws.sip.ua.SipRTCommConnectorDispatcher;
import com.ibm.ws.sip.ua.async.SipAsynchForwarder;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SipAsyncRegisterer
extends SipAsynchForwarder {
    private static final long serialVersionUID = -7405878710294128718L;
    private static final TraceComponent tc = Tr.register(SipAsyncRegisterer.class, null, null);
    private static final String REMOVING_REGISTERY_CONTACT = "*";
    private final String aor;
    private final String contact;
    private final int expires;

    public static SipAsyncRegisterer createOrUpdateNewRegistry(String aor, String contact, int expires) {
        SipApplicationSession sas = SipRTCommConnectorDispatcher.getSipFactory().createApplicationSession();
        String appSessionId = sas.getId();
        return new SipAsyncRegisterer(appSessionId, aor, contact, expires);
    }

    public static SipAsyncRegisterer removeRegistry(String aor, String contact) throws ConnectorMessageNotSupportedException {
        SipApplicationSession sas = SipRTCommConnectorDispatcher.getSipFactory().createApplicationSession();
        String appSessionId = sas.getId();
        return new SipAsyncRegisterer(appSessionId, aor, contact, 0);
    }

    public static SipAsyncRegisterer removeAllRegistryBindings(String aor) throws ConnectorMessageNotSupportedException {
        SipApplicationSession sas = SipRTCommConnectorDispatcher.getSipFactory().createApplicationSession();
        String appSessionId = sas.getId();
        return new SipAsyncRegisterer(appSessionId, aor, REMOVING_REGISTERY_CONTACT, -1);
    }

    @ManualTrace
    private SipAsyncRegisterer(String appSessionId, String aor, String contact, int expires) {
        super(appSessionId);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SipAsyncRegisterer", (Object[])new Object[]{appSessionId, aor, contact, expires});
        }
        this.aor = aor;
        this.contact = contact;
        this.expires = contact.equals(REMOVING_REGISTERY_CONTACT) ? 0 : expires;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SipAsyncRegisterer");
        }
    }

    @ManualTrace
    private SipURI constructContactFromRtcommregister(String aor, String contact) throws ConnectorMessageNotSupportedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructContactFromRtcommregister", (Object[])new Object[]{aor, contact});
        }
        String host = SipGateway.getConnectorHost();
        SipURI uri = SipRTCommConnectorDispatcher.getSipFactory().createSipURI("", host);
        int port = SipGateway.getPort();
        if (port != -1) {
            uri.setPort(port);
        }
        String user = this.getUserFromAor(aor);
        uri.setUser(user);
        uri.setParameter("topic", contact);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructContactFromRtcommregister", (Object)uri);
        }
        return uri;
    }

    @ManualTrace
    private String getUserFromAor(String aor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserFromAor", (Object[])new Object[]{aor});
        }
        String result = "rtcomm";
        int end = aor.indexOf("@");
        if (end > 0) {
            result = aor.substring(4, end);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserFromAor", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void doSignaling() throws ConnectorMessageNotSupportedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doSignaling", (Object[])new Object[0]);
        }
        try {
            SipURI uri;
            SipApplicationSession sas = SipRTCommConnectorDispatcher.getUtils().getApplicationSessionById(this.sasid);
            SipServletRequest register = SipRTCommConnectorDispatcher.getSipFactory().createRequest(sas, "REGISTER", this.aor, this.aor);
            Address ctct = null;
            if (this.contact.equals(REMOVING_REGISTERY_CONTACT)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doSignaling", (Object[])new Object[]{"unregister all contact addresses aor =" + this.aor});
                }
                ctct = SipRTCommConnectorDispatcher.getSipFactory().createAddress(REMOVING_REGISTERY_CONTACT);
            } else {
                if (this.expires == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"doSignaling", (Object[])new Object[]{"unregister contact address =" + this.contact + " of aor =" + this.aor});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doSignaling", (Object[])new Object[]{"register contact address =" + this.contact + " of aor =" + this.aor});
                }
                SipURI sipContact = this.constructContactFromRtcommregister(this.aor, this.contact);
                ctct = SipRTCommConnectorDispatcher.getSipFactory().createAddress((URI)sipContact);
            }
            register.setAddressHeader("Contact", ctct);
            if (this.expires >= 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doSignaling", (Object[])new Object[]{"setting expires =" + this.expires});
                }
                register.setHeader("Expires", String.valueOf(this.expires));
            }
            if ((uri = this.getPRDestination()) != null) {
                register.setRequestURI((URI)uri);
            }
            if (register.getRequestURI().isSipURI()) {
                ((SipURI)register.getRequestURI()).setUser("");
            }
            register.getSession().setHandler("SipRegisteringServlet");
            register.send();
        }
        catch (IllegalArgumentException sas) {
            void e;
            FFDCFilter.processException((Throwable)sas, (String)"com.ibm.ws.sip.ua.async.SipAsyncRegisterer", (String)"213", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (ServletParseException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.SipAsyncRegisterer", (String)"215", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)((Object)e));
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.SipAsyncRegisterer", (String)"217", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.SipAsyncRegisterer", (String)"219", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)e);
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.async.SipAsyncRegisterer", (String)"221", (Object)((Object)this), (Object[])new Object[0]);
            throw new ConnectorMessageNotSupportedException((Exception)((Object)e));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doSignaling");
        }
    }
}

