/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.sip.AsynchronousWork;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorMessageNotSupportedException;
import com.ibm.ws.sip.ua.MainServlet;
import com.ibm.ws.sip.ua.SipRTCommConnectorDispatcher;
import com.ibm.ws.sip.ua.utils.SipUaUtils;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class SipAsynchForwarder
extends AsynchronousWork {
    private static final long serialVersionUID = 2826053177587305364L;
    protected static final String RTCOMM_USER = "rtcomm";
    protected static final String INITIAL_SESSION = "initialSession";
    protected SigPayload sigPayload;
    protected SigPeerContent peercontent;
    protected final String sasid;
    protected String destination;
    protected String source;
    protected SigMessage origSigMessage;
    protected String[] protocols;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SipAsynchForwarder(String appSessionId, SigMessage origSigMessage, String[] protocols, SigPayload sigPayload, String destination, String source) {
        super(appSessionId);
        this.origSigMessage = origSigMessage;
        this.sasid = appSessionId;
        this.sigPayload = sigPayload;
        this.destination = destination;
        this.source = source;
        if (sigPayload != null) {
            this.peercontent = (SigPeerContent)sigPayload.get("webrtc");
        }
        this.protocols = protocols;
    }

    public SipAsynchForwarder(String appSessionId) {
        super(appSessionId);
        this.sasid = appSessionId;
    }

    public Serializable doAsyncTask() {
        try {
            this.doSignaling();
        }
        catch (ConnectorMessageNotSupportedException connectorMessageNotSupportedException) {
            FFDCFilter.processException((Throwable)connectorMessageNotSupportedException, (String)"com.ibm.ws.sip.ua.async.SipAsynchForwarder", (String)"107", (Object)((Object)this), (Object[])new Object[0]);
            return null;
        }
        return null;
    }

    protected SipSession getSipSession() {
        SipApplicationSession sas = SipRTCommConnectorDispatcher.getUtils().getApplicationSessionById(this.sasid);
        Iterator sipSessions = sas.getSessions("SIP");
        if (!sipSessions.hasNext()) {
            return null;
        }
        return (SipSession)sipSessions.next();
    }

    protected SipURI getExternalPRURI() throws ServletParseException {
        SipURI uri = SipRTCommConnectorDispatcher.getSipFactory().createSipURI(RTCOMM_USER, SipGateway.getExternalPRHost());
        uri.setPort(SipGateway.getExternalPRPort());
        return uri;
    }

    protected SipURI getInternalPRURI() {
        if (!SipGateway.isRouteToContainer()) {
            return null;
        }
        List<SipURI> list = SipRTCommConnectorDispatcher.getOutboundinterfaces();
        if (list == null) {
            MainServlet.setOutboundInterfaceAttribute();
            list = SipRTCommConnectorDispatcher.getOutboundinterfaces();
        }
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    protected SipURI getPRDestination() throws ServletParseException {
        return SipGateway.getExternalPRHost() != null ? this.getExternalPRURI() : this.getInternalPRURI();
    }

    protected abstract void doSignaling() throws ConnectorMessageNotSupportedException;

    protected void addContent(SipServletMessage sipMessage) throws IOException {
        int numberOfPayloadTypes = 0;
        int numberOfProtocols = 0;
        if (this.sigPayload != null) {
            numberOfPayloadTypes = this.sigPayload.getNumberOfPayloadTypes();
        }
        if (this.protocols != null) {
            numberOfProtocols = this.protocols.length;
        }
        if (numberOfPayloadTypes > 1 || numberOfProtocols > 1) {
            this.addMultiPartMixed(sipMessage);
        } else if (numberOfPayloadTypes == 1) {
            this.addSinglePayloadType(sipMessage);
        } else if (numberOfProtocols == 1) {
            this.setSingleProtocol(sipMessage, this.protocols[0]);
        }
    }

    private void addMultiPartMixed(SipServletMessage sipMessage) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.sigPayload != null) {
            this.addMultiPartMixedForPayloadTypes(sipMessage, sb);
        }
        if (this.protocols != null) {
            this.addMultiPartMixedForProtocols(sipMessage, sb);
        }
        sb.append("--boundary1--");
        String contentType = "multipart/mixed; boundary=\"boundary1\"";
        String bodyContent = sb.toString();
        sipMessage.setContent((Object)bodyContent, contentType);
    }

    private void addMultiPartMixedForPayloadTypes(SipServletMessage sipMessage, StringBuilder sb) throws IOException {
        Iterator it = this.sigPayload.getPayloadTypes();
        String content = "";
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(SipUaUtils.LINE_SEPARATOR);
            }
            sb.append("--boundary1").append(SipUaUtils.LINE_SEPARATOR);
            String payloadProtocol = (String)it.next();
            SigContent sigContent = this.sigPayload.get(payloadProtocol);
            if (sigContent == null) continue;
            if (sigContent instanceof SigPeerContent) {
                SigPeerContent sigPeerContent = (SigPeerContent)sigContent;
                this.addPeerContent(sipMessage, sigPeerContent, sb);
                continue;
            }
            if (sigContent.getContent() == null) continue;
            content = sigContent.getContent().toString();
            sb.append("Content-Type").append(": ").append("rtcomm/").append(payloadProtocol).append(SipUaUtils.LINE_SEPARATOR).append(SipUaUtils.LINE_SEPARATOR);
            sb.append(content);
        }
    }

    private void addPeerContent(SipServletMessage sipMessage, SigPeerContent sigPeerContent, StringBuilder sb) throws IOException {
        String content = "";
        SigPeerContent.SigPeerContentType peerContentType = sigPeerContent.getType();
        if (peerContentType == SigPeerContent.SigPeerContentType.offer || peerContentType == SigPeerContent.SigPeerContentType.answer || peerContentType == SigPeerContent.SigPeerContentType.pranswer) {
            content = sigPeerContent.getRawCandidate().toString();
            sb.append("Content-Type").append(": ").append("application/sdp").append(SipUaUtils.LINE_SEPARATOR).append(SipUaUtils.LINE_SEPARATOR);
        } else if (peerContentType == SigPeerContent.SigPeerContentType.icecandidate) {
            content = sigPeerContent.getRawCandidate().toString();
            sb.append("Content-Type").append(": ").append("application/json").append(SipUaUtils.LINE_SEPARATOR).append(SipUaUtils.LINE_SEPARATOR);
        }
        sb.append(content);
    }

    private void addMultiPartMixedForProtocols(SipServletMessage sipMessage, StringBuilder sb) {
        for (int i = 0; i < this.protocols.length; ++i) {
            String protocol = this.protocols[i];
            if (this.sigPayload == null) {
                this.addBoundaryWithEmptyBody(protocol, sb);
                continue;
            }
            SigContent sigContent = this.sigPayload.get(protocol);
            if (sigContent != null) continue;
            this.addBoundaryWithEmptyBody(protocol, sb);
        }
        if (sb.length() > 0) {
            sb.append(SipUaUtils.LINE_SEPARATOR);
        }
    }

    private void addBoundaryWithEmptyBody(String protocol, StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(SipUaUtils.LINE_SEPARATOR);
        }
        sb.append("--boundary1").append(SipUaUtils.LINE_SEPARATOR);
        sb.append("Content-Type").append(": ");
        if (protocol.equals("webrtc")) {
            sb.append("application/sdp");
        } else {
            sb.append("rtcomm/").append(protocol);
        }
        sb.append(SipUaUtils.LINE_SEPARATOR);
    }

    private void addSinglePayloadType(SipServletMessage sipMessage) throws IOException {
        if (this.peercontent != null) {
            this.addPeerContent(sipMessage, this.peercontent);
        } else {
            Iterator it = this.sigPayload.getPayloadTypes();
            String payloadProtocol = (String)it.next();
            SigContent sigContent = this.sigPayload.get(payloadProtocol);
            if (sigContent != null && sigContent.getContent() != null) {
                sipMessage.setContent((Object)sigContent.getContent().toString(), "rtcomm/" + payloadProtocol);
            }
        }
    }

    private void addPeerContent(SipServletMessage sipMessage, SigPeerContent sigPeerContent) throws IOException {
        SigPeerContent.SigPeerContentType peerContentType = sigPeerContent.getType();
        if (peerContentType == SigPeerContent.SigPeerContentType.offer || peerContentType == SigPeerContent.SigPeerContentType.answer || peerContentType == SigPeerContent.SigPeerContentType.pranswer) {
            sipMessage.setContent((Object)sigPeerContent.getRawSDP(), "application/sdp");
        } else if (peerContentType == SigPeerContent.SigPeerContentType.icecandidate) {
            String content = sigPeerContent.getRawCandidate().toString();
            sipMessage.setContent((Object)content, "application/json");
        }
    }

    private void setSingleProtocol(SipServletMessage sipMessage, String protocol) {
        if (protocol.equals("webrtc")) {
            sipMessage.setContentType("application/sdp");
        } else {
            sipMessage.setContentType("rtcomm/" + this.protocols[0]);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SipAsynchForwarder.class, null, null);
    }
}

