/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua.parser;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorSipUaBridge;
import com.ibm.ws.sip.ua.parser.MultipartMixerParser;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletMessage;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BodyParser {
    private static final TraceComponent tc = Tr.register(BodyParser.class, null, null);
    private final SipServletMessage m_message;
    private final SigPeerContent.SigPeerContentType m_peerContentType;
    private SigPayload m_sigPayload = null;
    private String[] m_protocols = null;
    static final long serialVersionUID = -6668744007180607079L;

    public BodyParser(SipServletMessage message, SigPeerContent.SigPeerContentType peerContentType) {
        this.m_message = message;
        this.m_peerContentType = peerContentType;
    }

    public void parse() throws Exception {
        String contentType = this.m_message.getContentType();
        if (contentType == null) {
            return;
        }
        String contentTypeLowerCase = contentType.toLowerCase();
        if (contentTypeLowerCase.startsWith("multipart/mixed")) {
            MultipartMixerParser multipartMixerParser = new MultipartMixerParser(this.m_message.getContentType(), this.m_message.getContent(), this.m_peerContentType);
            multipartMixerParser.parse();
            this.m_sigPayload = multipartMixerParser.getPayload();
            this.m_protocols = multipartMixerParser.getBoundariesProtocols();
        } else if (contentTypeLowerCase.equals("application/sdp") || contentTypeLowerCase.equals("application/json")) {
            if (this.m_peerContentType != null) {
                this.m_sigPayload = this.createWebRTCPayload(this.m_message.getContent(), this.m_peerContentType);
            }
            String[] protocols = new String[]{"webrtc"};
            this.m_protocols = protocols;
        } else if (contentTypeLowerCase.startsWith("rtcomm/")) {
            contentType = contentType.split("rtcomm/")[1];
            this.m_sigPayload = this.createNonWebRTCPayload(contentType, this.m_message.getContent());
            String[] protocols = new String[]{contentType};
            this.m_protocols = protocols;
        } else {
            this.notSupportedContentType(contentType);
        }
    }

    public SigPayload getPayload() {
        return this.m_sigPayload;
    }

    public String[] getProtocols() {
        String[] protocols = this.m_protocols;
        return protocols;
    }

    private void notSupportedContentType(String contentType) throws Exception {
        String notSupported = "Content-Type: " + contentType + " is not supported";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)notSupported, (Object[])new Object[0]);
        }
        throw new Exception(notSupported);
    }

    private SigPayload createWebRTCPayload(Object content, SigPeerContent.SigPeerContentType peerContentType) {
        SigPayload sigPayload = null;
        SigPeerContent sigPeerContent = this.createSigContentFromSDP(content, peerContentType);
        if (sigPeerContent != null) {
            sigPayload = ConnectorSipUaBridge.getInstance().createPayload();
            sigPayload.add("webrtc", (SigContent)sigPeerContent);
        }
        return sigPayload;
    }

    /*
     * WARNING - void declaration
     */
    private SigPeerContent createSigContentFromSDP(Object content, SigPeerContent.SigPeerContentType type) {
        if (content == null) {
            return null;
        }
        SigProvider sigProvider = ConnectorSipUaBridge.getInstance().getSigProvider();
        SigPeerContent peerContent = sigProvider.createPeerContent(type);
        try {
            byte[] contentBytes = (byte[])content;
            String contentStr = new String(contentBytes, "UTF-8");
            if (type.equals((Object)SigPeerContent.SigPeerContentType.icecandidate)) {
                JSONObject contentObj = (JSONObject)JSON.parse((String)contentStr);
                peerContent.setRawCandidate(contentObj);
            } else {
                peerContent.setRawSDP(contentStr);
            }
        }
        catch (NullPointerException contentBytes) {
            void e;
            FFDCFilter.processException((Throwable)contentBytes, (String)"com.ibm.ws.sip.ua.parser.BodyParser", (String)"184", (Object)this, (Object[])new Object[]{content, type});
            if (tc.isErrorEnabled()) {
                // empty if block
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua", (String)"1", (Object)this);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.parser.BodyParser", (String)"189", (Object)this, (Object[])new Object[]{content, type});
            if (tc.isErrorEnabled()) {
                // empty if block
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua", (String)"1", (Object)this);
        }
        return peerContent;
    }

    private SigPayload createNonWebRTCPayload(String payloadType, Object content) throws ServletException, IOException {
        SigPayload sigPayload = null;
        SigContent sigContent = this.createSigContentFromBody(content);
        if (sigContent != null) {
            sigPayload = ConnectorSipUaBridge.getInstance().createPayload();
            sigPayload.add(payloadType, sigContent);
        }
        return sigPayload;
    }

    private SigContent createSigContentFromBody(Object bodyContent) throws ServletException, IOException {
        if (bodyContent == null) {
            return null;
        }
        byte[] contentBytes = (byte[])bodyContent;
        String contentStr = new String(contentBytes, "UTF-8");
        JSONObject contentJSON = (JSONObject)JSON.parse((String)contentStr);
        SigProvider sigProvider = ConnectorSipUaBridge.getInstance().getSigProvider();
        SigContent sigContent = sigProvider.createContent(contentJSON);
        return sigContent;
    }
}

