/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua.parser;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorSipUaBridge;
import com.ibm.ws.sip.ua.parser.BodyWrapper;
import com.ibm.ws.sip.ua.utils.SipUaUtils;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BoundaryParser {
    private static final String EMPTY_STRING = "";
    private final BodyWrapper m_bodyWrapper;
    private final String m_boundaryName;
    private String m_boundaryBody;
    private final String m_closingBoundary;
    private final SigPeerContent.SigPeerContentType m_sigPeerContentType;
    private String m_protocol;
    static final long serialVersionUID = -5247071486105046188L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BoundaryParser(BodyWrapper bodyWrapper, String boundaryName, String closingBoundary, SigPeerContent.SigPeerContentType sigPeerContentType) {
        this.m_bodyWrapper = bodyWrapper;
        this.m_boundaryName = boundaryName;
        this.m_closingBoundary = closingBoundary;
        this.m_sigPeerContentType = sigPeerContentType;
        this.m_boundaryBody = null;
        this.m_protocol = null;
    }

    public boolean findProtocol() {
        String line;
        while (this.m_bodyWrapper.hasNext() && !(line = this.m_bodyWrapper.next()).equals(EMPTY_STRING)) {
            if (!line.toLowerCase().startsWith("Content-Type".toLowerCase())) continue;
            String[] headerParts = line.split(":");
            String headerValue = headerParts[1].trim();
            if (headerValue.equalsIgnoreCase("application/sdp") || headerValue.equalsIgnoreCase("application/json")) {
                this.m_protocol = "webrtc";
                continue;
            }
            if (!headerValue.startsWith("rtcomm/")) continue;
            this.m_protocol = headerValue.split("rtcomm/")[1];
        }
        return this.m_protocol != null;
    }

    private void createBody() {
        this.m_boundaryBody = EMPTY_STRING;
        while (this.m_bodyWrapper.hasNext() && !this.m_bodyWrapper.peek().equals(this.m_boundaryName) && !this.m_bodyWrapper.peek().equals(this.m_closingBoundary)) {
            String line = this.m_bodyWrapper.next();
            this.m_boundaryBody = this.m_boundaryBody + line + SipUaUtils.LINE_SEPARATOR;
        }
    }

    public SigContent createSigContent() throws IOException {
        Object sigContent = null;
        if (this.m_boundaryBody == null) {
            this.createBody();
        }
        if (this.m_protocol == null) {
            return null;
        }
        sigContent = this.m_protocol.equals("webrtc") ? (this.m_sigPeerContentType != null ? this.createSigContentFromSDP(this.m_boundaryBody, this.m_sigPeerContentType) : this.createSigContentFromBody(this.m_protocol, this.m_boundaryBody)) : this.createSigContentFromBody(this.m_protocol, this.m_boundaryBody);
        return sigContent;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    /*
     * WARNING - void declaration
     */
    private SigPeerContent createSigContentFromSDP(String contentStr, SigPeerContent.SigPeerContentType type) {
        if (contentStr == null || contentStr.equals(EMPTY_STRING)) {
            return null;
        }
        SigProvider sigProvider = ConnectorSipUaBridge.getInstance().getSigProvider();
        SigPeerContent peerContent = sigProvider.createPeerContent(type);
        try {
            if (type.equals((Object)SigPeerContent.SigPeerContentType.icecandidate)) {
                JSONObject contentObj = (JSONObject)JSON.parse((String)contentStr);
                peerContent.setRawCandidate(contentObj);
            } else {
                peerContent.setRawSDP(contentStr);
            }
        }
        catch (NullPointerException contentObj) {
            void e;
            FFDCFilter.processException((Throwable)contentObj, (String)"com.ibm.ws.sip.ua.parser.BoundaryParser", (String)"187", (Object)this, (Object[])new Object[]{contentStr, type});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua", (String)"1", (Object)this);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua.parser.BoundaryParser", (String)"189", (Object)this, (Object[])new Object[]{contentStr, type});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sip.ua", (String)"1", (Object)this);
        }
        return peerContent;
    }

    private SigContent createSigContentFromBody(String protocol, String contentStr) throws IOException {
        if (contentStr == null || contentStr.equals(EMPTY_STRING)) {
            return null;
        }
        JSONObject contentJSON = JSONObject.parse((String)contentStr);
        SigProvider sigProvider = ConnectorSipUaBridge.getInstance().getSigProvider();
        SigContent sigContent = sigProvider.createContent(contentJSON);
        return sigContent;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BoundaryParser.class, null, null);
    }
}

