/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ua.parser;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.connector.ConnectorSipUaBridge;
import com.ibm.ws.sip.ua.parser.BodyWrapper;
import com.ibm.ws.sip.ua.parser.BoundaryParser;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MultipartMixerParser {
    private final BodyWrapper m_bodyWrapper;
    private final String m_boundaryName;
    private final String m_closingBoundary;
    private final SigPeerContent.SigPeerContentType m_sigPeerContentType;
    private final List<BoundaryParser> m_boundaryParsers;
    private SigPayload m_payload;
    static final long serialVersionUID = 826483293796331660L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MultipartMixerParser(String contentTypeLine, Object content, SigPeerContent.SigPeerContentType type) throws UnsupportedEncodingException {
        this.m_boundaryName = MultipartMixerParser.getBoundaryName(contentTypeLine);
        this.m_closingBoundary = this.m_boundaryName + "--";
        this.m_bodyWrapper = new BodyWrapper(content);
        this.m_sigPeerContentType = type;
        this.m_boundaryParsers = new ArrayList<BoundaryParser>();
    }

    public void parse() throws IOException {
        String line = null;
        SigPayload sigPayload = ConnectorSipUaBridge.getInstance().createPayload();
        this.m_bodyWrapper.init();
        this.skipPreamble();
        while (this.m_bodyWrapper.hasNext()) {
            line = this.m_bodyWrapper.next();
            if (line.equals(this.m_boundaryName)) {
                BoundaryParser boundaryParser = new BoundaryParser(this.m_bodyWrapper, this.m_boundaryName, this.m_closingBoundary, this.m_sigPeerContentType);
                if (!boundaryParser.findProtocol()) continue;
                this.m_boundaryParsers.add(boundaryParser);
                SigContent sigContent = boundaryParser.createSigContent();
                if (sigContent == null) continue;
                sigPayload.add(boundaryParser.getProtocol(), sigContent);
                continue;
            }
            if (!line.equals(this.m_closingBoundary)) continue;
        }
        this.m_payload = sigPayload;
        if (sigPayload.getNumberOfPayloadTypes() == 0) {
            this.m_payload = null;
        }
    }

    public SigPayload getPayload() {
        return this.m_payload;
    }

    public String[] getBoundariesProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        for (BoundaryParser bodyParser : this.m_boundaryParsers) {
            protocols.add(bodyParser.getProtocol());
        }
        return protocols.toArray(new String[protocols.size()]);
    }

    private static String getBoundaryName(String contentType) {
        String boundaryPart = contentType.split(";")[1];
        String boundaryName = boundaryPart.split("=")[1];
        boundaryName = boundaryName.trim();
        boundaryName = boundaryName.substring(1, boundaryName.length() - 1);
        boundaryName = "--" + boundaryName;
        return boundaryName;
    }

    private void skipPreamble() {
        boolean firstBoundaryFound = false;
        while (this.m_bodyWrapper.hasNext() && !firstBoundaryFound) {
            String line = this.m_bodyWrapper.peek();
            if (line.equals(this.m_boundaryName)) {
                firstBoundaryFound = true;
                continue;
            }
            this.m_bodyWrapper.next();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MultipartMixerParser.class, null, null);
    }
}

