/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.monitor.pmi.basic;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.container.pmi.listener.SipContainerPMIListener;
import com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters;
import com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule;
import com.ibm.ws.sip.monitor.pmi.taskduration.TaskDurationModule;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="s_logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class SipContainerModule
implements SipContainerPMIListener {
    private static final Logger s_logger = Logger.getLogger(SipContainerModule.class.getName());
    private TaskDurationModule _taskDurationModule;
    public static final String BUNDLE_NAME = "com.ibm.ws.sip.monitor.resources.Messages";
    static final long serialVersionUID = -6558792522185257658L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SipContainerModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "<init>", new Object[0]);
        }
        this._taskDurationModule = null;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(Map<String, Object> componentConfig) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "activate", new Object[]{componentConfig});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "SipContainerModule activated", componentConfig);
        }
        this._taskDurationModule = new TaskDurationModule();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Modified
    protected void modified(Map<String, Object> properties) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "modified", new Object[]{properties});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "modified");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate(int reason) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "deactivate", new Object[]{reason});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateAppSessionNum(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateAppSessionNum", new Object[]{num});
        }
        SipContainerBasicCounters.getInstance().setSipAppSessions(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateAppSessionNum");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateSipSessionNum(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateSipSessionNum", new Object[]{num});
        }
        SipContainerBasicCounters.getInstance().setSipSessions(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateSipSessionNum");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateInvokeCounter(long size) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateInvokeCounter", new Object[]{size});
        }
        SipContainerBasicCounters.getInstance().setInvokerSize(size);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateInvokeCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateReceivedMsgs(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateReceivedMsgs", new Object[]{num});
        }
        SipContainerBasicCounters.getInstance().setReceivedSipMsgs(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateReceivedMsgs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateNewSipAppCreated(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateNewSipAppCreated", new Object[]{num});
        }
        SipContainerBasicCounters.getInstance().setNewSipApplications(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateNewSipAppCreated");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updatedProcessingRequest(long ms) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updatedProcessingRequest", new Object[]{ms});
        }
        SipContainerBasicCounters.getInstance().setRequestProcessing(ms);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updatedProcessingRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateReplicatedSipSessionsCounter(long replicatedSessions) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateReplicatedSipSessionsCounter", new Object[]{replicatedSessions});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateReplicatedSipSessionsCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateNotReplicatedSipSessionsCounter(long notReplicatedSessions) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateNotReplicatedSipSessionsCounter", new Object[]{notReplicatedSessions});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateNotReplicatedSipSessionsCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateReplicatedSipAppSessionsCounter(long replicatedAppSessions) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateReplicatedSipAppSessionsCounter", new Object[]{replicatedAppSessions});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateReplicatedSipAppSessionsCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateNotReplicatedSipAppSessionsCounter(long notReplicatedAppSessions) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateNotReplicatedSipAppSessionsCounter", new Object[]{notReplicatedAppSessions});
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateNotReplicatedSipAppSessionsCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateTaskDurationProcessingQueueStatistics(long ms) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateTaskDurationProcessingQueueStatistics", new Object[]{ms});
        }
        if (this._taskDurationModule != null) {
            this._taskDurationModule.updateTaskDurationProcessingQueueStatistics(ms);
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateTaskDurationProcessingQueueStatistics");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateTaskDurationOutboundQueueStatistics(long ms) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateTaskDurationOutboundQueueStatistics", new Object[]{ms});
        }
        if (this._taskDurationModule != null) {
            this._taskDurationModule.updateTaskDurationOutboundQueueStatistics(ms);
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateTaskDurationOutboundQueueStatistics");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateTaskDurationPMICounters() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateTaskDurationPMICounters", new Object[0]);
        }
        if (this._taskDurationModule != null) {
            this._taskDurationModule.updatePMICounters();
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateTaskDurationPMICounters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TaskDurationModule getTaskDurationModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "getTaskDurationModule", new Object[0]);
        }
        TaskDurationModule taskDurationModule = this._taskDurationModule;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            taskDurationModule = taskDurationModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "getTaskDurationModule", taskDurationModule);
        }
        return taskDurationModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateQueueMonitoringTaskQueuedInProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskQueuedInProcessingQueue", new Object[0]);
        }
        QueueMonitoringModule.getInstance().updateQueueMonitoringTaskQueuedInProcessingQueue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskQueuedInProcessingQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateQueueMonitoringTaskDequeuedFromProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskDequeuedFromProcessingQueue", new Object[0]);
        }
        QueueMonitoringModule.getInstance().updateQueueMonitoringTaskDequeuedFromProcessingQueue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskDequeuedFromProcessingQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateQueueMonitoringTaskQueuedInOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskQueuedInOutboundQueue", new Object[0]);
        }
        QueueMonitoringModule.getInstance().updateQueueMonitoringTaskQueuedInOutboundQueue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskQueuedInOutboundQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateQueueMonitoringTaskDequeuedFromOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskDequeuedFromOutboundQueue", new Object[0]);
        }
        QueueMonitoringModule.getInstance().updateQueueMonitoringTaskDequeuedFromOutboundQueue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringTaskDequeuedFromOutboundQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateQueueMonitoringPMICounters() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringPMICounters", new Object[0]);
        }
        QueueMonitoringModule.getInstance().updateQueueMonitoringPMICounters();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateQueueMonitoringPMICounters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateRejectedMessagesCounter(long rejectedMessages) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateRejectedMessagesCounter", new Object[]{rejectedMessages});
        }
        SipContainerBasicCounters.getInstance().setRejectedSipMessages(rejectedMessages);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateRejectedMessagesCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateSipTimersInvocationsCounter(long timersInvocations) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateSipTimersInvocationsCounter", new Object[]{timersInvocations});
        }
        SipContainerBasicCounters.getInstance().setSipTimersInvocations(timersInvocations);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "updateSipTimersInvocationsCounter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isTraditionalPMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isTraditionalPMIEnabled", new Object[0]);
        }
        boolean bl = !PmiRegistry.isDisabled();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isTraditionalPMIEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isProcessingQueuePMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isProcessingQueuePMIEnabled", new Object[0]);
        }
        boolean bl = this._taskDurationModule.isProcessingQueuePMIEnabled();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isProcessingQueuePMIEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isTaskDurationOutboundQueuePMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isTaskDurationOutboundQueuePMIEnabled", new Object[0]);
        }
        boolean bl = this._taskDurationModule.isOutboundQueuePMIEnabled();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isTaskDurationOutboundQueuePMIEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isQueueMonitoringProcessingQueuePMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isQueueMonitoringProcessingQueuePMIEnabled", new Object[0]);
        }
        boolean bl = false;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isQueueMonitoringProcessingQueuePMIEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isQueueMonitoringOutboundQueuePMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isQueueMonitoringOutboundQueuePMIEnabled", new Object[0]);
        }
        boolean bl = false;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerModule", "isQueueMonitoringOutboundQueuePMIEnabled", bl);
        }
        return bl;
    }
}

