/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sip.util.seqlog;

import com.ibm.sip.util.seqlog.BasicInfoLogEvent;
import com.ibm.sip.util.seqlog.ExtendePrimitiveLogEvent;
import com.ibm.sip.util.seqlog.ExtendedInfoLogEvent;
import com.ibm.sip.util.seqlog.LogEvent;
import com.ibm.sip.util.seqlog.PrimitiveLogEvent;
import java.util.Vector;

public abstract class SequenceLogger {
    private Vector _log = new Vector();
    private Object _id;
    protected int _severity;
    protected static int c_logThreshold = 65536;
    protected static boolean c_dumpCompleteLogsOnly = false;

    public void setId(Object id) {
        this._id = id;
    }

    public void log(int state, Object info, Object extendedInfo) {
        ExtendedInfoLogEvent logE = (ExtendedInfoLogEvent)ExtendedInfoLogEvent.getInstance();
        logE.update(state, info, extendedInfo);
        this.addToLog(logE);
    }

    public void log(int state, int info, Object extendedInfo) {
        ExtendePrimitiveLogEvent logE = (ExtendePrimitiveLogEvent)ExtendePrimitiveLogEvent.getInstance();
        logE.update(state, info, extendedInfo);
        this.addToLog(logE);
    }

    public void log(int state, Object info) {
        BasicInfoLogEvent logE = (BasicInfoLogEvent)BasicInfoLogEvent.getInstance();
        logE.update(state, info);
        this.addToLog(logE);
    }

    public void log(int state) {
        LogEvent logE = LogEvent.getInstance();
        logE.update(state);
        this.addToLog(logE);
    }

    public void log(int state, int info) {
        PrimitiveLogEvent logE = (PrimitiveLogEvent)PrimitiveLogEvent.getInstance();
        logE.update(state, info);
        this.addToLog(logE);
    }

    public void log(int state, boolean info) {
        PrimitiveLogEvent logE = (PrimitiveLogEvent)PrimitiveLogEvent.getInstance();
        logE.update(state, info);
        this.addToLog(logE);
    }

    private void addToLog(LogEvent logE) {
        this._log.add(logE);
        this._severity |= logE._state & 0x111100;
        this.dumpIfNeeded();
    }

    public void clear() {
        for (int i = 0; i < this._log.size(); ++i) {
            ((LogEvent)this._log.elementAt(i)).returnToPool();
        }
        this._log.clear();
        this._id = null;
        this._severity = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.dump(buf);
        return buf.toString();
    }

    public void dump(StringBuffer buf) {
        buf.append("\n$$$\t");
        buf.append(SequenceLogger.getDesc());
        buf.append('\t');
        if (this._id != null) {
            buf.append("id: ");
            buf.append(this._id);
            buf.append('\n');
            buf.append("Severity: ");
            LogEvent.dumpLevelAsString(buf, this._severity);
            buf.append('\n');
            buf.append("Log length: ");
            buf.append(this._log.size());
            buf.append('\t');
            buf.append("is complete: ");
            buf.append((this._severity & 0x1000) == 4096 ? "true" : "false");
            buf.append("\n\n");
        }
        for (int i = 0; i < this._log.size(); ++i) {
            buf.append('(');
            buf.append(i);
            buf.append(") ");
            ((LogEvent)this._log.elementAt(i)).dump(buf, this);
            buf.append('\n');
        }
        buf.append("\t~~~\n");
    }

    public void dumpStateDesc(int state, StringBuffer buf) {
        buf.append(state);
    }

    protected void dumpIfNeeded() {
        if (c_dumpCompleteLogsOnly && (this._severity & 0x1000) != 4096) {
            return;
        }
        if (this._severity >= c_logThreshold) {
            StringBuffer buf = new StringBuffer();
            this.dump(buf);
            System.out.println(buf.toString());
        }
    }

    protected static String getDesc() {
        return "Sequence Logger";
    }
}

