/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.SipStackImpl;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionsModel;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTranaction;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipEvent;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipListener;
import jain.protocol.ip.sip.SipListenerAlreadyRegisteredException;
import jain.protocol.ip.sip.SipListenerNotRegisteredException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.SipStack;
import jain.protocol.ip.sip.TransactionDoesNotExistException;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.RecordRouteHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TooManyListenersException;

public class SipProviderImpl
implements SipProvider {
    private static final LogMgr c_logger = Log.get(SipProviderImpl.class);
    private List m_listenersList;
    private ListeningPoint m_listeningPoint;
    private SipStackImpl m_stack;
    private SIPTransactionStack m_transactionStack;
    private boolean m_isRunning;

    SipProviderImpl() {
        this.init();
    }

    private void init() {
        this.m_listenersList = new ArrayList(16);
        this.m_isRunning = true;
    }

    void start() {
        this.m_isRunning = true;
    }

    void stop() {
        this.m_isRunning = false;
    }

    @Override
    public ListeningPoint getListeningPoint() {
        return this.m_listeningPoint;
    }

    public void setListeningPoint(ListeningPoint lp) {
        this.m_listeningPoint = lp;
    }

    @Override
    public CallIdHeader getNewCallIdHeader() throws SipException {
        String cid = SIPStackUtil.generateCallIdentifier(this.m_listeningPoint.getCallIdValue());
        return SipJainFactories.getInstance().getHeaderFactory().createCallIdHeader(cid);
    }

    @Override
    public SipStack getSipStack() {
        return this.m_stack;
    }

    public void setSipStack(SipStackImpl stack) {
        this.m_stack = stack;
        this.m_transactionStack = stack.getTransactionStack();
    }

    @Override
    public Request getTransactionRequest(long transactionId, boolean isServerTransaction) throws TransactionDoesNotExistException {
        SIPTransaction transaction = this.getTransaction(transactionId, isServerTransaction);
        return (Request)transaction.getFirstRequest().clone();
    }

    @Override
    public Response getTransactionResponse(long transactionId, boolean isServerTransaction) throws TransactionDoesNotExistException {
        SIPTransaction transaction = this.getTransaction(transactionId, isServerTransaction);
        return (Response)transaction.getMostRecentResponse().clone();
    }

    private SIPTransaction getTransaction(long transactionId, boolean isServerTransaction) throws TransactionDoesNotExistException {
        if (isServerTransaction) {
            return SIPTransactionsModel.instance().getServerTransaction(transactionId);
        }
        return SIPTransactionsModel.instance().getClientTransaction(transactionId);
    }

    @Override
    public synchronized void addSipListener(SipListener sipListener) throws IllegalArgumentException, TooManyListenersException, SipListenerAlreadyRegisteredException {
        List temp = (List)((ArrayList)this.m_listenersList).clone();
        temp.add(sipListener);
        this.m_listenersList = temp;
    }

    @Override
    public synchronized void removeSipListener(SipListener sipListener) throws SipListenerNotRegisteredException {
        if (sipListener == null) {
            throw new IllegalArgumentException("SipListener cannot be null");
        }
        List temp = (List)((ArrayList)this.m_listenersList).clone();
        boolean hadListener = temp.remove(sipListener);
        this.m_listenersList = temp;
        if (!hadListener) {
            throw new SipListenerNotRegisteredException();
        }
    }

    @Override
    public long sendAck(long clientTransactionId, byte[] body, String bodyType, String bodySubType) throws IllegalArgumentException, TransactionDoesNotExistException, SipParseException, SipException {
        ContactHeader contact;
        Request ackReq = null;
        SIPClientTranaction transaction = (SIPClientTranaction)this.getTransaction(clientTransactionId, false);
        Response res = transaction.getFinalResponse();
        Request req = transaction.getFirstRequest();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendAck", "The response was:\n" + res.toString());
        }
        String method = "ACK";
        CallIdHeader callHeader = req.getCallIdHeader();
        CSeqHeader cseq = req.getCSeqHeader();
        cseq.setMethod(method);
        FromHeader from = res.getFromHeader();
        ToHeader to = res.getToHeader();
        List viaList = SIPStackUtil.headerIteratorToList(req.getViaHeaders());
        ArrayList<RouteHeader> routeHeaders = new ArrayList<RouteHeader>(16);
        if (res.getRecordRouteHeaders() != null && res.getRecordRouteHeaders().hasNext()) {
            HeaderIterator iter = res.getRecordRouteHeaders();
            while (iter.hasNext()) {
                RecordRouteHeader recordRoute = (RecordRouteHeader)iter.next();
                RouteHeader route = SipJainFactories.getInstance().getHeaderFactory().createRouteHeader(recordRoute.getNameAddress());
                routeHeaders.add(route);
            }
            Collections.reverse(routeHeaders);
        }
        if ((contact = (ContactHeader)res.getHeader("Contact", true)) == null) {
            throw new SipException("Answer to Invite Must have a contact headear!!!");
        }
        URI reqUril = contact.getNameAddress().getAddress();
        ContentTypeHeader contentHeader = null;
        if (bodyType != null && bodySubType != null) {
            contentHeader = SipJainFactories.getInstance().getHeaderFactory().createContentTypeHeader(bodyType, bodySubType);
            ackReq = SipJainFactories.getInstance().getMesssageFactory().createRequest(reqUril, method, callHeader, cseq, from, to, viaList, body, contentHeader);
        } else {
            ackReq = SipJainFactories.getInstance().getMesssageFactory().createRequest(reqUril, method, callHeader, cseq, from, to, viaList);
        }
        if (routeHeaders.size() > 0) {
            ackReq.setRouteHeaders(routeHeaders);
        }
        this.setRequestBasicParameters(ackReq);
        this.m_transactionStack.prossesUASipRequest(ackReq, this, -1L);
        return clientTransactionId;
    }

    public long sendAck(long clientTransactionId, Request req) throws IllegalArgumentException, TransactionDoesNotExistException, SipParseException, SipException {
        this.setRequestBasicParameters(req);
        return this.m_transactionStack.prossesUASipACKRequest(clientTransactionId, req);
    }

    @Override
    public long sendAck(long clientTransactionId, String body, String bodyType, String bodySubType) throws IllegalArgumentException, TransactionDoesNotExistException, SipParseException, SipException {
        return this.sendAck(clientTransactionId, body.getBytes(), bodyType, bodySubType);
    }

    @Override
    public long sendAck(long clientTransactionId) throws TransactionDoesNotExistException, SipException {
        return this.sendAck(clientTransactionId, "", null, null);
    }

    @Override
    public long sendBye(long transactionId, boolean isServerTransaction) throws TransactionDoesNotExistException, SipException {
        Request byeReq = null;
        SIPTransaction transaction = this.getTransaction(transactionId, isServerTransaction);
        Response res = transaction.getMostRecentResponse();
        Request req = transaction.getFirstRequest();
        ToHeader to = res.getToHeader();
        if (to.getTag() == null || "".equals(to.getTag())) {
            throw new SipException("No dilaog found for the transaction,the breanch of the To header is not set!!!");
        }
        String method = "BYE";
        URI reqUril = (URI)req.getRequestURI().clone();
        CallIdHeader callHeader = (CallIdHeader)req.getCallIdHeader().clone();
        CSeqHeader cseq = (CSeqHeader)req.getCSeqHeader().clone();
        cseq.setMethod(method);
        long newCseq = cseq.getSequenceNumber() + 1L;
        cseq.setSequenceNumber(newCseq);
        FromHeader from = (FromHeader)res.getFromHeader().clone();
        List viaList = SIPStackUtil.headerIteratorToList(req.getViaHeaders());
        ArrayList<RouteHeader> routeHeaders = new ArrayList<RouteHeader>(16);
        if (res.getRecordRouteHeaders() != null && res.getRecordRouteHeaders().hasNext()) {
            HeaderIterator iter = res.getRecordRouteHeaders();
            while (iter.hasNext()) {
                RecordRouteHeader recordRoute = (RecordRouteHeader)iter.next();
                RouteHeader route = SipJainFactories.getInstance().getHeaderFactory().createRouteHeader(recordRoute.getNameAddress());
                routeHeaders.add(route);
            }
            Collections.reverse(routeHeaders);
        }
        byeReq = SipJainFactories.getInstance().getMesssageFactory().createRequest(reqUril, method, callHeader, cseq, from, to, viaList);
        if (routeHeaders.size() > 0) {
            byeReq.setRouteHeaders(routeHeaders);
        }
        this.setRequestBasicParameters(byeReq);
        this.m_transactionStack.prossesUASipRequest(byeReq, this, -1L);
        return transactionId;
    }

    @Override
    public long sendCancel(long clientTransactionId) throws TransactionDoesNotExistException, SipException {
        Request inviteReq = this.getTransactionRequest(clientTransactionId, false);
        URI reqUril = inviteReq.getRequestURI();
        CallIdHeader callHeader = inviteReq.getCallIdHeader();
        CSeqHeader cseq = inviteReq.getCSeqHeader();
        cseq.setMethod("CANCEL");
        FromHeader from = inviteReq.getFromHeader();
        ToHeader to = inviteReq.getToHeader();
        List viaList = SIPStackUtil.headerIteratorToList(inviteReq.getViaHeaders());
        Request cancelReq = SipJainFactories.getInstance().getMesssageFactory().createRequest(reqUril, "CANCEL", callHeader, cseq, from, to, viaList);
        return this.sendRequest(cancelReq);
    }

    @Override
    public long sendRequest(Request request) throws IllegalArgumentException, SipException {
        return this.sendRequest(request, -1L);
    }

    public static long allocateTransactionId() {
        return SIPClientTransactionImpl.getNextTransactionId();
    }

    public long sendRequest(Request request, long transactionId) throws IllegalArgumentException, SipException {
        this.setRequestBasicParameters(request);
        return this.m_transactionStack.prossesUASipRequest(request, this, transactionId);
    }

    @Override
    public void sendResponse(long serverTransactionId, int statusCode, byte[] body, String bodyType, String bodySubType, String reasonPhrase) throws IllegalArgumentException, TransactionDoesNotExistException, SipParseException, SipException {
        Response response = null;
        Request req = this.getTransactionRequest(serverTransactionId, true);
        CallIdHeader callHeader = req.getCallIdHeader();
        CSeqHeader cseq = req.getCSeqHeader();
        FromHeader from = req.getFromHeader();
        ToHeader to = req.getToHeader();
        List viaList = SIPStackUtil.headerIteratorToList(req.getViaHeaders());
        ContentTypeHeader contentHeader = null;
        if (bodyType != null && bodySubType != null) {
            contentHeader = SipJainFactories.getInstance().getHeaderFactory().createContentTypeHeader(bodyType, bodySubType);
            response = SipJainFactories.getInstance().getMesssageFactory().createResponse(statusCode, callHeader, cseq, from, to, viaList, body, contentHeader);
        } else {
            response = SipJainFactories.getInstance().getMesssageFactory().createResponse(statusCode, callHeader, cseq, from, to, viaList);
        }
        if (reasonPhrase != null) {
            response.setReasonPhrase(reasonPhrase);
        }
        this.sendResponse(serverTransactionId, response);
    }

    @Override
    public void sendResponse(long serverTransactionId, int statusCode, String body, String bodyType, String bodySubType, String reasonPhrase) throws IllegalArgumentException, TransactionDoesNotExistException, SipParseException, SipException {
        this.sendResponse(serverTransactionId, statusCode, body.getBytes(), bodyType, bodySubType, reasonPhrase);
    }

    @Override
    public void sendResponse(long serverTransactionId, int statusCode, String reasonPhrase) throws TransactionDoesNotExistException, SipParseException, SipException {
        this.sendResponse(serverTransactionId, statusCode, "", null, null, reasonPhrase);
    }

    @Override
    public void sendResponse(long serverTransactionId, Response response) throws IllegalArgumentException, TransactionDoesNotExistException, SipException {
        this.m_transactionStack.prossesUASipResponse(response, serverTransactionId);
    }

    public void sendResponse(Response response) throws SipException {
        MessageContext messageContext = MessageContextFactory.instance().getMessageContext(response);
        try {
            this.m_transactionStack.getTransportCommLayerMgr().sendMessage(messageContext, this, null);
        }
        catch (Exception e2) {
            messageContext.writeError(e2);
        }
    }

    public void sendEventToUA(SipEvent event) {
        this.onTransportEvent(event);
    }

    public void onTransportEvent(SipEvent event) {
        switch (event.getEventId()) {
            case 2: {
                this.onStackRequestEvent(event);
                break;
            }
            case 1: 
            case 4: {
                this.onStackResponseEvent(event);
                break;
            }
            case 3: {
                this.onStackTimeOutEvent(event);
            }
        }
    }

    private void onStackResponseEvent(SipEvent responseReceivedEvent) {
        List listeners = this.m_listenersList;
        for (int i = 0; i < listeners.size(); ++i) {
            SipListener listener = (SipListener)listeners.get(i);
            listener.processResponse(responseReceivedEvent);
        }
    }

    private void onStackTimeOutEvent(SipEvent transactionTimeOutEvent) {
        List listeners = this.m_listenersList;
        for (int i = 0; i < listeners.size(); ++i) {
            SipListener listener = (SipListener)listeners.get(i);
            listener.processTimeOut(transactionTimeOutEvent);
        }
    }

    private void onStackRequestEvent(SipEvent requestReceivedEvent) {
        List listeners = this.m_listenersList;
        for (int i = 0; i < listeners.size(); ++i) {
            SipListener listener = (SipListener)listeners.get(i);
            listener.processRequest(requestReceivedEvent);
        }
    }

    public String toString() {
        return "Sip Provider for listeningPoint " + this.m_listeningPoint.toString();
    }

    private void setRequestBasicParameters(Request req) throws SipParseException {
        ViaHeader via;
        if (req.getFromHeader().getTag() == null) {
            req.getFromHeader().setTag(SIPStackUtil.generateTag());
        }
        if ((via = (ViaHeader)req.getHeader("Via", true)) == null) {
            throw new SipParseException("no via header in message:\n", req.toString());
        }
        if (via.getBranch() == null) {
            via.setBranch(SIPStackUtil.generateBranchId());
        }
    }

    private void setResponeBasicParameters(Response res) throws SipParseException {
        if (res.getToHeader().getTag() == null) {
            res.getToHeader().setTag(SIPStackUtil.generateTag());
        }
    }
}

