/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.extensions;

import com.ibm.ws.jain.protocol.ip.sip.extensions.RSeqHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;

public class RSeqHeaderImpl
extends HeaderImpl
implements RSeqHeader {
    private long m_responseNumber;

    @Override
    public long getResponseNumber() {
        return this.m_responseNumber;
    }

    @Override
    public final void setResponseNumber(long responseNumber) throws SipParseException {
        if (responseNumber < 1L || responseNumber > 0xFFFFFFFFL) {
            throw new SipParseException("Invalid response number set in RSeq header");
        }
        this.m_responseNumber = responseNumber;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        long responseNumber = parser.longNumber();
        this.setResponseNumber(responseNumber);
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_responseNumber);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof RSeqHeaderImpl)) {
            return false;
        }
        RSeqHeaderImpl o = (RSeqHeaderImpl)other;
        return this.m_responseNumber == o.m_responseNumber;
    }

    @Override
    public String getName() {
        return "RSeq";
    }

    @Override
    public boolean isNested() {
        return false;
    }
}

