/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.MaxForwardsHeader;

public class MaxForwardsHeaderImpl
extends HeaderImpl
implements MaxForwardsHeader {
    private static final long serialVersionUID = 366272668924552459L;
    private int m_maxForwards;

    @Override
    public void setMaxForwards(int maxforwards) throws SipParseException {
        if (maxforwards < 0) {
            throw new SipParseException("negative MaxForwards", "" + maxforwards);
        }
        this.m_maxForwards = maxforwards;
    }

    @Override
    public void decrementMaxForwards() throws SipException {
        if (this.m_maxForwards == 0) {
            throw new SipParseException("Max-forwards equals zero");
        }
        --this.m_maxForwards;
    }

    @Override
    public int getMaxForwards() {
        return this.m_maxForwards;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.m_maxForwards = parser.number();
    }

    @Override
    protected void encodeValue(CharsBuffer buf) {
        buf.append(this.m_maxForwards);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof MaxForwardsHeaderImpl)) {
            return false;
        }
        MaxForwardsHeaderImpl o = (MaxForwardsHeaderImpl)other;
        return this.m_maxForwards == o.m_maxForwards;
    }

    @Override
    public String getName() {
        return "Max-Forwards";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }
}

