/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.TimeStampHeader;

public class TimeStampHeaderImpl
extends HeaderImpl
implements TimeStampHeader {
    private static final long serialVersionUID = -7788231624812969574L;
    double m_timeStamp = 0.0;
    double m_delay = -1.0;

    @Override
    public float getTimeStamp() {
        return (float)this.m_timeStamp;
    }

    @Override
    public float getDelay() {
        return (float)this.m_delay;
    }

    @Override
    public boolean hasDelay() {
        return this.m_delay != -1.0;
    }

    @Override
    public void setTimeStamp(float timestamp) throws SipParseException {
        if (timestamp < 0.0f) {
            throw new SipParseException("Negative TimeStamp", "" + timestamp);
        }
        this.m_timeStamp = timestamp;
    }

    @Override
    public void setDelay(float delay) throws SipParseException {
        if (delay < 0.0f) {
            throw new SipParseException("Negative Delay");
        }
        this.m_delay = delay;
    }

    @Override
    public void removeDelay() {
        this.m_delay = -1.0;
    }

    private double parseTimeValue(SipParser parser) throws SipParseException {
        StringBuilder buffer = new StringBuilder(64);
        char digit = parser.LA(1);
        while (Character.isDigit(digit)) {
            parser.consume();
            buffer.append(digit);
            digit = parser.LA();
        }
        if (parser.LA(1) == '.') {
            parser.consume();
            buffer.append('.');
            digit = parser.LA(1);
            while (Character.isDigit(digit)) {
                parser.consume();
                buffer.append(digit);
                digit = parser.LA();
            }
        }
        String s = buffer.toString();
        try {
            double timeValue = Double.parseDouble(s);
            if (Double.isInfinite(timeValue)) {
                throw new SipParseException("Bad Timestamp header");
            }
            return timeValue;
        }
        catch (NumberFormatException e2) {
            throw new SipParseException(s);
        }
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.m_timeStamp = this.parseTimeValue(parser);
        parser.lws();
        if (parser.LA(1) != '\u0000') {
            this.m_delay = this.parseTimeValue(parser);
        }
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_timeStamp);
        if (this.hasDelay()) {
            ret.append(' ');
            ret.append(this.m_delay);
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof TimeStampHeaderImpl)) {
            return false;
        }
        TimeStampHeaderImpl o = (TimeStampHeaderImpl)other;
        return this.m_timeStamp == o.m_timeStamp && this.m_delay == o.m_delay;
    }

    @Override
    public String getName() {
        return "Timestamp";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }
}

