/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.WarningHeader;

public class WarningHeaderImpl
extends HeaderImpl
implements WarningHeader {
    private static final long serialVersionUID = -6135987514484576661L;
    private int m_code;
    private String m_host;
    private int m_port = -1;
    private String m_text;

    @Override
    public int getCode() {
        return this.m_code;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean hasPort() {
        return this.m_port != -1;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setAgent(String host) throws SipParseException, IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("Warning: null host");
        }
        this.m_host = host;
    }

    @Override
    public void setCode(int code) throws SipParseException {
        if (code < 100 || code > 999) {
            throw new SipParseException("Warning: Only 3 digit code", "" + code);
        }
        this.m_code = code;
    }

    public void setHost(String host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("Warning: null host");
        }
        this.m_host = host;
    }

    public void setPort(int port) throws SipParseException {
        if (port < 0) {
            throw new SipParseException("Warning: negative port");
        }
        this.m_port = port;
    }

    public void removePort() {
        this.m_port = -1;
    }

    @Override
    public void setText(String text) throws IllegalArgumentException, SipParseException {
        if (text == null) {
            throw new IllegalArgumentException("Warning: null text");
        }
        if (text.length() == 0) {
            throw new SipParseException("Warning: Empty text");
        }
        this.m_text = text;
    }

    @Override
    public String getAgent() {
        return this.m_host;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        try {
            this.setCode(parser.number());
            parser.match(' ');
            String agent = parser.nextToken(' ');
            this.setAgent(agent);
            parser.match(' ');
            this.setText(parser.quotedString());
        }
        catch (NumberFormatException e2) {
            throw new SipParseException(e2.getMessage(), "");
        }
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_code);
        ret.append(' ');
        ret.append(this.m_host);
        if (this.hasPort()) {
            ret.append(this.m_port);
        }
        if (this.m_text != null) {
            ret.append(' ');
            if (this.m_text.charAt(0) == '\"') {
                ret.append(this.m_text);
            } else {
                ret.append('\"');
                ret.append(this.m_text);
                ret.append('\"');
            }
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof WarningHeaderImpl)) {
            return false;
        }
        WarningHeaderImpl o = (WarningHeaderImpl)other;
        if (this.m_code != o.m_code) {
            return false;
        }
        if (this.m_port != o.m_port) {
            return false;
        }
        if (this.m_host == null || this.m_host.length() == 0 ? o.m_host != null && o.m_host.length() > 0 : o.m_host == null || o.m_host.length() == 0) {
            return false;
        }
        if (this.m_text == null || this.m_text.length() == 0) {
            return o.m_text == null || o.m_text.length() == 0;
        }
        if (o.m_text == null || o.m_text.length() == 0) {
            return false;
        }
        return this.m_text.equals(o.m_text);
    }

    @Override
    public String getName() {
        return "Warning";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }
}

