/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.annotation;

import com.ibm.ws.sip.container.annotation.NotSipModuleException;
import com.ibm.ws.sip.container.annotation.SipAnnotationUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SipModuleAnnotationProcessor {
    private static final String SIP_ANNOTATION_MARKER_FILE = "/WEB-INF/sipAnnotation.read";
    private static final String className = SipModuleAnnotationProcessor.class.getName();
    private static Logger c_logger = null;
    private String pathToModule = null;
    private Document sipXmlDocument = null;
    private Document webXmlDocument = null;
    private String sipAppName = "";
    private boolean is289 = false;

    public SipModuleAnnotationProcessor(String pathToModule) throws NotSipModuleException, IOException, ParserConfigurationException {
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.entering(className, "SipModuleAnnotationProcessor", pathToModule);
        }
        this.pathToModule = pathToModule;
        InputStream webInputStream = null;
        File moduleFile = new File(pathToModule);
        JarFile jarFile = new JarFile(moduleFile);
        ZipEntry webInf = jarFile.getEntry("WEB-INF");
        if (webInf == null) {
            throw new NotSipModuleException("No WEB-INF directory, it not a SIP module file");
        }
        ZipEntry webxml = jarFile.getEntry("WEB-INF/web.xml");
        if (webxml != null) {
            webInputStream = jarFile.getInputStream(webxml);
        }
        if (webxml == null) {
            File webinf = new File(pathToModule + "dir/WEB-INF");
            webinf.mkdirs();
            File webxmlfile = new File(pathToModule + "dir/WEB-INF/web.xml");
            File moduleJar = new File(pathToModule);
            File moduleJarUpdateDir = new File(pathToModule + "dir");
            FileOutputStream fos = new FileOutputStream(webxmlfile);
            fos.write(SipAnnotationUtil.getBaicWebXml().getBytes());
            fos.close();
            jarFile.close();
            webxmlfile.setLastModified(System.currentTimeMillis() - 60000L);
            webInputStream = new ByteArrayInputStream(SipAnnotationUtil.getBaicWebXml().getBytes());
        }
        DocumentBuilderFactory xmlParser = DocumentBuilderFactory.newInstance();
        xmlParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        xmlParser.setNamespaceAware(true);
        DocumentBuilder builder = xmlParser.newDocumentBuilder();
        DefaultHandler dh = new DefaultHandler(){

            @Override
            public void error(SAXParseException saxparseexception) throws SAXException {
                throw saxparseexception;
            }
        };
        builder.setErrorHandler(dh);
        try {
            this.webXmlDocument = builder.parse(webInputStream);
            webInputStream.close();
        }
        catch (SAXException e2) {
            jarFile.close();
            throw new NotSipModuleException("Not a sip container module, can not parse web.xml");
        }
        InputStream sipInputStream = null;
        ZipEntry jarEntry = jarFile.getEntry("WEB-INF/sip.xml");
        if (jarEntry != null) {
            sipInputStream = jarFile.getInputStream(jarEntry);
        }
        if (sipInputStream == null) {
            sipInputStream = new ByteArrayInputStream(SipAnnotationUtil.getBaicSipXml().getBytes());
        }
        try {
            DocumentBuilder builder2 = xmlParser.newDocumentBuilder();
            builder2.setErrorHandler(dh);
            this.sipXmlDocument = builder2.parse(sipInputStream);
            SipAnnotationUtil.validateJsr289(this.sipXmlDocument);
            this.setIs289(true);
        }
        catch (SAXException exception) {
            if (c_logger.isLoggable(Level.FINEST)) {
                c_logger.finest("Failed to parse Sip.xml with jsr1.1 schema validation, trying without schema validation, message is: " + exception.getMessage());
            }
            DocumentBuilder builder2 = xmlParser.newDocumentBuilder();
            builder2.setErrorHandler(dh);
            jarEntry = jarFile.getEntry("WEB-INF/sip.xml");
            if (jarEntry != null) {
                sipInputStream = jarFile.getInputStream(jarEntry);
            }
            this.setIs289(false);
            try {
                this.sipXmlDocument = builder2.parse(sipInputStream);
            }
            catch (SAXException saxExc) {
                if (c_logger.isLoggable(Level.FINE)) {
                    c_logger.log(Level.FINE, className, "Unable to parse sipXml -> SAXException: " + saxExc);
                }
                throw new NotSipModuleException("Unable to parse sipXml", saxExc);
            }
            catch (Exception exs) {
                if (c_logger.isLoggable(Level.FINE)) {
                    c_logger.log(Level.FINE, className, "Unable to parse sipXml -> Exception: " + exs);
                }
                throw new NotSipModuleException("Exception: Unable to parse sipXml", exs);
            }
        }
        sipInputStream.close();
        jarFile.close();
        if (c_logger.isLoggable(Level.FINER)) {
            c_logger.exiting(className, "SipModuleAnnotationProcessor");
        }
    }

    private SipModuleAnnotationProcessor() {
    }

    public void saveSipXml() {
    }

    public void saveSipAndWebXml() {
    }

    public void setSipAppName(String sipAppName) {
        this.sipAppName = sipAppName;
    }

    public String getSipAppName() {
        return this.sipAppName;
    }

    public void setIs289(boolean is289) {
        this.is289 = is289;
    }

    public boolean is289() {
        return this.is289;
    }

    static {
        c_logger = Logger.getLogger(className);
    }
}

