/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.SipApplicationSessionStateListener;
import com.ibm.websphere.sip.SipSessionStateListener;
import com.ibm.websphere.sip.unmatchedMessages.UnmatchedMessageListener;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.web.common.Servlet;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.sip.container.annotation.ApplicationKeyHelper;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.parser.GenericAppDesc;
import com.ibm.ws.sip.container.parser.SecurityConstraint;
import com.ibm.ws.sip.container.parser.ServletsInstanceHolder;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.rules.Condition;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAlias;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAliasImpl;
import com.ibm.ws.sip.stack.transport.virtualhost.SipVirtualHostAdapter;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;

public class SipAppDesc
extends GenericAppDesc {
    static final long serialVersionUID = 4431618929876845268L;
    private static final LogMgr c_logger = Log.get(SipAppDesc.class);
    private static final String EXCLUDE_APPLICATION_ROUTING_ATTRIBUTE = "com.ibm.sip.container.exclude.application.routing";
    private String m_display_name = null;
    private String m_app_name = null;
    private BitSet m_wasSet = new BitSet(PRIMITIVE_LOCATION.values().length);
    private Integer m_appIndexForPmi = null;
    private Map<String, SipServletDesc> m_siplets = new LinkedHashMap<String, SipServletDesc>();
    private Map<String, String> m_contextParams = new LinkedHashMap<String, String>();
    private TimerListener m_timerListener;
    private HashMap<String, SipApplicationSessionListener> m_appSessionListeners = new HashMap();
    private HashMap<String, SipSessionListener> m_sessionListeners = new HashMap();
    private HashMap<String, SipSessionStateListener> m_sessionStateListeners = new HashMap();
    private HashMap<String, SipApplicationSessionStateListener> m_appSessionStateListeners = new HashMap();
    private HashMap<String, SipApplicationSessionActivationListener> m_appSessionActivationListeners = new HashMap();
    private HashMap<String, SipSessionAttributeListener> m_sessionAttributeListeners = new HashMap();
    private HashMap<String, SipApplicationSessionAttributeListener> m_appSessionAttributeListeners = new HashMap();
    private HashMap<String, SipErrorListener> m_errorListeners = new HashMap();
    private HashMap<String, SipServletListener> m_sipServletListeners = new HashMap();
    private HashMap<String, UnmatchedMessageListener> m_unmatchedMessageListener = new HashMap();
    private int m_appSessionTTL = 3;
    private String m_rootURI = null;
    private transient SipFactory m_sipFactory;
    private String m_webTransportHost;
    private int m_webTransportPort = -1;
    private boolean m_webTransportIsSSL;
    private String m_webAppName;
    private boolean m_isDistributed;
    private int _proxyTimeout = 180;
    private String m_description;
    private String m_realm = "sip";
    private List<SipServlet> onStartupServlets = Collections.synchronizedList(new ArrayList());
    private List<SecurityConstraint> m_securityConstraints = new LinkedList<SecurityConstraint>();
    private List<VirtualHostAlias> _virtualHostAliases = Collections.synchronizedList(new ArrayList());
    private String _virtualHostName;
    private int _vhPort = -1;
    private String _vhHost = null;
    private ContextEstablisher _contextEstablisher;
    private boolean hasMainServlet = false;
    private String mainSipletName = null;
    private SipServletDesc mainServlet = null;
    private ApplicationKeyHelper applicationKeyHelper = null;
    private WebApp _webApp = null;
    private HashSet<String> _sipListeners = new HashSet();
    private String _appKeyClassName;
    private String _appKeyMethodName;
    private boolean m_wasInitialized = false;
    private boolean m_isDuringWebAppInitialization = false;
    private Map<String, Condition> m_servletsPatterns = new HashMap<String, Condition>();
    private boolean m_shouldExcludeFromApplicationRouting = false;

    public SipAppDesc(String display_name, String app_name) {
        this.m_app_name = app_name;
        this.m_display_name = display_name;
    }

    public void setDisplayName(String displayName) {
        if (this.m_display_name == null) {
            this.m_display_name = displayName;
        }
    }

    public void setAppName(String appName) {
        if (this.m_app_name == null) {
            this.m_app_name = appName;
        }
    }

    public SipAppDesc() {
    }

    private String generateAppName() {
        int hashCode = 0;
        for (SipServletDesc siplet : this.m_siplets.values()) {
            hashCode += siplet.getName().hashCode();
            hashCode <<= 5;
            hashCode += siplet.getClassName().hashCode();
            hashCode <<= 5;
        }
        String name = "UnnamedSipApp-" + Integer.toHexString(hashCode);
        return name;
    }

    public void addSipServlet(SipServletDesc siplet) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addSipServlets", "addSipServlet - getRootURI = " + siplet.getSipApp().getRootURI());
        }
        if (!this.m_siplets.containsKey(siplet.getName())) {
            this.m_siplets.put(siplet.getName(), siplet);
        }
    }

    public void addSipServlets(Collection<SipServletDesc> siplets) {
        for (SipServletDesc siplet : siplets) {
            this.addSipServlet(siplet);
        }
        if (this.m_app_name == null && this.m_display_name == null) {
            this.m_display_name = this.generateAppName();
        }
    }

    public List<SipServletDesc> getSipServlets() {
        return new ArrayList<SipServletDesc>(this.m_siplets.values());
    }

    public SipServletDesc getSipServlet(String name) {
        SipServletDesc siplet = this.m_siplets.get(name);
        return siplet;
    }

    public String getApplicationName() {
        return this.m_app_name != null ? this.m_app_name : this.m_display_name;
    }

    public TimerListener getTimerListener() {
        return this.m_timerListener;
    }

    public void addListenerObject(Object listener) {
        if (listener instanceof TimerListener) {
            this.setTimerListener((TimerListener)listener);
        }
        if (listener instanceof SipApplicationSessionListener) {
            this.addListenerToMap((SipApplicationSessionListener)listener, this.m_appSessionListeners, "m_appSessionListeners");
        }
        if (listener instanceof SipApplicationSessionAttributeListener) {
            this.addListenerToMap((SipApplicationSessionAttributeListener)listener, this.m_appSessionAttributeListeners, "m_appSessionAttributeListeners");
        }
        if (listener instanceof SipSessionListener) {
            this.addListenerToMap((SipSessionListener)listener, this.m_sessionListeners, "m_sessionListeners");
        }
        if (listener instanceof SipSessionStateListener) {
            this.addListenerToMap((SipSessionStateListener)listener, this.m_sessionStateListeners, "m_sessionStateListeners");
        }
        if (listener instanceof SipApplicationSessionStateListener) {
            this.addListenerToMap((SipApplicationSessionStateListener)listener, this.m_appSessionStateListeners, "m_appSessionStateListeners");
        }
        if (listener instanceof SipApplicationSessionActivationListener) {
            this.addListenerToMap((SipApplicationSessionActivationListener)listener, this.m_appSessionActivationListeners, "m_appSessionActivationListeners");
        }
        if (listener instanceof SipErrorListener) {
            this.addListenerToMap((SipErrorListener)listener, this.m_errorListeners, "m_errorListeners");
        }
        if (listener instanceof SipSessionAttributeListener) {
            this.addListenerToMap((SipSessionAttributeListener)listener, this.m_sessionAttributeListeners, "m_sessionAttributeListeners");
        }
        if (listener instanceof SipServletListener) {
            this.addListenerToMap((SipServletListener)listener, this.m_sipServletListeners, "m_sipServletListeners");
        }
        if (listener instanceof UnmatchedMessageListener) {
            this.addListenerToMap((UnmatchedMessageListener)listener, this.m_unmatchedMessageListener, "m_unmatchedMessageListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(String listenerClass) {
        Object listener = null;
        listener = ServletsInstanceHolder.getInstance().getSipletinstance(this.getApplicationName(), listenerClass);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addListener", "searched Listener existance from web container for [" + this.getApplicationName() + "][" + listenerClass + "][" + listener + "]");
        }
        if (listener == null) {
            block16: {
                try {
                    ClassLoader originalThreadClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this._webApp.getClassLoader());
                    try {
                        Class<?> c = this._webApp.getClassLoader().loadClass(listenerClass);
                        listener = c.newInstance();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalThreadClassLoader);
                    }
                }
                catch (ClassNotFoundException e2) {
                    if (c_logger.isErrorEnabled()) {
                        Object[] args = new Object[]{listenerClass, this.getApplicationName()};
                        c_logger.error("error.listener.not.found", "Create", args, (Throwable)e2);
                    }
                }
                catch (InstantiationException e3) {
                    if (c_logger.isErrorEnabled()) {
                        Object[] args = new Object[]{listenerClass, this.getApplicationName()};
                        c_logger.error("error.init.listener.failed", "Create", args, (Throwable)e3);
                    }
                }
                catch (IllegalAccessException e4) {
                    if (c_logger.isErrorEnabled()) {
                        Object[] args = new Object[]{listenerClass, this.getApplicationName()};
                        c_logger.error("error.init.listener.failed", "Create", args, (Throwable)e4);
                    }
                }
                catch (NoClassDefFoundError e5) {
                    if (!c_logger.isErrorEnabled()) break block16;
                    Object[] args = new Object[]{listenerClass, this.getApplicationName()};
                    c_logger.error("error.init.listener.failed", "Create", args, (Throwable)e5);
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addListener", "instance created");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addListener", "instance is siplet");
        }
        this.addListenerObject(listener);
    }

    protected void setTimerListener(TimerListener timerListener) {
        if (null != this.m_timerListener) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{this.getApplicationName()};
                c_logger.error("error.too.many.timer.listeners", "Create", args);
            }
        } else {
            this.m_timerListener = timerListener;
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(64);
                b.append("Setting Timer Listener: ");
                b.append(this.m_timerListener);
                b.append(" For Application: ");
                b.append(this.getApplicationName());
                c_logger.traceDebug(this, "setTimerListener", b.toString());
            }
        }
    }

    protected void replaceTimerListener(TimerListener timerListener) {
        if (this.m_timerListener != null && this.m_timerListener.getClass().getName().equals(timerListener.getClass().getName())) {
            this.m_timerListener = timerListener;
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(64);
                b.append("Replacing Timer Listener: ");
                b.append(this.m_timerListener);
                b.append(" For Application: ");
                b.append(this.getApplicationName());
                c_logger.traceDebug(this, "replaceTimerListener", b.toString());
            }
        }
    }

    protected void replaceAppSessionListener(SipApplicationSessionListener listener) {
        this.replaceListener(listener, this.m_appSessionListeners, "m_appSessionListeners");
    }

    protected void replaceSessionListener(SipSessionListener listener) {
        this.replaceListener(listener, this.m_sessionListeners, "m_sessionListeners");
    }

    protected void replaceSipSessionStateListener(SipSessionStateListener listener) {
        this.replaceListener(listener, this.m_sessionStateListeners, "m_sessionStateListeners");
    }

    protected void replaceApplicationSessionStateListener(SipApplicationSessionStateListener listener) {
        this.replaceListener(listener, this.m_appSessionStateListeners, "m_appSessionStateListeners");
    }

    protected void replaceApplicationSessionActivationListener(SipApplicationSessionActivationListener listener) {
        this.replaceListener(listener, this.m_appSessionActivationListeners, "m_appSessionActivationListeners");
    }

    protected void replaceSessionAttributeListener(SipSessionAttributeListener listener) {
        this.replaceListener(listener, this.m_sessionAttributeListeners, "m_sessionAttributeListeners");
    }

    protected void replaceAppSessionAttributeListener(SipApplicationSessionAttributeListener listener) {
        this.replaceListener(listener, this.m_appSessionAttributeListeners, "m_appSessionAttributeListeners");
    }

    protected void replaceErrorListener(SipErrorListener listener) {
        this.replaceListener(listener, this.m_errorListeners, "m_errorListeners");
    }

    protected void replaceSipServletListener(SipServletListener listener) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "replaceSipServletListener", listener + "");
        }
        this.replaceListener(listener, this.m_sipServletListeners, "m_sipServletListeners");
    }

    private <T extends EventListener> void addListenerToMap(T listener, HashMap<String, T> listenerMap, String mapName) {
        listenerMap.put(listener.getClass().getName(), listener);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Adding Listener: ");
            b.append(listener);
            b.append(" To Map: ");
            b.append(mapName);
            b.append(" For Application: ");
            b.append(this.getApplicationName());
            c_logger.traceDebug(this, "addListenerToMap", b.toString());
        }
    }

    private <T extends EventListener> void replaceListener(T listener, HashMap<String, T> listenerMap, String mapName) {
        EventListener orig = (EventListener)listenerMap.get(listener.getClass().getName());
        if (orig != null) {
            listenerMap.put(listener.getClass().getName(), listener);
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(64);
                b.append("Replacing Listener: ");
                b.append(listener);
                b.append(" In map: ");
                b.append(mapName);
                b.append(" For Application: ");
                b.append(this.getApplicationName());
                c_logger.traceDebug(this, "replaceListener", b.toString());
            }
        }
    }

    protected void removeAppSessionListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_appSessionListeners, "m_appSessionListeners");
    }

    protected void removeSessionListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_sessionListeners, "m_sessionListeners");
    }

    protected void removeSipSessionStateListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_sessionStateListeners, "m_sessionStateListeners");
    }

    protected void removeApplicationSessionStateListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_sessionStateListeners, "m_sessionStateListeners");
    }

    protected void removeApplicationSessionActivationListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_appSessionActivationListeners, "m_appSessionActivationListeners");
    }

    protected void removeSessionAttributeListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_sessionAttributeListeners, "m_sessionAttributeListeners");
    }

    protected void removeAppSessionAttributeListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_appSessionAttributeListeners, "m_appSessionAttributeListeners");
    }

    protected void removeErrorListener(String listenerClass) {
        this.removeListener(listenerClass, this.m_errorListeners, "m_errorListeners");
    }

    protected void removeSipServletListener(String listenerClass) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeSipServletListener", listenerClass + "");
        }
        this.removeListener(listenerClass, this.m_sipServletListeners, "m_sipServletListeners");
    }

    protected void removeTimerListener() {
        this.m_timerListener = null;
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Removing Timer Listener: ");
            b.append(" For Application: ");
            b.append(this.getApplicationName());
            c_logger.traceDebug(this, "removeTimerListener", b.toString());
        }
    }

    protected <T extends EventListener> void removeListener(String listenerClass, HashMap<String, T> listenerMap, String mapName) {
        EventListener orig = (EventListener)listenerMap.remove(listenerClass);
        if (orig != null && c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Removing Listener: ");
            b.append(" Class: " + listenerClass);
            b.append(" From map: " + mapName);
            b.append(" For Application: ");
            b.append(this.getApplicationName());
            c_logger.traceDebug(this, "removeListener", b.toString());
        }
    }

    public String getRootURI() {
        return this.m_rootURI;
    }

    public void setRootURI(String string) {
        if (this.m_rootURI == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setRootURI", string);
            }
            this.m_rootURI = string;
        }
    }

    public Collection<SipApplicationSessionListener> getAppSessionListeners() {
        return this.m_appSessionListeners.values();
    }

    public Collection<SipSessionListener> getSessionListeners() {
        return this.m_sessionListeners.values();
    }

    public Collection<SipSessionStateListener> getSessionStateListeners() {
        return this.m_sessionStateListeners.values();
    }

    public Collection<SipApplicationSessionStateListener> getAppSessionStateListeners() {
        return this.m_appSessionStateListeners.values();
    }

    public Collection<SipApplicationSessionActivationListener> getAppSessionActivationListeners() {
        return this.m_appSessionActivationListeners.values();
    }

    public Collection<SipSessionAttributeListener> getSessionAttributesListeners() {
        return this.m_sessionAttributeListeners.values();
    }

    public Collection<SipServletListener> getSipServletListeners() {
        return this.m_sipServletListeners.values();
    }

    public Collection<UnmatchedMessageListener> getUnmatchedMessagesListeners() {
        return this.m_unmatchedMessageListener.values();
    }

    public Collection<SipApplicationSessionAttributeListener> getAppSessionAttributesListeners() {
        return this.m_appSessionAttributeListeners.values();
    }

    public Collection<SipErrorListener> getErrorListeners() {
        return this.m_errorListeners.values();
    }

    public void setAppSessionTTL(int ttl) {
        if (!this.m_wasSet.get(PRIMITIVE_LOCATION.APP_TTL_BIT.ordinal())) {
            this.m_appSessionTTL = ttl;
            this.m_wasSet.set(PRIMITIVE_LOCATION.APP_TTL_BIT.ordinal());
        }
    }

    public int getAppSessionTTL() {
        return this.m_appSessionTTL;
    }

    public SipServletDesc getDefaultSiplet() {
        if (this.m_siplets.isEmpty()) {
            throw new RuntimeException("No SipServlet was defined on sip.xml for this application: " + this.getApplicationName());
        }
        SipServletDesc sipletDesc = this.m_siplets.values().iterator().next();
        return sipletDesc;
    }

    public void addContextParam(String name, String value) {
        this.m_contextParams.put(name, value);
    }

    public Map<String, String> getAppContextParams() {
        return this.m_contextParams;
    }

    public SipFactory getSipFactory() {
        return this.m_sipFactory;
    }

    public void setSipFactory(SipFactory factory) {
        this.m_sipFactory = factory;
    }

    public String toString() {
        return "Sip application descriptor: " + this.getApplicationName();
    }

    public void setWebTransportrPort(int port) {
        if (!this.m_wasSet.get(PRIMITIVE_LOCATION.WEB_TRASNSPORT_PORT_BIT.ordinal())) {
            this.m_webTransportPort = port;
            this.m_wasSet.set(PRIMITIVE_LOCATION.WEB_TRASNSPORT_PORT_BIT.ordinal());
        }
    }

    public void setWebTransportIsSSL(boolean isSSL) {
        if (!this.m_wasSet.get(PRIMITIVE_LOCATION.WEB_TRASNSPORT_SSL_BIT.ordinal())) {
            this.m_webTransportIsSSL = isSSL;
            this.m_wasSet.set(PRIMITIVE_LOCATION.WEB_TRASNSPORT_SSL_BIT.ordinal());
        }
    }

    public void setWebTransportHost(String host) {
        if (this.m_webTransportHost == null) {
            this.m_webTransportHost = host;
        }
    }

    public String getWebTransportHost() {
        return this.m_webTransportHost;
    }

    public boolean getWebTransportIsSSL() {
        return this.m_webTransportIsSSL;
    }

    public int getWebTransportPort() {
        return this.m_webTransportPort;
    }

    public String getWebAppName() {
        return this.m_webAppName;
    }

    public void setWebAppName(String webAppName) {
        if (this.m_webAppName == null) {
            this.m_webAppName = webAppName;
        }
    }

    public boolean isDistributed() {
        return this.m_isDistributed;
    }

    public void setIsDistributed(boolean distributed) {
        if (!this.m_wasSet.get(PRIMITIVE_LOCATION.IS_DISTRIBUTDED_BIT.ordinal())) {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{new Boolean(distributed)};
                c_logger.traceEntry((Object)this, "setIsDistributed", params);
            }
            this.m_isDistributed = distributed;
            this.m_wasSet.set(PRIMITIVE_LOCATION.IS_DISTRIBUTDED_BIT.ordinal());
        }
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    public void setProxyTimeout(int timeout) {
        if (timeout <= 0) {
            if (c_logger.isWarnEnabled()) {
                Object[] args = new Object[]{Integer.toString(timeout)};
                c_logger.error("warn.invalid.timeout.value", "Create", args);
            }
            return;
        }
        if (!this.m_wasSet.get(PRIMITIVE_LOCATION.PROXY_TIMEOUT_BIT.ordinal())) {
            this._proxyTimeout = timeout;
            this.m_wasSet.set(PRIMITIVE_LOCATION.PROXY_TIMEOUT_BIT.ordinal());
        }
    }

    public Integer getAppIndexForPmi() {
        return this.m_appIndexForPmi;
    }

    public void setAppIndexForPmi(Integer index) {
        this.m_appIndexForPmi = index;
    }

    public String getRealm() {
        return this.m_realm;
    }

    public void setRealm(String realm) {
        if (this.m_realm.equals("sip")) {
            this.m_realm = realm;
        }
    }

    public void addSecurityConstraint(SecurityConstraint cons) {
        this.m_securityConstraints.add(cons);
    }

    public List<SecurityConstraint> getSipSecurityConstraints() {
        return this.m_securityConstraints;
    }

    public List<VirtualHostAlias> getVirtualHostAliases() {
        return this._virtualHostAliases;
    }

    public void setVirtualHost(String name, List virtualHostsList) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "setVirtualHost", name, virtualHostsList);
        }
        this._virtualHostName = name;
        this._virtualHostAliases.clear();
        this._vhPort = -1;
        this._vhHost = null;
        for (int i = 0; i < virtualHostsList.size(); ++i) {
            VirtualHostAliasImpl vha = new VirtualHostAliasImpl();
            vha.init((String)virtualHostsList.get(i));
            this._virtualHostAliases.add(vha);
            this._vhPort = vha.getPort();
            this._vhHost = vha.getHost();
        }
        if (name.equals("default_host")) {
            SipVirtualHostAdapter.fillWithDefaultHostAliases(this._virtualHostAliases);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "setVirtualHost = Port = " + this._vhPort + " _Host = " + this._vhHost);
        }
    }

    public String getVirtualHostName() {
        return this._virtualHostName;
    }

    public int getVHPort() {
        return this._vhPort;
    }

    public String getVHHost() {
        return this._vhHost;
    }

    public void setContextEstablisher(ContextEstablisher ce) {
        this._contextEstablisher = ce;
    }

    public ContextEstablisher getContextEstablisher() {
        return this._contextEstablisher;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this._contextEstablisher == null ? this.getClass().getClassLoader() : this._contextEstablisher.getApplicationClassLoader();
        return classLoader;
    }

    public boolean hasMainServlet() {
        return this.hasMainServlet;
    }

    private void setHasMainServlet(boolean hasMainServlet) {
        if (!this.m_wasSet.get(PRIMITIVE_LOCATION.HAS_MAIN_SERVLET_BIT.ordinal())) {
            this.hasMainServlet = hasMainServlet;
            this.m_wasSet.set(PRIMITIVE_LOCATION.HAS_MAIN_SERVLET_BIT.ordinal());
        }
    }

    public String getMainSipletName() {
        return this.mainSipletName;
    }

    public void setMainSipletName(String mainSipletName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Setting main siplet: " + mainSipletName + " for applciation: " + this.getApplicationName() + " old name: " + this.mainSipletName);
        }
        if (this.mainSipletName == null) {
            this.mainSipletName = mainSipletName;
            this.setHasMainServlet(true);
        }
    }

    public SipServletDesc getMainSiplet() {
        return this.mainServlet;
    }

    public void setMainServlet(SipServletDesc mainServlet) {
        if (this.mainServlet == null) {
            this.mainServlet = mainServlet;
        }
    }

    public boolean isJSR289Application() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("isJSR289Application: m_app_name = " + this.m_app_name + "  =  " + this.hasMainServlet);
        }
        return this.m_app_name != null && !this.m_app_name.equals("");
    }

    public String getAppName() {
        if (this.isJSR289Application()) {
            return this.m_app_name;
        }
        return this.m_display_name;
    }

    public String getAppNameMember() {
        return this.m_app_name;
    }

    public String getDisplayName() {
        return this.m_display_name;
    }

    public void setApplicationKeyMethod() {
        block11: {
            if (this._appKeyClassName == null || this._appKeyMethodName == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry(this, "setApplicationKeyMethod, @SipApplicationKey not defined");
                }
                return;
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "setApplicationKeyMethod, method = " + this._appKeyMethodName + " class = " + this._appKeyClassName);
            }
            try {
                Method applicationKeyMethod = null;
                Class<?> appClass = this._webApp.getClassLoader().loadClass(this._appKeyClassName);
                applicationKeyMethod = appClass.getDeclaredMethod(this._appKeyMethodName, SipServletRequest.class);
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry((Object)this, "setApplicationKeyMethod", (Object)applicationKeyMethod);
                }
                if (applicationKeyMethod != null) {
                    this.applicationKeyHelper = new ApplicationKeyHelper(applicationKeyMethod);
                }
            }
            catch (ClassNotFoundException e2) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry((Object)this, "setApplicationKeyMethod-> ClassNotFoundException", e2.getStackTrace());
                }
            }
            catch (SecurityException e3) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry((Object)this, "setApplicationKeyMethod-> SecurityException", e3.getStackTrace());
                }
            }
            catch (NoSuchMethodException e4) {
                if (!c_logger.isTraceEntryExitEnabled()) break block11;
                c_logger.traceEntry((Object)this, "setApplicationKeyMethod-> NoSuchMethodException", e4.getStackTrace());
            }
        }
    }

    public boolean hasApplicationKeyMethod() {
        return this.applicationKeyHelper != null;
    }

    public ApplicationKeyHelper getApplicationKeyHelper() {
        return this.applicationKeyHelper;
    }

    public ServletContext getServletContext() {
        return this._webApp;
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public void setWebApp(WebApp webApp) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setWebApp", " setWebApp = " + webApp);
        }
        if (this._webApp == null) {
            this._webApp = webApp;
        }
    }

    public void setSipListeners(List<String> sipListeners) {
        if (this._sipListeners == null) {
            this._sipListeners = new HashSet();
        }
        this._sipListeners.addAll(sipListeners);
    }

    public void setupSipListeners() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setupSipListeners", " setupSipListeners, listeners = " + this._sipListeners.toString());
        }
        for (String listeners : this._sipListeners) {
            this.addListener(listeners);
        }
    }

    public void setupSipApplication() {
        this.setApplicationKeyMethod();
        SessionContext sc = (SessionContext)this._webApp.getSessionContext();
        if (sc != null) {
            sc.setSIPApplication(true);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setupSipApplication", "SessionContext is null for webApp = " + this._webApp);
        }
    }

    public void setAppKeyInfo(String cName, String mName) {
        this._appKeyClassName = cName;
        this._appKeyMethodName = mName;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setAppKeyInfo", " appKeyClassName = " + this._appKeyClassName + " appKeyMethodName = " + this._appKeyMethodName);
        }
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setDescription", "description = " + description);
        }
        if (this.m_description == null) {
            this.m_description = description;
        }
    }

    public void setWasInitialized(boolean wasInitialized) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setWasInitialized", "wasInitialized = " + wasInitialized);
        }
        this.m_wasInitialized = wasInitialized;
    }

    public boolean wasInitialized() {
        return this.m_wasInitialized;
    }

    public void setIsDuringWebAppInitialization(boolean isDuringWebAppInitialization) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setIsDuringWebAppInitialization", "isDuringWebAppInitialization = " + isDuringWebAppInitialization);
        }
        this.m_isDuringWebAppInitialization = isDuringWebAppInitialization;
    }

    public boolean isDuringWebAppInitialization() {
        return this.m_isDuringWebAppInitialization;
    }

    public Map<String, Condition> getServletsPatterns() {
        return this.m_servletsPatterns;
    }

    public void setServletsPatterns(Map<String, Condition> servletsPatterns) {
        this.m_servletsPatterns = servletsPatterns;
    }

    public void mergeWebApptoSip() {
        for (Servlet ddWebServlet : this._ddWebApp.getServlets()) {
            this.mergeSerlvetLoadOnStartup(ddWebServlet);
            this.mergeInitParams(ddWebServlet);
        }
        this.mergeContextParams();
    }

    private void mergeSerlvetLoadOnStartup(Servlet ddWebServlet) {
        int loadOnStartup = -1;
        if (ddWebServlet.isSetLoadOnStartup()) {
            loadOnStartup = ddWebServlet.isNullLoadOnStartup() ? 0 : ddWebServlet.getLoadOnStartup();
            String servletName = ddWebServlet.getServletName();
            SipServletDesc desc = this.m_siplets.get(servletName);
            if (desc != null) {
                desc.setServletLoadOnStartup(loadOnStartup);
            }
        }
    }

    private void mergeInitParams(Servlet ddWebServlet) {
        String servletName = ddWebServlet.getServletName();
        SipServletDesc desc = this.m_siplets.get(servletName);
        if (desc != null) {
            Map<String, String> descInitParams = desc.getInitParams();
            for (ParamValue webServletInitParam : ddWebServlet.getInitParams()) {
                String name = webServletInitParam.getName();
                String value = webServletInitParam.getValue();
                if (descInitParams.containsKey(name)) continue;
                descInitParams.put(name, value);
            }
        }
    }

    private void mergeContextParams() {
        for (ParamValue ddContextParam : this._ddWebApp.getContextParams()) {
            String name = ddContextParam.getName();
            String value = ddContextParam.getValue();
            if (this.m_contextParams.containsKey(name)) continue;
            this.m_contextParams.put(name, value);
        }
    }

    public void updateShouldExcludeFromApplicationRouting() {
        String excludeInitParam = this.m_contextParams.get(EXCLUDE_APPLICATION_ROUTING_ATTRIBUTE);
        this.m_shouldExcludeFromApplicationRouting = excludeInitParam != null;
    }

    public boolean shouldExcludeFromApplicationRouting() {
        return this.m_shouldExcludeFromApplicationRouting;
    }

    public void saveLoadOnStartupServlet(SipServlet sipServlet) {
        this.onStartupServlets.add(sipServlet);
    }

    public List<SipServlet> getLoadOnStartupServlets() {
        return this.onStartupServlets;
    }

    private static enum PRIMITIVE_LOCATION {
        APP_TTL_BIT,
        WEB_TRASNSPORT_PORT_BIT,
        WEB_TRASNSPORT_SSL_BIT,
        IS_DISTRIBUTDED_BIT,
        PROXY_TIMEOUT_BIT,
        HAS_MAIN_SERVLET_BIT;

    }
}

