/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi;

public class QueueMonitoringCounter {
    private int _totalTasksInQueue = 0;
    private int _peakTasks = 0;
    private int _minTasks = 0;
    private int _percentageFull = 0;
    private int _totalTasksArrivedDuringCurrentWindow = 0;
    protected int _queueSize = 1000;

    public synchronized void updateInTask() {
        ++this._totalTasksInQueue;
        ++this._totalTasksArrivedDuringCurrentWindow;
        this.updateStatistics();
    }

    public synchronized void updateOutTask() {
        --this._totalTasksInQueue;
        this.updateStatistics();
    }

    private void updateStatistics() {
        if (this._totalTasksInQueue > this._peakTasks) {
            this._peakTasks = this._totalTasksInQueue;
            this._percentageFull = this._queueSize > 0 ? (int)(100.0f * (float)this._peakTasks / (float)this._queueSize) : 0;
        }
        if (this._totalTasksInQueue < this._minTasks) {
            this._minTasks = this._totalTasksInQueue;
        }
    }

    public synchronized void initStatistics() {
        this._peakTasks = this._totalTasksInQueue;
        this._minTasks = this._totalTasksInQueue;
        this._totalTasksArrivedDuringCurrentWindow = 0;
        this._percentageFull = this._queueSize > 0 ? (int)(100.0f * (float)this._peakTasks / (float)this._queueSize) : 0;
    }

    public synchronized int getTotalTasksDuringCurrentWindow() {
        return this._totalTasksArrivedDuringCurrentWindow;
    }

    public synchronized int getPeakTasks() {
        return this._peakTasks;
    }

    public synchronized int getMinTasks() {
        return this._minTasks;
    }

    public synchronized int getPercentageFull() {
        return this._percentageFull;
    }
}

