/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.protocol.OutboundProcessor;
import com.ibm.ws.sip.container.proxy.BranchManager;
import com.ibm.ws.sip.container.proxy.SubsequentRequestListener;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.stack.properties.StackProperties;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.message.Request;
import java.io.IOException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public class RecordRouteProxy {
    private static final LogMgr c_logger = Log.get(RecordRouteProxy.class);
    public static final String LR = "lr";
    private static final HeaderFactory c_hdrFactory = StackProperties.getInstance().getHeadersFactory();
    private static final AddressFactory c_addrFactory = StackProperties.getInstance().getAddressFactory();

    public static final void proxyResponse(IncomingSipServletRequest origRequest, SipServletResponse inResponse) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{origRequest.getMethod(), inResponse.getReasonPhrase()};
            c_logger.traceEntry((Object)RecordRouteProxy.class, "proxyResponse", params);
        }
        ((IncomingSipServletResponse)inResponse).setIsCommited(false);
        TransactionUserWrapper tu = origRequest.getTransactionUser();
        tu.logToContext(268, inResponse.getStatus(), (Object)inResponse);
        if (inResponse.getStatus() > 100) {
            OutgoingSipServletResponse outResponse = BranchManager.createOutgoingResponse(origRequest, inResponse);
            origRequest.getTransactionUser().processSubsequentProxyResponse(outResponse);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(RecordRouteProxy.class, "proxyResponse", "ignoring 100 response for subsequent request");
        }
    }

    public static final void proxyRequest(SipServletRequest inRequest, TransactionUserWrapper transactionUser) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{inRequest.getMethod()};
            c_logger.traceEntry((Object)RecordRouteProxy.class, "proxyRequest", params);
        }
        SipServletRequestImpl inRequestImpl = (SipServletRequestImpl)inRequest;
        TransactionUserWrapper tu = inRequestImpl.getTransactionUser();
        OutgoingSipServletRequest outRequest = BranchManager.createOutgoingRequest(inRequestImpl);
        outRequest.setTransactionUser(tu);
        outRequest.setIsSubsequentRequest(true);
        try {
            RecordRouteProxy.updateRoutingPath(inRequest, outRequest, transactionUser);
        }
        catch (SipParseException e2) {
            RecordRouteProxy.logException(e2);
        }
        catch (ServletParseException e3) {
            RecordRouteProxy.logException((Exception)((Object)e3));
        }
        OutboundProcessor outboundProcessor = OutboundProcessor.instance();
        outboundProcessor.forwardingRequest(inRequestImpl, outRequest, null);
        SubsequentRequestListener listener = new SubsequentRequestListener(inRequest);
        outRequest.setClientTransactionListener(listener);
        tu.logToContext(267, outRequest.getRequestURI(), (Object)outRequest);
        RecordRouteProxy.sendRequestDownStream(outRequest);
    }

    private static void sendRequestDownStream(SipServletRequest request) {
        block3: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{request.getMethod()};
                c_logger.traceEntry((Object)RecordRouteProxy.class, "sendRequestDownStream", params);
            }
            try {
                request.send();
            }
            catch (IOException e2) {
                if (!c_logger.isErrorEnabled()) break block3;
                c_logger.error("error.exception", "Request", null, (Throwable)e2);
            }
        }
    }

    private static final void updateRoutingPath(SipServletRequest inRequest, OutgoingSipServletRequest outRequest, TransactionUserWrapper tUser) throws SipParseException, ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{tUser};
            c_logger.traceEntry((Object)RecordRouteProxy.class, "updateRoutingPath", params);
        }
        String topRouteSidParam = null;
        Object multihomeIndexParam = null;
        boolean routeExist = false;
        boolean isJSR289 = tUser.getSipServletDesc().getSipApp().isJSR289Application();
        if (isJSR289) {
            Address routeAddr = inRequest.getPoppedRoute();
            if (routeAddr != null) {
                topRouteSidParam = routeAddr.getURI().getParameter("ibmsid");
                routeExist = true;
            }
        } else {
            RouteHeader topRoute = RecordRouteProxy.getTopRoute(inRequest);
            if (topRoute != null) {
                topRouteSidParam = RecordRouteProxy.getSessionIdParamFromRoute(topRoute);
                routeExist = true;
            }
        }
        if (routeExist) {
            String sessionId = tUser.getSharedIdForDS();
            if (sessionId.equals(topRouteSidParam)) {
                RecordRouteProxy.processLooseRouting(inRequest, outRequest, sessionId, isJSR289);
            } else {
                RecordRouteProxy.processStrictRouting(inRequest, outRequest, sessionId);
            }
        } else {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{inRequest};
                c_logger.error("error.route.header.unavailable", "Create", args);
            }
            RecordRouteProxy.generateErrorResponse(inRequest);
        }
    }

    private static final void processLooseRouting(SipServletRequest inRequest, OutgoingSipServletRequest outRequest, String sessionId, boolean isJSR289) throws IllegalArgumentException, SipParseException, ServletParseException {
        RouteHeader nextRoute;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{sessionId};
            c_logger.traceEntry((Object)RecordRouteProxy.class, "processLooseRouting", params);
        }
        Request outRequestJain = outRequest.getRequest();
        Request inRequestJain = ((SipServletRequestImpl)inRequest).getRequest();
        if (!isJSR289) {
            String nextSession;
            RouteHeader nextRoute2;
            RouteHeader currentRoute = RecordRouteProxy.getTopRoute(outRequest);
            outRequestJain.removeHeader("Route", true);
            String sessionKey = RecordRouteProxy.getSessionIdParamFromRoute(currentRoute);
            if (sessionKey != null && (nextRoute2 = RecordRouteProxy.getTopRoute(outRequest)) != null && sessionKey.equals(nextSession = RecordRouteProxy.getSessionIdParamFromRoute(nextRoute2))) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(RecordRouteProxy.class, "processLooseRouting", "found two record route headers with the same session id, removing both of them (" + sessionKey + ")");
                }
                outRequestJain.removeHeader("Route", true);
            }
        }
        if (null != (nextRoute = RecordRouteProxy.getTopRoute(outRequest)) && RecordRouteProxy.isStrictRouter(nextRoute)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(RecordRouteProxy.class, "processLooseRouting", "Switching from loose routing to strict routing" + nextRoute);
            }
            outRequestJain.removeHeader("Route", true);
            outRequestJain.setRequestURI(nextRoute.getNameAddress().getAddress());
            NameAddress nameAddr = c_addrFactory.createNameAddress(inRequestJain.getRequestURI());
            outRequestJain.addHeader(c_hdrFactory.createRouteHeader(nameAddr), false);
            RecordRouteProxy.markRequestAsStrictRouting(outRequest);
        }
    }

    private static final void processStrictRouting(SipServletRequest inRequest, OutgoingSipServletRequest outRequest, String sessionId) throws SipParseException, ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{inRequest, outRequest, sessionId};
            c_logger.traceEntry((Object)RecordRouteProxy.class, "processStrictRouting", params);
        }
        Request jainInReq = ((SipServletRequestImpl)inRequest).getRequest();
        Request jainOutReq = outRequest.getRequest();
        String reqURISidParam = RecordRouteProxy.getSessionIdParamFromURI(jainInReq.getRequestURI());
        if (sessionId.equals(reqURISidParam)) {
            RouteHeader nextRoute = RecordRouteProxy.getTopRoute(outRequest);
            jainOutReq.removeHeader("Route", true);
            jainOutReq.setRequestURI(nextRoute.getNameAddress().getAddress());
            RecordRouteProxy.markRequestAsStrictRouting(outRequest);
        } else {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{inRequest};
                c_logger.error("error.processing.strict.routing", "Create", args);
            }
            RecordRouteProxy.generateErrorResponse(inRequest);
        }
    }

    private static void markRequestAsStrictRouting(OutgoingSipServletRequest outRequest) {
        URI uri;
        RouteHeader nextRoute = RecordRouteProxy.getTopRoute(outRequest);
        if (null != nextRoute && (uri = nextRoute.getNameAddress().getAddress()) instanceof SipURL) {
            try {
                ((SipURL)uri).setParameter("ibmsr", "");
            }
            catch (IllegalArgumentException e2) {
                RecordRouteProxy.logException(e2);
            }
            catch (SipParseException e3) {
                RecordRouteProxy.logException(e3);
            }
        }
    }

    private static final void generateErrorResponse(SipServletRequest inRequest) {
        if (inRequest.getMethod().equals("ACK")) {
            return;
        }
        SipRouter.sendErrorResponse((SipServletRequestImpl)inRequest, 400);
    }

    private static final boolean isStrictRouter(RouteHeader route) {
        boolean rc = false;
        URI uri = route.getNameAddress().getAddress();
        if (uri instanceof SipURL) {
            rc = ((SipURL)uri).getParameter(LR) == null;
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{route};
            c_logger.error("error.unkown.uri.type", "Create", args);
        }
        return rc;
    }

    public static final String getSessionIdParamFromRoute(RouteHeader route) {
        return RecordRouteProxy.getSessionIdParamFromURI(route.getNameAddress().getAddress());
    }

    public static final String getSessionIdParamFromURI(URI jainUri) {
        String sid = null;
        if (jainUri instanceof SipURL) {
            sid = ((SipURL)jainUri).getParameter("ibmsid");
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Can't obtain session ID from non sip URI: " + jainUri);
        }
        return sid;
    }

    public static final RouteHeader getTopRoute(SipServletRequest request) {
        RouteHeader topRoute;
        block4: {
            topRoute = null;
            Request jainReq = ((SipServletRequestImpl)request).getRequest();
            try {
                topRoute = (RouteHeader)jainReq.getHeader("Route", true);
            }
            catch (HeaderParseException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.failed.get.route.header", "Create", null, (Throwable)e2);
                }
            }
            catch (IllegalArgumentException e3) {
                if (!c_logger.isErrorEnabled()) break block4;
                c_logger.error("error.failed.get.route.header", "Create", null, (Throwable)e3);
            }
        }
        return topRoute;
    }

    protected static void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception", "Create", null, (Throwable)e2);
        }
    }
}

