/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.matching.SipServletsMatcher;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;

public class ApplicationPathSelector {
    private static final TraceComponent tc = Tr.register(ApplicationPathSelector.class);
    private static final LogMgr c_logger = Log.get(ApplicationPathSelector.class);
    private SipServletsMatcher sipletMatcher = null;
    private SipApplicationRouter applicationRouter = null;
    private SipAppDescManager sipAppDescManager = null;

    public ApplicationPathSelector(SipServletsMatcher sipletMatcher, SipApplicationRouter applicationRouter) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "Ctor", "sipletMatcher= " + sipletMatcher + ", applicationRouter=" + applicationRouter);
        }
        this.sipletMatcher = sipletMatcher;
        this.applicationRouter = applicationRouter;
        this.sipAppDescManager = SipAppDescManager.getInstance();
    }

    public LinkedList<SipAppDesc> getAllApps() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getAllApps");
        }
        return this.sipletMatcher.getAllApps();
    }

    public SipServletDesc findSippletMatch(SipServletRequestImpl request, SipTargetedRequestInfo sipTargetedRequestInfo) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "findSippletMatch");
        }
        if (request.getNextApplication() != null) {
            SipServletDesc matchedSiplet = null;
            matchedSiplet = this.sipletMatcher.matchSipletForApplication(request, request.getNextApplication());
            if (matchedSiplet != null) {
                SipAppDesc appDesc = matchedSiplet.getSipApp();
                this.initSipApp(appDesc);
                return matchedSiplet;
            }
            return null;
        }
        if (request.getDirective() == null) {
            request.setDirective(SipApplicationRoutingDirective.NEW);
        }
        SipServletDesc matchedSiplet = null;
        SipApplicationRouterInfo appInfo = null;
        if (request instanceof IncomingSipServletRequest) {
            request.checkTopRouteDestination(true);
        }
        while (null == matchedSiplet) {
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("\n looking for next application. Calling applicationRouter.getNextApplication() with the following arguments:  \n").append("applicationRouter= " + this.applicationRouter).append(", request.callID=" + request.getCallId()).append(", request.getRegion()=" + request.getRegion()).append(", directive=" + (Object)((Object)request.getDirective())).append(", sipTargetedRequestInfo=" + sipTargetedRequestInfo).append(", request.getStateInfo()=" + request.getStateInfo());
                    c_logger.traceDebug(this, "findSippletMatch", buff.toString());
                }
                if ((appInfo = this.applicationRouter.getNextApplication(request, request.getRegion(), request.getDirective(), sipTargetedRequestInfo, request.getStateInfo())) == null) {
                    c_logger.traceDebug(this, "findSippletMatch", "Application router return null");
                    return null;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "findSippletMatch", "appinfo: " + appInfo);
                }
                if (appInfo.getRouteModifier() != null && (appInfo.getRouteModifier().equals((Object)SipRouteModifier.ROUTE) || appInfo.getRouteModifier().equals((Object)SipRouteModifier.ROUTE_BACK))) {
                    this.routeRequest(request, appInfo);
                    if (request.isExternalRoute()) {
                        return null;
                    }
                }
                this.saveAppInfoDataInTheRequest(request, appInfo);
            }
            catch (Throwable e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "findMatch", "Error in application router", e2);
                }
                request.processCompositionErrorResponse();
                return null;
            }
            if (request.getDirective().equals((Object)SipApplicationRoutingDirective.NEW)) {
                request.setDirective(SipApplicationRoutingDirective.CONTINUE);
            }
            if (appInfo.getNextApplicationName() == null || appInfo.getNextApplicationName().equals("")) {
                if (request.getHeader("Route") != null && PropertiesStore.getInstance().getProperties().getBoolean("routeWhenNoApp")) {
                    request.setExternalRoute(true);
                }
                return null;
            }
            request.setStateInfo(appInfo.getStateInfo());
            matchedSiplet = this.sipletMatcher.matchSipletForApplication(request, appInfo.getNextApplicationName());
            if (!request.isCommitted()) continue;
            return null;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "findSippletMatch");
        }
        SipAppDesc appDesc = matchedSiplet.getSipApp();
        this.initSipApp(appDesc);
        return matchedSiplet;
    }

    public SipAppDesc unloadApplicationConfiguration(String appName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "unloadApplicationConfiguration", "unloadApplicationConfiguration name: " + appName);
        }
        ArrayList<String> undeployedApplications = new ArrayList<String>();
        undeployedApplications.add(appName);
        this.applicationRouter.applicationUndeployed(undeployedApplications);
        return this.sipletMatcher.unloadApplicationConfiguration(appName);
    }

    public SipServletDesc getDefaultHandler() {
        return this.sipletMatcher.getDefaultHandler();
    }

    public SipServletDesc getSipletByName(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSipletByName", "getSipletByName name: " + name);
        }
        return this.sipletMatcher.getSipletByName(name);
    }

    public SipAppDesc getSipApp(String appName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSipApp", "getSipApp name: " + appName);
        }
        return this.sipletMatcher.getSipApp(appName);
    }

    public int getNumOfRunningApplications() {
        return this.sipletMatcher.getNumOfRunningApplications();
    }

    private void saveAppInfoDataInTheRequest(SipServletRequestImpl request, SipApplicationRouterInfo appInfo) {
        if (appInfo.getSubscriberURI() != null) {
            URI subscriberURI;
            block4: {
                String subscriberURIString = appInfo.getSubscriberURI();
                subscriberURI = null;
                try {
                    SipServletsFactoryImpl sipFactory = SipServletsFactoryImpl.getInstance();
                    subscriberURI = sipFactory.createURI(subscriberURIString);
                }
                catch (ServletParseException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block4;
                    c_logger.traceDebug(this, "findMatch", "Unable to construct URI from the subscriberURI sting - " + subscriberURIString);
                }
            }
            request.setSubscriberURI(subscriberURI);
        }
        if (appInfo.getRoutingRegion() != null) {
            request.setRoutingRegion(appInfo.getRoutingRegion());
        }
    }

    private void routeRequest(SipServletRequestImpl request, SipApplicationRouterInfo appInfo) {
        String[] routeArray;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "routeRequest", request, appInfo);
        }
        if ((routeArray = appInfo.getRoutes()).length == 0) {
            return;
        }
        String route = null;
        request.cleanExpiredCompositionHeaders();
        route = routeArray[0];
        if (this.isFirstRouteInternal(request, route, appInfo)) {
            return;
        }
        if (appInfo.getRouteModifier().equals((Object)SipRouteModifier.ROUTE_BACK)) {
            SipURI routeUri = SipUtil.creatLocalRouteHeader(request, appInfo.getStateInfo());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "routeRequest", "AR returned ROUTE_BACK, adding local container route header value: " + routeUri);
            }
            if (routeUri != null) {
                request.pushRoute(routeUri);
            }
        }
        for (int i = routeArray.length - 1; i >= 0; --i) {
            route = routeArray[i];
            this.handleAllRoutes(request, route, appInfo);
        }
        request.setExternalRoute(true);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "routeRequest");
        }
    }

    private void handleAllRoutes(SipServletRequestImpl request, String route, SipApplicationRouterInfo appInfo) {
        this.handleRoute(false, request, route, appInfo);
    }

    private boolean isFirstRouteInternal(SipServletRequestImpl request, String route, SipApplicationRouterInfo appInfo) {
        return this.handleRoute(true, request, route, appInfo);
    }

    private boolean handleFirstRoute(SipURIImpl sipRouteUri, SipServletRequestImpl request, Address routeAddress) {
        boolean secure;
        int port;
        String host = sipRouteUri.getHost();
        if (request.checkIsLocalListeningPoint(host, port = sipRouteUri.getPort(), secure = sipRouteUri.getScheme().equalsIgnoreCase("sips"))) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRoute", "Internal Route: " + sipRouteUri + " pushed to top route of request callID=" + request.getCallId() + ", method= " + request.getMethod() + ", request object= \n" + this);
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRoute", "First route is internal, making available in popped route and ignoring the rest");
            }
            request.setPoppedRoute(routeAddress);
            return true;
        }
        return false;
    }

    private boolean handleRoute(boolean checkFirstRoute, SipServletRequestImpl request, String route, SipApplicationRouterInfo appInfo) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "handleRoute", checkFirstRoute, request, route, appInfo);
        }
        Address routeAddress = null;
        SipURIImpl sipRouteUri = null;
        try {
            SipServletsFactoryImpl sipFactory = SipServletsFactoryImpl.getInstance();
            routeAddress = sipFactory.createAddress(route);
            if (!(routeAddress.getURI() instanceof SipURIImpl)) {
                throw new IllegalArgumentException("Application router info is invalid. Route doesn't contain valid SIP URI " + routeAddress);
            }
            sipRouteUri = (SipURIImpl)routeAddress.getURI();
            if (checkFirstRoute) {
                boolean bl = this.handleFirstRoute(sipRouteUri, request, routeAddress);
                return bl;
            }
            request.pushRoute(sipRouteUri);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRoute", "External Route: " + sipRouteUri + " pushed to top route of request callID=" + request.getCallId() + ", method= " + request.getMethod() + ", request object= \n" + this);
            }
            boolean bl = true;
            return bl;
        }
        catch (ServletParseException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "handleRoute", "Unable to construct URI from the route URI string " + sipRouteUri);
            }
            throw new IllegalArgumentException("Application router info is invalid. Route doesn't contain valid SIP URI " + routeAddress);
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "handleRoute");
            }
        }
    }

    public void loadAppConfiguration(WebApp webApp) {
        ArrayList<String> deployedApplications = new ArrayList<String>();
        SipAppDesc app = this.sipAppDescManager.getSipAppDesc(webApp);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "loadAppConfiguration", "loadAppConfiguration App: " + app);
        }
        deployedApplications.add(app.getApplicationName());
        this.applicationRouter.applicationDeployed(deployedApplications);
        this.sipletMatcher.loadAppConfiguration(this.sipAppDescManager.getSipAppDesc(webApp));
    }

    public void notifyRouterOnDeployedApps() {
        for (SipAppDesc appDesc : this.sipAppDescManager.getSipAppDescs()) {
            this.sipletMatcher.loadAppConfiguration(appDesc);
        }
        this.applicationRouter.applicationDeployed(this.sipAppDescManager.getSipAppNames());
    }

    private void initSipApp(SipAppDesc appDesc) {
        block4: {
            try {
                this.sipAppDescManager.initSipAppIfNeeded(appDesc.getWebAppName());
            }
            catch (ServletException e2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("initSipApp Failed to initalized application: " + appDesc.getApplicationName()), (Object[])new Object[]{e2.getLocalizedMessage()});
                }
            }
            catch (Throwable e3) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("initSipApp Failed to initalized application: " + appDesc.getApplicationName()), (Object[])new Object[]{e3.getLocalizedMessage()});
            }
        }
    }
}

