/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.header.MaxForwardsHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Vector;
import javax.servlet.sip.SipURI;

public class OutgoingSipServletAckRequest
extends OutgoingSipServletRequest {
    private static final LogMgr c_logger = Log.get(OutgoingSipServletAckRequest.class);
    private static final boolean cloneToFromInAck = PropertiesStore.getInstance().getProperties().getBoolean("sipCloneToFromInAck");
    private boolean m_sent;

    public OutgoingSipServletAckRequest() {
        this.m_sent = false;
    }

    public OutgoingSipServletAckRequest(IncomingSipServletResponse response) {
        block2: {
            this.m_sent = false;
            this.setSipProvider(response.getSipProvider());
            this.setIsInital(false);
            this.setIsCommited(false);
            this.setTransactionUser(response.getTransactionUser());
            RequestImpl req = (RequestImpl)((SipServletRequestImpl)response.getRequest()).getRequest();
            Response res = response.getResponse();
            Vector<String> routeHeaders = response.getTransactionUser().getRouteHeaders();
            try {
                SipProvider provider = this.getSipProvider();
                ListeningPointImpl lp = (ListeningPointImpl)provider.getListeningPoint();
                Request ack = this.createClientDialogReq(req, res, routeHeaders, "ACK", lp);
                this.setMessage(ack);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                c_logger.error("error.exception", "Create", null, (Throwable)e2);
            }
        }
        boolean subsequent = response.getStatus() / 100 == 2;
        this.setIsSubsequentRequest(subsequent);
    }

    @Override
    public void updateParamAccordingToDestination() throws IOException {
    }

    @Override
    public void setupParametersBeforeSent(SipURL target, boolean isLoopBack) throws IOException {
        try {
            TransactionUserWrapper tu;
            if (this.checkIsLoopback()) {
                ((MessageImpl)((Object)this.getRequest())).setLoopback(true);
            }
            if ((tu = this.getTransactionUser()) != null) {
                boolean isAddIBMPO = PropertiesStore.getInstance().getProperties().getBoolean("addIBMPOLBMsg");
                if (this.checkIsLoopback() && !isAddIBMPO) {
                    this.removeHeader("IBM-PO");
                } else {
                    SipProxyInfo.getInstance().addPreferedOutboundHeader(this, tu.getPreferedOutboundIface(this.getTransport()));
                }
            }
        }
        catch (SipParseException e2) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{this};
                c_logger.error("error.send.request", "Request", args, (Throwable)e2);
            }
            this.logExceptionToSessionLog(0x100004, e2);
            throw new IOException(e2.getMessage());
        }
    }

    @Override
    public void send() throws IOException {
        super.send();
        this.m_sent = true;
    }

    public boolean wasSent() {
        return this.m_sent;
    }

    public Request createClientDialogReq(Request req, Response res, Vector routeHeaders, String method, ListeningPointImpl lp) throws SipParseException {
        ContactHeader contact;
        LinkedList<RouteHeader> routeSet = null;
        NameAddress remoteTarget = null;
        if (routeHeaders != null) {
            routeSet = new LinkedList<RouteHeader>();
            for (String value : routeHeaders) {
                RouteHeader routeHeader = (RouteHeader)SipJainFactories.getInstance().getHeaderFactory().createHeader("Route", value);
                routeSet.addLast(routeHeader);
            }
        }
        if ((contact = (ContactHeader)res.getHeader("Contact", true)) == null) {
            String msg = "Error, Contact not available in response. Can not send ACK";
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createClientDialogReq", msg);
            }
            throw new SipParseException(msg);
        }
        remoteTarget = contact.getNameAddress();
        long sequenceNumber = req.getCSeqHeader().getSequenceNumber();
        String callId = req.getCallIdHeader().getCallId();
        FromHeader localParty = req.getFromHeader();
        ToHeader remoteParty = res.getToHeader();
        return this.createRequest(lp, method, callId, remoteParty, localParty, sequenceNumber, routeSet, remoteTarget, res.getStatusCode());
    }

    private Request createRequest(ListeningPointImpl lp, String method, String callId, ToHeader remoteParty, FromHeader localParty, long localSequenceNumber, LinkedList routeSet, NameAddress remoteTarget, int responseStatusCode) throws SipParseException {
        Request retVal = null;
        URI reqUri = null;
        HeaderFactory headerFactory = SipJainFactories.getInstance().getHeaderFactory();
        ToHeader toHeader = remoteParty;
        FromHeader fromHeader = localParty;
        if (cloneToFromInAck) {
            toHeader = (ToHeader)toHeader.clone();
            fromHeader = (FromHeader)fromHeader.clone();
        }
        CallIdHeader callIdHeader = headerFactory.createCallIdHeader(callId);
        CSeqHeader cseqHeader = headerFactory.createCSeqHeader(localSequenceNumber, method);
        if (routeSet == null) {
            reqUri = remoteTarget.getAddress();
        } else {
            RouteHeader topRoute = (RouteHeader)routeSet.getFirst();
            URI topRouteUri = topRoute.getNameAddress().getAddress();
            if (!(topRouteUri instanceof SipURL)) {
                throw new IllegalStateException("route set contains non-SIP URI [" + topRouteUri + ']');
            }
            if (((SipURL)topRouteUri).hasParameter("lr")) {
                reqUri = remoteTarget.getAddress();
            } else {
                reqUri = topRoute.getNameAddress().getAddress();
                routeSet.removeFirst();
                RouteHeader routeHeader = SipJainFactories.getInstance().getHeaderFactory().createRouteHeader(remoteTarget);
                routeSet.addLast(routeHeader);
                topRoute = (RouteHeader)routeSet.getFirst();
                ((SipURL)topRouteUri).setParameter("ibmsr", "");
            }
        }
        retVal = this.createRequest(lp, method, toHeader, fromHeader, callIdHeader, cseqHeader, reqUri, responseStatusCode);
        if (routeSet != null && !routeSet.isEmpty()) {
            retVal.setRouteHeaders(routeSet);
        }
        return retVal;
    }

    private Request createRequest(ListeningPointImpl lp, String method, ToHeader toHeader, FromHeader fromHeader, CallIdHeader callIdHeader, CSeqHeader cseqHeader, URI reqUri, int responseStatusCode) throws SipParseException {
        HeaderFactory headerFactory = SipJainFactories.getInstance().getHeaderFactory();
        MaxForwardsHeader maxForwardHeader = headerFactory.createMaxForwardsHeader(70);
        ViaHeader viaHeader = null;
        boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
        if (outboundEnable) {
            viaHeader = this.createViaHeader();
        } else {
            String transport = lp.isSecure() ? "tls" : lp.getTransport();
            viaHeader = headerFactory.createViaHeader(lp.getSentBy(), lp.getPort(), transport);
        }
        if (responseStatusCode >= 200 && responseStatusCode < 300 && !"ACK".equals(method) && !"CANCEL".equals(method)) {
            viaHeader.setBranch(SIPStackUtil.generateBranchId());
        }
        Vector<ViaHeader> viaHeaders = new Vector<ViaHeader>(10);
        viaHeaders.add(viaHeader);
        Request retVal = SipJainFactories.getInstance().getMesssageFactory().createRequest(reqUri, method, callIdHeader, cseqHeader, fromHeader, toHeader, viaHeaders);
        retVal.setMaxForwardsHeader(maxForwardHeader);
        return retVal;
    }

    private ViaHeader createViaHeader() throws IllegalArgumentException, SipParseException {
        ViaHeader viaHeader;
        ListeningPoint lPoint = this.getSipProvider().getListeningPoint();
        String transport = ((ListeningPointImpl)lPoint).isSecure() ? "tls" : lPoint.getTransport();
        TransactionUserWrapper tUser = this.getTransactionUser();
        int index = -1;
        boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
        if (outboundEnable) {
            index = this.getPreferedOutboundIface();
        } else {
            int n = index = null == tUser ? -1 : tUser.getPreferedOutboundIface(transport);
        }
        if (index < 0) {
            viaHeader = this.getHeadersFactory().createViaHeader(lPoint.getPort(), lPoint.getSentBy());
            viaHeader.setTransport(transport);
        } else {
            SipProxyInfo proxyInfo = SipProxyInfo.getInstance();
            SipURI sipURI = proxyInfo.getOutboundInterface(index, transport);
            viaHeader = this.getHeadersFactory().createViaHeader(sipURI.getHost(), sipURI.getPort(), transport);
        }
        return viaHeader;
    }
}

