/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.timer.ExpirationTimer;
import com.ibm.ws.sip.container.timer.ExpirationTimerListener;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;

public class TransactionUserTimerListener
extends ExpirationTimerListener {
    private ExpirationTimer m_timer;
    private TransactionUserWrapper m_transactionUser;

    public TransactionUserTimerListener(TransactionUserWrapper transactionUser) {
        this.m_transactionUser = transactionUser;
        this.m_timer = new ExpirationTimer(this, this.m_transactionUser.getSynchronizer());
    }

    @Override
    protected void invokeExpiredTimer() {
        this.m_transactionUser.transactionUserExpired();
    }

    public long getExpires() {
        return 0L;
    }

    @Override
    public String getId() {
        return this.m_transactionUser.getId();
    }

    @Override
    public void schedule(boolean isPersistent, long delay) {
        SipContainerComponent.getTimerService().schedule(this.m_timer, isPersistent, delay);
    }

    @Override
    public void cancel() {
        this.m_timer.cancel();
    }

    public ExpirationTimer getTimer() {
        return this.m_timer;
    }

    @Override
    public String getApplicationId() {
        return this.m_transactionUser.getApplicationId();
    }

    @Override
    public String getApplicationName() {
        if (this.m_transactionUser != null && this.m_transactionUser.getSipServletDesc() != null) {
            return this.m_transactionUser.getSipServletDesc().getSipApp().getAppName();
        }
        return null;
    }

    @Override
    public Integer getApplicationIdForPMI() {
        if (this.m_transactionUser != null && this.m_transactionUser.getSipServletDesc() != null) {
            return this.m_transactionUser.getSipServletDesc().getSipApp().getAppIndexForPmi();
        }
        return null;
    }

    @Override
    public Object getServiceSynchronizer() {
        return this.m_transactionUser.getServiceSynchronizer();
    }

    TransactionUserWrapper getTuWrapper() {
        return this.m_transactionUser;
    }
}

