/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.tu;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.tu.DialogUsageKey;
import com.ibm.ws.sip.container.tu.DialogUsageKeySet;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.util.wlm.DialogAux;
import java.io.Serializable;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;

public class DialogState
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8342447519148817197L;
    private static final LogMgr c_logger = Log.get(DialogState.class);
    private SipSession.State _state;
    private transient boolean _afterInitialState;
    public static final int IS_DIALOG = 1;
    public static final int NOT_DIALOG = 2;
    public static final int UNSET = 0;
    private int _dialogMode = 0;
    private DialogUsageKeySet _dialogUsages = new DialogUsageKeySet();
    private transient DialogAux _dialogAux = null;

    DialogState() {
        this.reset();
    }

    public final void reset() {
        this._state = SipSession.State.INITIAL;
        this._afterInitialState = false;
        this._dialogMode = 0;
        this._dialogUsages.clear();
        this._dialogAux = null;
    }

    public SipSession.State getState() {
        return this._state;
    }

    public void setDialogState(String method) {
        if (this._dialogMode != 0) {
            return;
        }
        this._dialogMode = SipUtil.isDialogInitialRequest(method) ? 1 : 2;
    }

    public void setSessionState(SipSession.State state, SipServletMessage sipMessage) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "setSessionState", (Object)state);
        }
        SipServletMessageImpl messageImpl = (SipServletMessageImpl)sipMessage;
        DialogUsageKey usageKey = null;
        if (this._dialogMode == 1) {
            switch (state) {
                case INITIAL: 
                case EARLY: 
                case CONFIRMED: {
                    usageKey = SipUtil.getDialogUsageKey(messageImpl);
                    this._dialogUsages.add(usageKey);
                    if (this._state == state) break;
                    this._state = state;
                    break;
                }
                case TERMINATED: {
                    boolean applyToAllDialogUsages = SipUtil.shouldTerminateAllDialogUsages(messageImpl);
                    if (applyToAllDialogUsages) {
                        this._dialogUsages.clear();
                        this._state = SipSession.State.TERMINATED;
                        this.reportDialogTerminated();
                        break;
                    }
                    usageKey = SipUtil.getDialogUsageKey(messageImpl);
                    this._dialogUsages.remove(usageKey);
                    if (!this._dialogUsages.isEmpty()) break;
                    this._state = SipSession.State.TERMINATED;
                    this.reportDialogTerminated();
                }
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setSessionState", " will not update the state - not a dialog");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "setSessionState", (Object)this._state);
        }
    }

    public boolean isDialog() {
        return this._dialogMode == 1;
    }

    public SipSession.State updateState(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "updateState", (Object)this._state);
        }
        if (this._dialogMode == 1) {
            if (this._state != SipSession.State.TERMINATED) {
                if (this.is1xxResponse(response.getStatus()) && this._state != SipSession.State.CONFIRMED) {
                    this.setSessionState(SipSession.State.EARLY, response);
                } else if (this.is2xxResponse(response.getStatus())) {
                    this.setSessionState(SipSession.State.CONFIRMED, response);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "updateState", " dialog has been marked as CONFIRMED.");
                    }
                } else if (response.getStatus() >= 300) {
                    if (this._state == SipSession.State.CONFIRMED) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "updateState", "Confirmed state can not be changed by error response");
                        }
                    } else if (response instanceof OutgoingSipServletResponse) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "updateState", "UAS sends error response on state Initial/Early and will be terminated");
                        }
                        this.setSessionState(SipSession.State.TERMINATED, response);
                    } else {
                        this.setSessionState(SipSession.State.INITIAL, response);
                    }
                }
                this._afterInitialState = false;
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "updateState", "This is not DIALOG Session = " + response);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "updateState", (Object)this._state);
        }
        return this._state;
    }

    void checkIfTerminateRequest(SipServletRequest msg) throws IllegalArgumentException {
        if (this._dialogMode == 1) {
            if (SipUtil.isUsageTerminatingRequest(msg)) {
                this.setSessionState(SipSession.State.TERMINATED, msg);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "checkIfTerminatState", msg.getMethod() + " TERMAINTED session:" + ((SipServletRequestImpl)msg).getTransactionUser().getId());
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkIfTerminateRequest", "Failed to find Subscription-State header");
            }
        }
    }

    boolean canBeInvalidated() {
        boolean canInvalidate = false;
        switch (this._state) {
            case INITIAL: 
            case TERMINATED: {
                canInvalidate = true;
            }
        }
        return canInvalidate;
    }

    private final boolean is1xxResponse(int status) {
        return status >= 100 && status < 200;
    }

    private final boolean is2xxResponse(int status) {
        return status >= 200 && status < 300;
    }

    public void setStateToAfterInitial() {
        this._afterInitialState = true;
    }

    public boolean isAfterInitialState() {
        return this._afterInitialState;
    }

    public String toString() {
        return this._state.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DialogState state = (DialogState)super.clone();
        state._dialogUsages = (DialogUsageKeySet)this._dialogUsages.clone();
        return state;
    }

    public void setDialogAux(DialogAux da) {
        this._dialogAux = da;
    }

    public DialogAux getDialogAux() {
        return this._dialogAux;
    }

    public int getWLMDialogState() {
        int state;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getWLMDialogState");
        }
        switch (this._state) {
            case EARLY: {
                state = 1;
                break;
            }
            case CONFIRMED: {
                state = 2;
                break;
            }
            case TERMINATED: {
                state = 3;
                break;
            }
            default: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getWLMDialogState", "State cannot be INITIAL when call to this method. !!! ");
                }
                state = -1;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getWLMDialogState", new Integer(state));
        }
        return state;
    }

    private void reportDialogTerminated() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "getWLMDialogState", this._dialogAux);
        }
        if (this._dialogAux != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "reportDialogTerminated", "calling WLM hook on termination of dailog");
            }
            this._dialogAux.done();
            this._dialogAux = null;
        }
    }
}

