/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.tu;

import com.ibm.ws.sip.container.tu.DialogUsageKey;
import com.ibm.ws.sip.container.util.SipUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DialogUsageKeySet
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 5788271534706037540L;
    private int m_bitSet = 0;
    private Set<DialogUsageKey> m_set = null;

    public void add(DialogUsageKey key) {
        if (this.m_set == null) {
            String method = key.getMethod();
            String secondary = key.getSecondaryKey();
            if (secondary == null) {
                int bit = SipUtil.getDialogRelatedMethodId(method);
                this.m_bitSet |= 1 << bit;
            } else {
                this.switchMode();
                this.m_set.add(key);
            }
        } else {
            this.m_set.add(key);
        }
    }

    private void switchMode() {
        this.m_set = Collections.synchronizedSet(new HashSet());
        int bitSet = this.m_bitSet;
        int i = 0;
        while (bitSet != 0) {
            int bit = bitSet & 1;
            if (bit == 1) {
                String method = SipUtil.getDialogRelatedMethod(i);
                DialogUsageKey key = DialogUsageKey.instance(method, null);
                this.m_set.add(key);
            }
            bitSet >>= 1;
            ++i;
        }
    }

    public void remove(DialogUsageKey key) {
        if (this.m_set == null) {
            String method = key.getMethod();
            int bit = SipUtil.getDialogRelatedMethodId(method);
            this.m_bitSet &= ~(1 << bit);
        } else {
            this.m_set.remove(key);
        }
    }

    public void clear() {
        if (this.m_set == null) {
            this.m_bitSet = 0;
        } else {
            this.m_set.clear();
        }
    }

    public boolean isEmpty() {
        if (this.m_set == null) {
            return this.m_bitSet == 0;
        }
        return this.m_set.isEmpty();
    }

    public Object clone() {
        DialogUsageKeySet cloned = new DialogUsageKeySet();
        cloned.m_bitSet = this.m_bitSet;
        if (this.m_set == null) {
            cloned.m_set = null;
        } else {
            cloned.m_set = Collections.synchronizedSet(new HashSet());
            cloned.m_set.addAll(this.m_set);
        }
        return cloned;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_bitSet = in.readInt();
        this.m_set = in.readBoolean() ? (Set)in.readObject() : null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.m_bitSet);
        if (this.m_set == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.m_set);
        }
    }
}

