/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.was.ExecutorMessageDispatchingHandler;

public class SIPThreadMonitorListener {
    private static final LogMgr c_logger = Log.get(SIPThreadMonitorListener.class);
    private ExecutorMessageDispatchingHandler m_parent;

    public SIPThreadMonitorListener(ExecutorMessageDispatchingHandler parent) {
        this.m_parent = parent;
    }

    public void threadIsClear(Thread thread, String threadId, long msHunged) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "threadIsClear", thread.getName(), threadId, msHunged);
        }
    }

    public void threadIsClear(String threadName, String threadId, long msHunged) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "threadIsClear", threadName, threadId, msHunged);
        }
    }

    public void threadIsHung(Thread thread, String threadNumber, long timeActiveInMillis) {
        String threadName = thread.getName();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "threadIsHung", threadName, threadNumber, timeActiveInMillis);
        }
        this.m_parent.reportHangedThread(threadName);
    }

    public void threadIsHung(String threadName, String threadId, long msHunged) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "threadIsHung", threadName, threadId, msHunged);
        }
        this.m_parent.reportHangedThread(threadName);
    }

    public String threadIsDumped(Thread thread, String threadNumber, long msHunged) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "threadIsDumped", thread, threadNumber, msHunged);
        }
        return "";
    }
}

