/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was.filters;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.was.DummySipServletRequestResponse;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.container.was.message.SipMessage;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SipFilter
implements Filter {
    private static final LogMgr c_logger = Log.get(SipFilter.class);

    public void init(FilterConfig fc) throws ServletException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "init", fc);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "doFilter", req, res);
        }
        if (req instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            HttpServletResponse httpResponse = (HttpServletResponse)res;
            SipServletRequestImpl sipRequest = null;
            SipServletResponseImpl sipResponse = null;
            SipMessage msg = ThreadLocalStorage.getSipMessage();
            if (msg == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceDebug("doFilter: No SIP message. This will be considered as an HTTP servlet");
                }
                return;
            }
            sipResponse = (SipServletResponseImpl)msg.getResponse();
            sipRequest = (SipServletRequestImpl)msg.getRequest();
            SipServletMessageImpl message = sipResponse != null ? sipResponse : sipRequest;
            message.setHttpServletRequest(httpRequest);
            message.setHttpServletResponse(httpResponse);
            DummySipServletRequestResponse dummy = new DummySipServletRequestResponse(httpRequest, httpResponse);
            ServletRequest request = sipRequest != null ? sipRequest : dummy;
            ServletResponse response = sipResponse != null ? sipResponse : dummy;
            fc.doFilter(request, response);
        } else {
            c_logger.error("error.non.http.request", null, req);
            fc.doFilter(req, res);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "doFilter", new Object[]{req, res});
        }
    }

    public void destroy() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "destroy", null);
        }
    }
}

