/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.SipParseException;
import java.io.CharArrayWriter;

public class Coder {
    private static final boolean s_detectPreEscapedParams = SIPTransactionStack.instance().getConfiguration().detectPreEscapedParams();

    public static boolean isReserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnreserved(char c) {
        return Coder.isAlphanum(c) || Coder.isMark(c);
    }

    public static boolean isAlpha(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public static boolean isAlphanum(char c) {
        return Coder.isAlpha(c) || Coder.isDigit(c);
    }

    public static boolean isMark(char c) {
        switch (c) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isUserUnreserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ';': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static boolean isPasswordUnreserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '=': {
                return true;
            }
        }
        return false;
    }

    public static boolean isParamUnreserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case '/': 
            case ':': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    public static boolean isControl(char c) {
        return '\u0000' <= c && c <= '\u001f';
    }

    public static boolean isSpace(char c) {
        return c == ' ';
    }

    public static boolean isDelim(char c) {
        switch (c) {
            case '\"': 
            case '#': 
            case '%': 
            case '<': 
            case '>': {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnwise(char c) {
        switch (c) {
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '`': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static boolean isExcluded(char c) {
        return Coder.isControl(c) || Coder.isSpace(c) || Coder.isDelim(c) || Coder.isUnwise(c);
    }

    public static boolean isUnescapedTelChars(char c) {
        Boolean isUnescapeHashChar = ApplicationProperties.getProperties().getBoolean("unescapeHashCharInTeluri");
        return isUnescapeHashChar != false && c == '#';
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isHexdig(char c) {
        if (Coder.isDigit(c)) {
            return true;
        }
        return 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    public static boolean isWord(char c) {
        if (Coder.isAlphanum(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '\"': 
            case '%': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '_': 
            case '`': 
            case '{': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isCallId(String s) {
        int length = s.length();
        boolean at = false;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Coder.isWord(c)) continue;
            if (c == '@' && !at && 0 < i && i < length - 1) {
                at = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static void escape(char c, CharsBuffer buf) {
        int i1 = (c & 0xF0) >> 4;
        int i2 = c & 0xF;
        char c1 = Character.forDigit(i1, 16);
        char c2 = Character.forDigit(i2, 16);
        buf.append('%');
        buf.append(Character.toUpperCase(c1));
        buf.append(Character.toUpperCase(c2));
    }

    public static void encode(String data, CharsBuffer buf) {
        if (data == null) {
            return;
        }
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (Coder.isExcluded(c)) {
                Coder.escape(c, buf);
                continue;
            }
            buf.append(c);
        }
    }

    public static void encodeTelURI(String data, CharsBuffer buf) {
        if (data == null) {
            return;
        }
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (Coder.isExcluded(c) && !Coder.isUnescapedTelChars(c)) {
                Coder.escape(c, buf);
                continue;
            }
            buf.append(c);
        }
    }

    public static void encodeUser(String data, CharsBuffer buf) {
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (Coder.isUnreserved(c) || Coder.isUserUnreserved(c)) {
                buf.append(c);
                continue;
            }
            Coder.escape(c, buf);
        }
    }

    public static void encodePassword(String data, CharsBuffer buf) {
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (Coder.isUnreserved(c) || Coder.isPasswordUnreserved(c)) {
                buf.append(c);
                continue;
            }
            Coder.escape(c, buf);
        }
    }

    public static void encodeParam(String data, CharsBuffer buf) {
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            boolean esc = s_detectPreEscapedParams && c == '%' && i < len - 2 && Coder.isHexdig(data.charAt(i + 1)) && Coder.isHexdig(data.charAt(i + 2)) ? false : !Coder.isUnreserved(c) && !Coder.isParamUnreserved(c);
            if (esc) {
                Coder.escape(c, buf);
                continue;
            }
            buf.append(c);
        }
    }

    public static String decode(String component) throws SipParseException {
        if (component == null) {
            return null;
        }
        int len = component.length();
        CharArrayWriter buf = null;
        for (int i = 0; i < len; ++i) {
            char c = component.charAt(i);
            if (c == '%') {
                if (i >= len - 2) {
                    throw new SipParseException("Illegal escaping - expected 2 hex digits, found end of component", component);
                }
                char c1 = component.charAt(++i);
                char c2 = component.charAt(++i);
                int i1 = Character.digit(c1, 16);
                int i2 = Character.digit(c2, 16);
                if (i1 < 0 || i1 > 15 || i2 < 0 || i2 > 15) {
                    throw new SipParseException("Illegal escaping - expected 2 hex digits, found some other character", component);
                }
                char escaped = (char)(i1 << 4 | i2);
                if (buf == null) {
                    buf = CharsBuffersPool.getBuffer();
                    buf.write(component, 0, i - 2);
                }
                ((CharsBuffer)buf).append(escaped);
                continue;
            }
            if (buf == null) continue;
            ((CharsBuffer)buf).append(c);
        }
        if (buf == null) {
            return component;
        }
        String result = buf.toString();
        CharsBuffersPool.putBufferBack((CharsBuffer)buf);
        return result;
    }

    public static boolean isTokenChar(char c) {
        if (Coder.isAlphanum(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '%': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '_': 
            case '`': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isToken(CharSequence s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Coder.isTokenChar(c)) continue;
            return false;
        }
        return true;
    }
}

