/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions.ct;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.dispatch.TimerEvent;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionsModel;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTranaction;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.SipEvent;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public abstract class SIPClientTransactionImpl
extends SIPTransactionImpl
implements SIPClientTranaction {
    private static final LogMgr s_logger = Log.get(SIPClientTransactionImpl.class);
    private Response m_finalResponse;
    private Hop m_hop = null;
    private TimerAPI m_timerAPI;

    public SIPClientTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, long transactionId) {
        super(transactionStack, provider, req, key, transactionId);
    }

    @Override
    public void sendRequestToTransport(Request req) throws SIPTransportException {
        SipProvider provider = this.getProviderContext();
        MessageContext messageContext = MessageContextFactory.instance().getMessageContext(req, (SIPTransaction)this);
        try {
            this.getParentStack().getTransportCommLayerMgr().sendMessage(messageContext, provider, this.getTransportConnection(), this);
        }
        catch (Exception e2) {
            messageContext.writeError(e2);
        }
    }

    @Override
    public void sendResponseToUA(Response sipResponse) {
        SipEvent event = new SipEvent((Object)this.getProviderContext(), this.getId(), sipResponse);
        this.getParentStack().getUACommLayer().sendEventToUA(event);
    }

    @Override
    public void notifyRequestErrorToUA(Request sipRequest) {
        try {
            Response transportErorResponse = SipJainFactories.getInstance().getMesssageFactory().createResponse(503, sipRequest);
            SipStackUtil.addToTag(transportErorResponse);
            SipEvent event = new SipEvent((Object)this.getProviderContext(), this.getId(), transportErorResponse);
            event.setEventId(4);
            this.getParentStack().getUACommLayer().sendEventToUA(event);
        }
        catch (SipException exp) {
            this.getLoger().traceDebug(this, "notifyRequestErrorToUA", exp.getMessage());
        }
    }

    @Override
    public void notifyTransactionTimeoutToUA() {
        SipEvent event = new SipEvent((Object)this.getProviderContext(), this.getId(), false);
        this.getParentStack().getUACommLayer().sendEventToUA(event);
    }

    public final void remove() {
        SIPTransactionsModel.instance().remove(this);
    }

    public final void startAPITimer() {
        this.m_timerAPI = new TimerAPI(this, this.getCallId());
        this.addTimerTask(this.m_timerAPI, 32000L);
    }

    void timerApiFired() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "timerApiFired", "Timer ApiTimer fired on transaction " + this.toString());
        }
        this.remove();
    }

    @Override
    public Response getFinalResponse() {
        return this.m_finalResponse;
    }

    public void setFinalResponse(Response response) {
        this.m_finalResponse = response;
    }

    @Override
    public Hop getHop() {
        return this.m_hop;
    }

    @Override
    public void setHop(Hop hop) {
        this.m_hop = hop;
    }

    @Override
    public String getStateAsString() {
        switch (this.getState()) {
            case 1: {
                return "Proceeding";
            }
            case 2: {
                return "Completed";
            }
            case 3: {
                return "Terminated";
            }
        }
        return super.getStateAsString();
    }

    static class TimerAPI
    extends TimerEvent {
        SIPClientTransactionImpl m_ct;

        TimerAPI(SIPClientTransactionImpl ct, String callId) {
            super(callId);
            this.m_ct = ct;
        }

        @Override
        public void onExecute() {
            if (this.m_ct != null) {
                this.m_ct.timerApiFired();
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }
    }
}

