/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.util.ObjectPool;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.transaction.transport.DefaultBackupMessageSender;
import com.ibm.ws.sip.stack.transaction.transport.IBackupMessageSender;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;

public class BackupMessageSenderFactory {
    private static final LogMgr c_logger = Log.get(BackupMessageSenderFactory.class);
    public static BackupMessageSenderFactory s_instance = null;
    private static final String NAPTR_SENDER_CLASS_STR = "com.ibm.ws.sip.stack.naptr.NaptrSenderStack";
    private static Class s_naptrSenderClass;
    private static ObjectPool s_naptrSenderPool;
    private static boolean s_naptrSenderFound;
    private static boolean s_naptrSenderEnabled;

    private BackupMessageSenderFactory() {
        block2: {
            try {
                s_naptrSenderClass = Class.forName(NAPTR_SENDER_CLASS_STR);
                s_naptrSenderFound = true;
                s_naptrSenderEnabled = BackupMessageSenderFactory.isStackNaptrAutoResolveEnabled();
                int maxPoolSize = ApplicationProperties.getProperties().getInt("maxNaptrSenderPoolSize");
                s_naptrSenderPool = new ObjectPool(s_naptrSenderClass, null, maxPoolSize);
            }
            catch (ClassNotFoundException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block2;
                StringBuffer buff = new StringBuffer();
                buff.append("Could not find the class required for naptr: ");
                buff.append(s_naptrSenderClass);
                c_logger.traceDebug(buff.toString());
            }
        }
    }

    public IBackupMessageSender getBackupSender() {
        if (s_naptrSenderEnabled && s_naptrSenderFound) {
            IBackupMessageSender responseSender = (IBackupMessageSender)s_naptrSenderPool.get();
            responseSender.setIsPoolable(true);
            return responseSender;
        }
        return DefaultBackupMessageSender.getInstance();
    }

    private static boolean isStackNaptrAutoResolveEnabled() {
        boolean result = false;
        SipPropertiesMap sipProp = ApplicationProperties.getProperties();
        boolean autoResolve = sipProp.getBoolean("dnsAutoResolve");
        if (autoResolve) {
            String[] dnsServers = (String[])sipProp.getObject("dnsServers");
            result = dnsServers.length != 0;
        }
        return result;
    }

    public void finishToUseSender(IBackupMessageSender sender) {
        if (sender == null) {
            return;
        }
        if (sender.isPoolable() && s_naptrSenderFound) {
            sender.cleanItself();
            s_naptrSenderPool.putBack(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BackupMessageSenderFactory instance() {
        if (s_instance != null) return s_instance;
        Class<BackupMessageSenderFactory> clazz = BackupMessageSenderFactory.class;
        synchronized (BackupMessageSenderFactory.class) {
            if (s_instance != null) return s_instance;
            s_instance = new BackupMessageSenderFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    static {
        s_naptrSenderPool = null;
        s_naptrSenderFound = false;
        s_naptrSenderEnabled = false;
    }
}

