/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.transaction.transport.SIPConnectionsModel;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.ViaHeader;

public class Hop {
    private static final LogMgr s_logger = Log.get(Hop.class);
    String m_host;
    String m_trasport;
    int m_port;

    public Hop(String transport, String host, int port) {
        this.m_trasport = Hop.transportToUpperCase(transport);
        this.m_host = SIPStackUtil.getHostAddress(host);
        this.m_port = port;
    }

    public Hop(ViaHeader via) {
        String receivedParameter;
        this.m_host = via.hasMAddr() ? via.getMAddr() : ((receivedParameter = via.getParameter("received")) != null ? receivedParameter : SIPStackUtil.getHostAddress(via.getHost()));
        this.m_trasport = Hop.transportToUpperCase(via.getTransport());
        if (this.m_trasport == null) {
            this.m_trasport = Hop.transportToUpperCase("udp");
        }
        this.m_port = via.getRPort();
        if (this.m_port < 0) {
            this.m_port = via.getPort();
            if (this.m_port < 0) {
                this.m_port = this.m_trasport.equalsIgnoreCase("tls") ? 5061 : 5060;
            }
        }
    }

    public Hop(SIPConnection connection) {
        this.m_host = connection.getRemoteHost();
        this.m_trasport = Hop.transportToUpperCase(connection.getTransport());
        this.m_port = connection.hasAliacePort() ? connection.getAliacePort() : connection.getRemotePort();
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public String getTrasport() {
        return this.m_trasport;
    }

    public void setTransport(String transport) {
        this.m_trasport = Hop.transportToUpperCase(transport);
    }

    public String toString() {
        return Hop.toString(this);
    }

    public static String toString(Hop hop) {
        StringBuffer buf = new StringBuffer(hop.getHost());
        buf.append(":");
        buf.append(hop.getPort());
        buf.append("/");
        buf.append(Hop.transportToUpperCase(hop.getTrasport()));
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Hop)) {
            return false;
        }
        Hop otherHop = (Hop)other;
        if (!this.getTrasport().equalsIgnoreCase(otherHop.getTrasport())) {
            return false;
        }
        if (!this.getHost().equalsIgnoreCase(otherHop.getHost())) {
            return false;
        }
        int port = this.getPort();
        int otherPort = otherHop.getPort();
        return port <= 0 || otherPort <= 0 || port == otherPort;
    }

    public int hashCode() {
        return this.m_trasport.hashCode() * this.m_host.hashCode();
    }

    public static Hop getHop(SipURL address) {
        String transport;
        String scheme = address.getScheme();
        String h = address.hasMAddr() ? address.getMAddr() : address.getHost();
        String host = SIPStackUtil.getHostAddress(h);
        int port = address.hasPort() ? address.getPort() : 5060;
        String string = transport = address.hasTransport() ? address.getTransport() : "udp";
        if (scheme.equalsIgnoreCase("sips")) {
            if (!SIPConnectionsModel.instance().isTransportSecure(transport)) {
                transport = SIPConnectionsModel.instance().getDefaultSecureTransport();
            }
            if (!address.hasPort()) {
                port = SIPConnectionsModel.instance().getDefaultSecurePort();
            }
        }
        Hop hop = new Hop(transport, host, port);
        return hop;
    }

    private static String transportToUpperCase(String transport) {
        if (transport.equalsIgnoreCase("UDP")) {
            return "UDP";
        }
        if (transport.equalsIgnoreCase("TCP")) {
            return "TCP";
        }
        if (transport.equalsIgnoreCase("TLS")) {
            return "TLS";
        }
        return transport.toUpperCase();
    }
}

