/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.tcp;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.tcp.SIPConnectionImpl;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SIPListenningConnectionImpl
implements SIPListenningConnection {
    private static final LogMgr c_logger = Log.get(SIPListenningConnectionImpl.class);
    private boolean isRunning;
    private ServerSocket m_sock;
    private ListeningPointImpl m_lp;

    SIPListenningConnectionImpl(ListeningPointImpl lp) {
        this.m_lp = lp;
    }

    @Override
    public SIPConnection createConnection(InetAddress remoteAdress, int remotePort) throws IOException {
        return new SIPConnectionImpl((SIPListenningConnection)this, remoteAdress, remotePort);
    }

    @Override
    public synchronized void listen() throws IOException {
        try {
            InetAddress address = InetAddressCache.getByName(this.m_lp.getHost());
            this.m_sock = new ServerSocket(this.m_lp.getPort(), 0, address);
            this.m_lp.setPort(this.m_sock.getLocalPort());
            Thread thread = new Thread((Runnable)new ConnectionsListener(this), "SIP TCP Connections Listener on " + this.m_lp);
            this.isRunning = true;
            thread.start();
        }
        catch (IOException ex) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "listen", ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    public synchronized void stopListen() {
        this.isRunning = false;
        this.close();
    }

    @Override
    public synchronized void close() {
        block2: {
            try {
                this.m_sock.close();
                this.notifyClosed();
            }
            catch (IOException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block2;
                c_logger.traceDebug(this, "close", e2.getMessage());
            }
        }
    }

    private void notifyConnectionCreated(SIPConnection connection) {
        Dispatcher.instance().queueConnectionAcceptedEvent(this, connection);
    }

    protected void notifyClosed() {
    }

    @Override
    public ListeningPoint getListeningPoint() {
        return this.m_lp;
    }

    public String toString() {
        return this.m_lp.toString();
    }

    public class ConnectionsListener
    implements Runnable {
        SIPListenningConnection m_parent;

        ConnectionsListener(SIPListenningConnection parent) {
            this.m_parent = parent;
        }

        @Override
        public void run() {
            while (SIPListenningConnectionImpl.this.isRunning) {
                try {
                    Socket sock = SIPListenningConnectionImpl.this.m_sock.accept();
                    InetAddress address = sock.getInetAddress();
                    int port = sock.getPort();
                    Hop key = new Hop("TCP", InetAddressCache.getHostAddress(address), port);
                    SIPConnectionImpl connection = new SIPConnectionImpl(this.m_parent, sock);
                    connection.setKey(key);
                    SIPListenningConnectionImpl.this.notifyConnectionCreated(connection);
                }
                catch (IOException ex) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "run", ex.getMessage());
                    }
                    SIPListenningConnectionImpl.this.stopListen();
                }
                catch (Throwable t) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "run", t.getMessage());
                    }
                    SIPListenningConnectionImpl.this.stopListen();
                }
            }
        }
    }
}

