/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.util;

import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import java.util.Date;

public class Debug {
    public static int m_debugLevel = 4;
    private static Date c_date = new Date();
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final void print(String message) {
        Debug.print(4, message);
    }

    public static final void print(int debugLevel, String message) {
        if (debugLevel <= m_debugLevel) {
            System.err.print(message);
        }
    }

    public static final void println(String message) {
        Debug.println(4, message);
    }

    public static final void println(int debugLevel, String message) {
        if (debugLevel <= m_debugLevel) {
            StringBuffer buf = new StringBuffer(Debug.getBasePrefix());
            buf.append(' ');
            buf.append(message);
            buf.append('\n');
            System.out.println(buf.toString());
        }
    }

    public static final void printlnT(int debugLevel, String message) {
        if (debugLevel <= m_debugLevel) {
            c_date.setTime(System.currentTimeMillis());
            StringBuffer buffer = new StringBuffer(message.length() + 30);
            buffer.append(c_date.toString());
            buffer.append(' ');
            buffer.append(message);
            System.err.println(buffer.toString());
        }
    }

    public static final void printException(int debugLevel, String message, Throwable exception) {
        if (debugLevel <= m_debugLevel) {
            if (message != null) {
                System.err.println(message);
            }
            exception.printStackTrace();
        }
    }

    public static final void printByte(int debugLevel, byte n) {
        if (debugLevel > m_debugLevel) {
            return;
        }
        int intValue = n & 0xFF;
        String s = Integer.toHexString(intValue);
        if (s.length() < 2) {
            s = "0" + s;
        }
        System.err.print(s);
    }

    public static final void printByte(int debugLevel, byte[] array) {
        if (debugLevel > m_debugLevel) {
            return;
        }
        for (int i = 0; i < array.length; i += 16) {
            int j;
            System.err.println("");
            Debug.printByte(debugLevel, (byte)(i >> 8));
            Debug.printByte(debugLevel, (byte)(i & 0xFF));
            System.err.print(" -  ");
            int toPrint = array.length - i;
            int thisLine = toPrint > 16 ? 16 : toPrint;
            for (j = 0; j < thisLine; ++j) {
                Debug.printByte(debugLevel, array[i + j]);
                System.err.print(" ");
            }
            if (thisLine < 16) {
                while (j < 16) {
                    System.err.print("   ");
                    ++j;
                }
            }
            for (j = 0; j < thisLine; ++j) {
                if (array[i + j] > 32 && array[i + j] <= 127) {
                    System.err.print("" + (char)array[i + j]);
                    continue;
                }
                System.err.print(".");
            }
        }
        System.err.println("");
    }

    public static void hexDump(byte[] buffer, int offset, int length, StringBuffer dest) {
        int index = 0;
        while (length > 0) {
            byte b;
            int i;
            Debug.appendHexNumber(index, dest, 4);
            dest.append("  ");
            int count = length > 16 ? 16 : length;
            for (i = 0; i < count; ++i) {
                b = buffer[offset + i];
                dest.append(hexDigits[b >> 4 & 0xF]);
                dest.append(hexDigits[b & 0xF]);
                dest.append(i == 7 ? (char)':' : ' ');
            }
            while (i < 16) {
                dest.append("   ");
                ++i;
            }
            dest.append(' ');
            for (i = 0; i < count; ++i) {
                b = buffer[offset + i];
                boolean printable = 32 <= b && b <= 126;
                dest.append((char)(printable ? (int)b : 46));
            }
            dest.append('\n');
            offset += count;
            index += count;
            length -= count;
        }
    }

    private static void appendHexNumber(int value, StringBuffer buffer, int pad) {
        char dig = hexDigits[value % 16];
        int remain = value / 16;
        if (remain > 0) {
            Debug.appendHexNumber(remain, buffer, pad - 1);
        } else {
            for (int i = 1; i < pad; ++i) {
                buffer.append('0');
            }
        }
        buffer.append(dig);
    }

    public static final void stAssert(boolean condition) {
        if (!condition && m_debugLevel != 0) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    public static final boolean isDebug() {
        return m_debugLevel >= 4;
    }

    public static final boolean isDebugLevel(int level) {
        return m_debugLevel >= level;
    }

    private static String getBasePrefix() {
        return c_date + " [SIPStack]: Thread: " + Thread.currentThread().getName();
    }

    static {
        m_debugLevel = ApplicationProperties.getProperties().getInt("traceLevel");
        if (m_debugLevel != 4) {
            System.out.println("Debug level set to: " + m_debugLevel);
        }
    }
}

