/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import java.util.LinkedList;

public class ThreadPool
implements Runnable {
    private static ThreadPool s_instance = new ThreadPool();
    private static final LogMgr s_logger = Log.get(ThreadPool.class);
    private LinkedList m_queue = new LinkedList();
    private static final int s_numberOfThreads = SIPTransactionStack.instance().getConfiguration().getNumberOfApplicationThreads();
    private final Thread[] m_threads;

    public static ThreadPool instance() {
        return s_instance;
    }

    private ThreadPool() {
        Thread[] threadArray = this.m_threads = s_numberOfThreads == 0 ? null : new Thread[s_numberOfThreads];
        if (this.m_threads != null) {
            for (int i = 0; i < this.m_threads.length; ++i) {
                Thread thread = new Thread((Runnable)this, "SipAppThread-" + i);
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable event) {
        if (event == null) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Error: null event queued in ThreadPool");
            }
            return;
        }
        if (this.m_threads == null) {
            this.invokeProtected(event);
        } else {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                this.m_queue.addLast(event);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImmediately(Runnable event) {
        if (event == null) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Error: null event queued (immediately) in ThreadPool");
            }
            return;
        }
        if (this.m_threads == null) {
            this.invokeProtected(event);
        } else {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                this.m_queue.addLast(event);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("ThreadPool thread started");
        }
        try {
            while (true) {
                Runnable event;
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    if (this.m_queue.isEmpty()) {
                        this.wait();
                    }
                    event = this.m_queue.isEmpty() ? null : (Runnable)this.m_queue.removeFirst();
                }
                if (event == null) {
                    if (!s_logger.isTraceDebugEnabled()) continue;
                    s_logger.traceDebug("Error: ThreadPool awakened for no reason");
                    continue;
                }
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("in event.run");
                }
                this.invokeProtected(event);
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("out event.run");
                }
                event = null;
            }
        }
        catch (InterruptedException e2) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "run", "InterruptedException", e2);
            }
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("ThreadPool thread terminated");
            }
            return;
        }
    }

    private void invokeProtected(Runnable event) {
        block2: {
            try {
                event.run();
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.stack.transaction.util.ThreadPool.invokeProtected", (String)"1", (Object)this);
                if (!s_logger.isTraceDebugEnabled()) break block2;
                s_logger.traceDebug("Unhandled exception in SIP stack invocation thread");
                s_logger.traceDebug(this, "invokeProtected", "Exception", e2);
            }
        }
    }
}

