/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.converge;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.session.SessionApplicationParameters;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.session.impl.SessionContextRegistryImpl;
import com.ibm.wsspi.sip.converge.ConvergedHttpSessionContextImpl;
import javax.servlet.http.HttpSession;

public class SessionContextRegistryConvergedImpl
extends SessionContextRegistryImpl {
    private static final transient LogMgr c_logger = Log.get(SessionContextRegistryConvergedImpl.class);

    public SessionContextRegistryConvergedImpl(SessionManager smgr) {
        super(smgr);
    }

    protected IHttpSessionContext createSessionContextObject(SessionManagerConfig smc, SessionApplicationParameters sap) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceDebug((Object)this, "createSessionContextObject", "For APP = " + sap.getApplicationSessionName());
        }
        return new ConvergedHttpSessionContextImpl(smc, sap, this.smgr.getSessionStoreService());
    }

    public HttpSession getHttpSessionById(String virtualHost, String contextRoot, String sessionId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getHttpSessionById", (Object)("sessionID = " + sessionId));
        }
        HttpSession sess = null;
        ConvergedHttpSessionContextImpl wsCtx = SessionContextRegistryConvergedImpl.getSessionContextByName(virtualHost + contextRoot);
        if (wsCtx == null) {
            wsCtx = contextRoot.startsWith("/") ? SessionContextRegistryConvergedImpl.getSessionContextByName(virtualHost + contextRoot.substring(1)) : SessionContextRegistryConvergedImpl.getSessionContextByName(virtualHost + "/" + contextRoot);
        }
        if (wsCtx != null) {
            sess = wsCtx.getHttpSessionById(sessionId);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getHttpSessionById", "sessionID = " + sess.getId());
        }
        return sess;
    }

    private static ConvergedHttpSessionContextImpl getSessionContextByName(String appname) {
        return (ConvergedHttpSessionContextImpl)((Object)scrSessionContexts.get(appname));
    }
}

