/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.sip;

import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.EventObject;

public class SipEvent
extends EventObject {
    public static final int RESPONSE_RECEIVED = 1;
    public static final int REQUEST_RECEIVED = 2;
    public static final int TRANSACTION_TIMEOUT = 3;
    public static final int ERROR_RESPONSE_CREATED_INTERNALLY = 4;
    private Message message = null;
    private int eventId = -1;
    private boolean isServerTransaction = false;
    private long transactionId = 0L;

    public SipEvent(Object source, long clientTransactionId, Response response) throws IllegalArgumentException {
        super(source);
        if (response == null) {
            throw new IllegalArgumentException("response cannot be null");
        }
        this.message = response;
        this.transactionId = clientTransactionId;
        this.isServerTransaction = false;
        this.eventId = 1;
    }

    public SipEvent(Object source, long transactionId, boolean isServerTransaction) throws IllegalArgumentException {
        super(source);
        this.transactionId = transactionId;
        this.isServerTransaction = isServerTransaction;
        this.eventId = 3;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public boolean isServerTransaction() {
        return this.isServerTransaction;
    }

    public Message getMessage() {
        return this.message;
    }

    public SipEvent(Object source, long serverTransactionId, Request request) throws IllegalArgumentException {
        super(source);
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        this.message = request;
        this.transactionId = serverTransactionId;
        this.isServerTransaction = true;
        this.eventId = 2;
    }

    public int getEventId() {
        return this.eventId;
    }

    public void setEventId(int event_id) {
        this.eventId = event_id;
    }
}

